/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.biopax.paxtools.controller.Integrator;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.io.jena.JenaEditorMap;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.io.sif.level2.ComponentRule;
import org.biopax.paxtools.io.sif.level2.ConsecutiveCatalysisRule;
import org.biopax.paxtools.io.sif.level2.ControlRule;
import org.biopax.paxtools.io.sif.level2.ControlsTogetherRule;
import org.biopax.paxtools.io.sif.level2.ParticipatesRule;
import org.biopax.paxtools.io.simpleIO.SimpleExporter;
import org.biopax.paxtools.model.Model;

public class PaxtoolsMain {
    private static final String CLASS_NAME = "PaxtoolsMain";

    public static void main(String[] argv) throws IOException, InvocationTargetException, IllegalAccessException {
        JenaIOHandler jenaIO = new JenaIOHandler();
        if (argv.length < 1) {
            PaxtoolsMain.showHelp();
        }
        for (int count = 0; count < argv.length; ++count) {
            Model model;
            SimpleExporter simpleIO;
            Model model2;
            Model model1;
            if (argv[count].equals("--help")) {
                PaxtoolsMain.showHelp();
                continue;
            }
            if (argv[count].equals("--merge")) {
                if (argv.length <= count + 3) {
                    PaxtoolsMain.showHelp();
                }
                model1 = PaxtoolsMain.getModel(jenaIO, argv[count + 1]);
                model2 = PaxtoolsMain.getModel(jenaIO, argv[count + 2]);
                Merger merger = new Merger(new JenaEditorMap());
                merger.merge(model1, model2);
                simpleIO = new SimpleExporter(model1.getLevel());
                simpleIO.convertToOWL(model1, new FileOutputStream(argv[count + 3]));
                continue;
            }
            if (argv[count].equals("--integrate")) {
                if (argv.length <= count + 3) {
                    PaxtoolsMain.showHelp();
                }
                model1 = PaxtoolsMain.getModel(jenaIO, argv[count + 1]);
                model2 = PaxtoolsMain.getModel(jenaIO, argv[count + 2]);
                Integrator integrator = new Integrator(model1, model2);
                integrator.integrate();
                simpleIO = new SimpleExporter(model1.getLevel());
                simpleIO.convertToOWL(model1, new FileOutputStream(argv[count + 3]));
                continue;
            }
            if (argv[count].equals("--to-sif")) {
                if (argv.length <= count + 2) {
                    PaxtoolsMain.showHelp();
                }
                model = PaxtoolsMain.getModel(jenaIO, argv[count + 1]);
                SimpleInteractionConverter sic = new SimpleInteractionConverter(new ComponentRule(), new ConsecutiveCatalysisRule(), new ControlRule(), new ControlsTogetherRule(), new ParticipatesRule());
                sic.writeInteractionsInSIF(model, new FileOutputStream(argv[count + 2]));
                continue;
            }
            if (!argv[count].equals("--validate")) continue;
            try {
                model = PaxtoolsMain.getModel(jenaIO, argv[count + 1]);
                System.out.println("Model is valid");
                continue;
            }
            catch (Exception e) {
                System.err.println("Model is not valid:");
                System.err.println("" + e);
                System.exit(-1);
            }
        }
        System.exit(0);
    }

    private static void showHelp() {
        System.err.println("Invalid usage: PaxtoolsMain\n\nAvaliable operations:\n--merge file1 file2 output\t\tmerges file2 into file1 and writes it into output\n--to-sif file1 output\t\t\tconverts model to simple interaction format\n--validate file1\t\t\t\tvalidates BioPAX model file1\n--integrate file1 file2 output\tintegrates file2 into file1 and writes it into output (experimental)\n\n--help\t\t\t\t\t\tprints this screen and exits");
        System.exit(-1);
    }

    private static Model getModel(JenaIOHandler jenaIO, String fName) throws FileNotFoundException {
        FileInputStream file = new FileInputStream(fName);
        return jenaIO.convertFromOWL(file);
    }
}

