/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.Method;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitivePropertyEditor
extends PropertyEditor {
    private Object unknownValue = null;

    public PrimitivePropertyEditor(String property, Method getMethod, Class<? extends BioPAXElement> domain, Class range, boolean multipleCardinality) {
        super(property, getMethod, domain, range, multipleCardinality);
        assert (this.range.isPrimitive());
        if (this.range.equals(Double.TYPE)) {
            this.unknownValue = Double.NaN;
        } else if (this.range.equals(Float.TYPE)) {
            this.unknownValue = Float.valueOf(Float.NaN);
        } else if (this.range.equals(Integer.TYPE)) {
            this.unknownValue = Integer.MIN_VALUE;
        }
    }

    @Override
    protected void invokeMethod(Method toInvoke, Object bean, Object o) {
        if (o.getClass().equals(this.range)) {
            super.invokeMethod(toInvoke, bean, o);
        } else if (o.getClass().equals(String.class)) {
            String s = (String)o;
            try {
                if (this.range.equals(Double.TYPE)) {
                    super.invokeMethod(toInvoke, bean, Double.valueOf(s));
                } else if (this.range.equals(Float.TYPE)) {
                    super.invokeMethod(toInvoke, bean, Float.valueOf(s));
                } else if (this.range.equals(Integer.TYPE)) {
                    super.invokeMethod(toInvoke, bean, Integer.valueOf(s));
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)("Failed to convert literal " + s + " to " + this.range + " for " + this.property));
            }
        }
    }

    @Override
    public boolean isUnknown(Object value) {
        return value.equals(this.unknownValue);
    }
}

