/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Factory;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;

public class ReusedPEPHelper {
    private static Log log = LogFactory.getLog(ReusedPEPHelper.class);
    private Model model;
    private Level2Factory factory;
    private Map<physicalEntityParticipant, physicalEntityParticipant> duplicatedPeps;

    public ReusedPEPHelper(Model model, Level2Factory factory) {
        this.model = model;
        this.factory = factory;
        this.duplicatedPeps = new HashMap<physicalEntityParticipant, physicalEntityParticipant>();
    }

    public Object fixReusedPEP(physicalEntityParticipant pep, BioPAXElement bpe) {
        if (this.duplicated(pep, bpe)) {
            log.warn((Object)(pep.getRDFId() + " is reused, duplicating it to fix"));
            physicalEntityParticipant duplicated = (physicalEntityParticipant)this.factory.reflectivelyCreate(pep.getModelInterface());
            String syntheticID = this.createSyntheticID(pep, bpe);
            if (this.model.getIdMap().containsKey(syntheticID)) {
                pep = (physicalEntityParticipant)this.model.getIdMap().get(syntheticID);
            } else {
                duplicated.setRDFId(syntheticID);
                this.duplicatedPeps.put(duplicated, pep);
                this.model.add(duplicated);
                pep = duplicated;
            }
        }
        return pep;
    }

    private boolean duplicated(physicalEntityParticipant pep, BioPAXElement bpe) {
        boolean result = false;
        if (!pep.isPARTICIPANTSof().isEmpty()) {
            if (pep.isPARTICIPANTSof().iterator().next().equals(bpe)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unexpected multiple participant statements");
                }
            } else {
                result = true;
            }
        } else if (pep.isCOMPONENTof() != null) {
            if (pep.isCOMPONENTof().equals(bpe)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unexpected multiple participant statements");
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private String createSyntheticID(physicalEntityParticipant pep, BioPAXElement bpe) {
        return "http://patywaycommons.org/synthetic" + this.createDataStringFromURI(pep.getRDFId(), bpe.getRDFId());
    }

    private String createDataStringFromURI(String ... uris) {
        String ssp = "";
        String fragment = "";
        for (String uri : uris) {
            try {
                URI suri = new URI(uri);
                ssp = ssp + suri.getSchemeSpecificPart() + "|";
                fragment = fragment + suri.getFragment() + "|";
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return ssp + "#" + fragment;
    }

    public void copyPEPFields() {
        Set<physicalEntityParticipant> physicalEntityParticipants = this.duplicatedPeps.keySet();
        for (physicalEntityParticipant dup : physicalEntityParticipants) {
            this.copyPEPFields(dup, this.duplicatedPeps.get(dup));
        }
    }

    private void copyPEPFields(physicalEntityParticipant duplicated, physicalEntityParticipant pep) {
        duplicated.setCELLULAR_LOCATION(pep.getCELLULAR_LOCATION());
        duplicated.setCOMMENT(pep.getCOMMENT());
        duplicated.setSTOICHIOMETRIC_COEFFICIENT(pep.getSTOICHIOMETRIC_COEFFICIENT());
        duplicated.setPHYSICAL_ENTITY(pep.getPHYSICAL_ENTITY());
        if (pep instanceof sequenceParticipant) {
            Set<sequenceFeature> sfSet = ((sequenceParticipant)pep).getSEQUENCE_FEATURE_LIST();
            for (sequenceFeature sf : sfSet) {
                ((sequenceParticipant)duplicated).addSEQUENCE_FEATURE_LIST(sf);
            }
        }
    }
}

