/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.io.jena.JenaEditorMap;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.util.ClassFilterSet;

public class ProteinNameLister {
    private static Log log = LogFactory.getLog(ProteinNameLister.class);
    private static Fetcher fetcher;

    public static void main(String[] args) {
        JenaIOHandler jenaIOHandler = new JenaIOHandler(null, BioPAXLevel.L2);
        String pathname = "testfiles";
        File testDir = new File(pathname);
        fetcher = new Fetcher(new JenaEditorMap(BioPAXLevel.L2));
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("owl");
            }
        };
        for (String s : testDir.list(filter)) {
            try {
                ProteinNameLister.process(pathname, s, jenaIOHandler);
            }
            catch (Exception e) {
                log.error((Object)("Failed at testing " + s), (Throwable)e);
            }
        }
    }

    private static void process(String pathname, String name, JenaIOHandler jenaIOHandler) throws FileNotFoundException {
        System.out.println("--------------" + name + "---------");
        Model model = jenaIOHandler.convertFromOWL(new FileInputStream(pathname + "/" + name));
        ProteinNameLister.listProteinUnificationXrefsPerPathway(model);
    }

    public static void listProteinUnificationXrefsPerPathway(Model model) {
        Set<pathway> pathways = model.getObjects(pathway.class);
        for (pathway aPathway : pathways) {
            System.out.println(aPathway.getNAME());
            Model onePathwayModel = BioPAXLevel.L2.getDefaultFactory().createModel();
            fetcher.fetch(aPathway, onePathwayModel);
            Set<protein> proteins = onePathwayModel.getObjects(protein.class);
            for (protein aProtein : proteins) {
                System.out.println("\t" + aProtein.getNAME());
                ClassFilterSet<unificationXref> xrefs = new ClassFilterSet<unificationXref>(aProtein.getXREF(), unificationXref.class);
                for (unificationXref x : xrefs) {
                    System.out.println("\t\t" + x.getDB() + ":" + x.getID());
                }
            }
        }
    }
}

