/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.impl.level3.NameHelper;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BioSourceImpl
extends L3ElementImpl
implements BioSource {
    private NameHelper nameHelper = new NameHelper();
    private UnificationXref taxonXref;
    private CellVocabulary celltype;
    private TissueVocabulary tissue;

    @Override
    public Class<? extends BioPAXElement> getModelInterface() {
        return BioSource.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        BioSource BioSource2 = (BioSource)element;
        return (this.celltype != null ? this.celltype.equals(BioSource2.getCellType()) : BioSource2.getCellType() == null) && (this.taxonXref != null ? this.taxonXref.equals(BioSource2.getTaxonXref()) : BioSource2.getTaxonXref() == null) && (this.tissue != null ? !this.tissue.equals(BioSource2.getTissue()) : BioSource2.getTissue() != null);
    }

    @Override
    public int equivalenceCode() {
        int result = 29 + (this.taxonXref != null ? this.taxonXref.hashCode() : 0);
        result = 29 * result + (this.celltype != null ? this.celltype.hashCode() : 0);
        result = 29 * result + (this.tissue != null ? this.tissue.hashCode() : 0);
        return result;
    }

    @Override
    public CellVocabulary getCellType() {
        return this.celltype;
    }

    @Override
    public void setCellType(CellVocabulary celltype) {
        this.celltype = celltype;
    }

    @Override
    public UnificationXref getTaxonXref() {
        return this.taxonXref;
    }

    @Override
    public void setTaxonXref(UnificationXref taxonXref) {
        this.taxonXref = taxonXref;
    }

    @Override
    public TissueVocabulary getTissue() {
        return this.tissue;
    }

    @Override
    public void setTissue(TissueVocabulary tissue) {
        this.tissue = tissue;
    }

    @Override
    public Set<String> getName() {
        return this.nameHelper.getName();
    }

    @Override
    public void setName(Set<String> name) {
        this.nameHelper.setName(name);
    }

    @Override
    public void addName(String name) {
        this.nameHelper.addName(name);
    }

    @Override
    public void removeName(String name) {
        this.nameHelper.removeName(name);
    }

    @Override
    public String getDisplayName() {
        return this.nameHelper.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.nameHelper.setDisplayName(displayName);
    }

    @Override
    public String getStandardName() {
        return this.nameHelper.getStandardName();
    }

    @Override
    public void setStandardName(String standardName) {
        this.nameHelper.setStandardName(standardName);
    }
}

