/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMapAdapter;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaEditorMap
extends EditorMapAdapter {
    private static Log log = LogFactory.getLog(JenaEditorMap.class);

    public JenaEditorMap() {
        this(null);
    }

    public JenaEditorMap(BioPAXLevel level) {
        super(level);
        OntModel ontologyDefinition = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        ontologyDefinition.read(this.level.getLevelFileAsStream(), this.level.getNameSpace());
        this.preprocessClasses(ontologyDefinition);
        this.preprocessProperties(ontologyDefinition);
        this.preprocessRestrictions(ontologyDefinition);
    }

    private void preprocessClasses(OntModel model) {
        ExtendedIterator extendedIterator = model.listClasses();
        while (extendedIterator.hasNext()) {
            OntClass ontClass = (OntClass)extendedIterator.next();
            if (!this.isInBioPAXNameSpace(ontClass.getNameSpace())) continue;
            this.detectAndRegisterImplementingClass(ontClass);
        }
    }

    private void detectAndRegisterImplementingClass(OntClass ontClass) {
        try {
            String localName = ontClass.getLocalName();
            this.classToEditorMap.put(this.getModelInterface(localName), new HashSet());
        }
        catch (IllegalBioPAXArgumentException e) {
            log.info((Object)("No factory method for " + ontClass + ".Skipping."));
        }
    }

    private void preprocessProperties(OntModel model) {
        ExtendedIterator extendedIterator = model.listDatatypeProperties();
        this.iteratePropertiesAndResolveDomain(extendedIterator);
        extendedIterator = model.listObjectProperties();
        this.iteratePropertiesAndResolveDomain(extendedIterator);
    }

    private void iteratePropertiesAndResolveDomain(ExtendedIterator extendedIterator) {
        while (extendedIterator.hasNext()) {
            String nameSpace;
            OntProperty property = (OntProperty)extendedIterator.next();
            OntResource domain = property.getDomain();
            if (domain == null) {
                OntProperty superProperty = property;
                while (domain == null) {
                    superProperty = superProperty.getSuperProperty();
                    domain = superProperty.getDomain();
                }
            }
            if (this.isInBioPAXNameSpace(nameSpace = domain.getNameSpace())) {
                this.createAndRegisterBeanEditor(property, domain.asClass());
                continue;
            }
            ExtendedIterator unionSetClassIterator = ((UnionClass)domain.as(UnionClass.class)).listOperands();
            while (unionSetClassIterator.hasNext()) {
                OntClass ontClass = (OntClass)unionSetClassIterator.next();
                this.createAndRegisterBeanEditor(property, ontClass);
            }
        }
    }

    private void createAndRegisterBeanEditor(OntProperty property, OntClass ontClass) {
        String pName;
        Class<? extends BioPAXElement> javaClass = this.extractClass((Resource)ontClass);
        PropertyEditor editor = PropertyEditor.createPropertyEditor(javaClass, pName = property.getLocalName());
        if (editor != null) {
            HashSet<PropertyEditor> beanEditorsForProperty = (HashSet<PropertyEditor>)this.propertyToEditorMap.get(pName);
            if (beanEditorsForProperty == null) {
                beanEditorsForProperty = new HashSet<PropertyEditor>();
            }
            beanEditorsForProperty.add(editor);
            this.propertyToEditorMap.put(pName, beanEditorsForProperty);
            for (Class c : this.classToEditorMap.keySet()) {
                if (!editor.getDomain().isAssignableFrom(c)) continue;
                if (pName.equals("PARTICIPANTS") && (conversion.class.isAssignableFrom(c) || control.class.isAssignableFrom(c)) || pName.equals("participant") && (Conversion.class.isAssignableFrom(c) || Control.class.isAssignableFrom(c))) {
                    log.info((Object)"skipping restricted participant property");
                    continue;
                }
                ((Set)this.classToEditorMap.get(c)).add(editor);
            }
        } else {
            log.warn((Object)("property = " + property));
            log.warn((Object)("javaClass = " + javaClass));
        }
    }

    private void preprocessRestrictions(OntModel model) {
        ExtendedIterator extendedIterator = model.listRestrictions();
        while (extendedIterator.hasNext()) {
            Restriction restriction = (Restriction)extendedIterator.next();
            OntProperty ontProperty = restriction.getOnProperty();
            Set propertyEditors = (Set)this.propertyToEditorMap.get(ontProperty.getLocalName());
            ExtendedIterator iterator = restriction.listSubClasses(true);
            while (iterator.hasNext()) {
                OntClass ontClass = (OntClass)iterator.next();
                Class<? extends BioPAXElement> domain = this.extractClass((Resource)ontClass);
                for (PropertyEditor propertyEditor : propertyEditors) {
                    if (!propertyEditor.getDomain().isAssignableFrom(domain) || !restriction.isAllValuesFromRestriction()) continue;
                    AllValuesFromRestriction valuesFromRestriction = restriction.asAllValuesFromRestriction();
                    if (!(propertyEditor instanceof ObjectPropertyEditor)) continue;
                    OntClass values = (OntClass)valuesFromRestriction.getAllValuesFrom().as(OntClass.class);
                    Set<Class> ranges = this.getSetOfJavaClasses(values);
                    ((ObjectPropertyEditor)propertyEditor).addRangeRestriction(domain, ranges);
                }
            }
        }
    }

    private Class<? extends BioPAXElement> extractClass(Resource resource) {
        String localName = this.getJavaName(resource);
        return this.getModelInterface(localName);
    }

    private String getJavaName(Resource resource) {
        return resource.getLocalName().replaceAll("-", "_");
    }

    private Set<Class> getSetOfJavaClasses(OntClass values) {
        HashSet<Class> set = new HashSet<Class>();
        this.recursivelyTraverse(values, set);
        assert (!set.isEmpty());
        return set;
    }

    private void recursivelyTraverse(OntClass values, HashSet<Class> set) {
        if (values.isUnionClass()) {
            UnionClass unionClass = values.asUnionClass();
            ExtendedIterator iterator1 = unionClass.listOperands();
            while (iterator1.hasNext()) {
                this.recursivelyTraverse((OntClass)iterator1.next(), set);
            }
        } else {
            set.add(this.extractClass((Resource)values));
        }
    }

    public XSDDatatype getDataTypeFor(PropertyEditor editor) {
        Class range = editor.getRange();
        XSDDatatype type = null;
        if (range.isEnum() || range.equals(String.class)) {
            type = XSDDatatype.XSDstring;
        } else if (range.equals(Double.TYPE)) {
            type = XSDDatatype.XSDdouble;
        } else if (range.equals(Integer.TYPE)) {
            type = XSDDatatype.XSDint;
        } else if (range.equals(Float.TYPE)) {
            type = XSDDatatype.XSDfloat;
        }
        return type;
    }

    void writeSimpleEditorMapProperties(OutputStream out) throws IOException {
        PrintStream stream = new PrintStream(out);
        Set classes = this.classToEditorMap.keySet();
        for (Class key : classes) {
            Set editors = (Set)this.classToEditorMap.get(key);
            for (PropertyEditor editor : editors) {
                stream.println(key.getSimpleName() + " " + editor.getDomain().getSimpleName() + " " + editor.getProperty());
            }
        }
        stream.close();
    }
}

