/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.pathwayCommons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathwayCommonsIOHandler {
    JenaIOHandler baseHandler;
    Merger merger;
    public static final String default_prefix = "http://www.pathwaycommons.org/pc/webservice.do?";
    private String prefix = "http://www.pathwaycommons.org/pc/webservice.do?";
    public static final String default_output_format = "biopax";
    private String output_format = "biopax";
    public static final String version = "version=";
    public static final String command = "cmd=";
    public static final String input_id_type = "input_id_type=";
    public static final String output_id_type = "output_id_type=";
    public static final String data_source = "data_source=";
    private static final String output = "output=";
    public static final String default_version = "2.0";
    private String versionID = "2.0";
    private ID_TYPE inputIdType = ID_TYPE.DEFAULT;
    private ID_TYPE outputIdType = ID_TYPE.DEFAULT;
    private DATA_SRC dataSource = DATA_SRC.DEFAULT;

    public PathwayCommonsIOHandler() {
        this(null, null);
    }

    public PathwayCommonsIOHandler(BioPAXLevel level, BioPAXFactory factory) {
        this.baseHandler = new JenaIOHandler(factory, level);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setInputIdType(ID_TYPE newInputIdType) {
        this.inputIdType = newInputIdType;
    }

    public void setOutputIdType(ID_TYPE newOutputIdType) {
        this.outputIdType = newOutputIdType;
    }

    public void setDataSource(DATA_SRC newDataSource) {
        this.dataSource = newDataSource;
    }

    private InputStream openURL(String urlName) throws IOException {
        URL url = new URL(urlName);
        URLConnection urlConnection = url.openConnection();
        return urlConnection.getInputStream();
    }

    private Model readBioPAXfromURL(String urlName) throws IOException {
        return this.baseHandler.convertFromOWL(this.openURL(urlName));
    }

    public Model retrieveByID(String id) throws IOException {
        String urlName = this.prefix + command + "get_record_by_cpath_id" + "&" + version + this.versionID + "&" + "q=" + id + "&" + output + this.output_format;
        return this.readBioPAXfromURL(urlName);
    }

    public List<List<String>> getPathways(String id) throws IOException {
        String oneLine;
        String urlName = this.prefix + command + "get_pathways" + "&" + version + this.versionID + "&" + "q=" + id + "&" + output + this.output_format + "&" + input_id_type + this.inputIdType.getTag() + "&" + data_source + this.dataSource.getTag();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.openURL(urlName)));
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        while ((oneLine = reader.readLine()) != null) {
            ArrayList<String> lineArray = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(oneLine, "\t");
            while (tokenizer.hasMoreTokens()) {
                lineArray.add(tokenizer.nextToken());
            }
            if (lineArray.isEmpty()) continue;
            allLines.add(lineArray);
        }
        return allLines;
    }

    public Model getNeighbors(String id) throws IOException {
        String urlName = this.prefix + command + "get_neighbors" + "&" + version + this.versionID + "&" + "q=" + id + "&" + output + this.output_format + "&" + input_id_type + this.inputIdType.getTag() + "&" + output_id_type + this.outputIdType.getTag() + "&" + data_source + this.dataSource.getTag();
        return this.readBioPAXfromURL(urlName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_SRC {
        DEFAULT(""),
        CELL_MAP("CELL_MAP"),
        HUMANCYC("HUMANCYC"),
        NCI_NATURE("NCI_NATURE"),
        REACTOME("REACTOME");

        private String tag;

        private DATA_SRC(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ID_TYPE {
        DEFAULT("CPATH_ID"),
        UNIPROT("UNIPROT"),
        CPATH_ID("CPATH_ID");

        private String tag;

        private ID_TYPE(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

