/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import org.biopax.paxtools.model.BioPAXLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BinaryInteractionType {
    COMPONENT_OF("COMPONENT_OF", "This rule infers an interaction if two entities belong to at least one molecular complex. This does not necessarily mean they interact directly. In a complex with n molecules, this rule will create a clique composed of n(n-1)/2 interactions. This interaction is directed.", true, BioPAXLevel.L2),
    COMPONENT_IN_SAME("COMPONENT_IN_SAME", "This rule infers an interaction if the first entity is a component of the second entity, which is a complex. This interaction is transient in the sense that A component_of B and B component_of C implies A component_of C. This interaction is undirected.", false, BioPAXLevel.L2),
    CO_CONTROL_DEPENDENT_SIMILAR("CO_CONTROL_DEPENDENT_SIMILAR", "This rule infers an interactionif the first and second entities have control over the same process, their control is dependent, i.e. one of them have effect over control of the other one, and their effect is in the same direction (both activates or both inhibits). This interaction is undirected", false, BioPAXLevel.L2),
    CO_CONTROL_DEPENDENT_ANTI("CO_CONTROL_DEPENDENT_ANTI", "This rule infers an interactionif the first and second entities have control over the same process, their control is dependent, i.e. one of them have effect over control of the other one, and their effect is in different directions (one of them activates, the other inhibits). This interaction is undirected", false, BioPAXLevel.L2),
    CO_CONTROL_INDEPENDENT_SIMILAR("CO_CONTROL_INDEPENDENT_SIMILAR", "This rule infers an interaction if the first and second entities have control over the same process, their control is independent, i.e. they act without affecting each other's activity, and their effect is in the same direction (both activates or both inhibits). This interaction is undirected", false, BioPAXLevel.L2),
    CO_CONTROL_INDEPENDENT_ANTI("CO_CONTROL_INDEPENDENT_ANTI", "This rule infers an interaction if the first and second entities have control over the same process, their control is independent, i.e. they act without affecting each other's activity, and their effect is in different directions (one of them activates, the other inhibits). This interaction is undirected", false, BioPAXLevel.L2),
    SEQUENTIAL_CATALYSIS("SEQUENTIAL_CATALYSIS", "This rule infers an interaction if A and B catalyzes two conversions that are connected via a common molecule, and where potentially that common substrate is produced by the former and consumed by the latter. This interaction is directed", true, BioPAXLevel.L2),
    CONTROLS_METABOLIC_CHANGE("CONTROLS_METABOLIC_CHANGE", "This rule infers an interaction if the first entity catalyses a reaction that either consumes or produces the second entity. More specifically, this rule will find an interaction between two entities A and B if and only if A controls a conversion which B participates and appears only on the left or right side of the conversion but not both. This interaction is directed.", true, BioPAXLevel.L2),
    CONTROLS_STATE_CHANGE("CONTROLS_STATE_CHANGE", "This rule infers an interaction if the first entity catalyses a reaction that either consumes or produces the second entity. More specifically, this rule will find an interaction between two entities A and B if and only if A controls a conversion which B participates and appears both on the left or right side of the conversion. This interaction is directed.", true, BioPAXLevel.L2),
    PARTICIPATES_CONVERSION("PARTICIPATES_CONVERSION", "This rule infers an interaction if both A and B participates in a conversion as substrates or products. Controllers are not included. This interaction is undirected. ", false, BioPAXLevel.L2),
    PARTICIPATES_INTERACTION("PARTICIPATES_INTERACTION", "This rule infers an interaction if both A and B participates in an interaction as participants. Controllers are not included. This interaction is undirected.", false, BioPAXLevel.L2);

    private String tag;
    private String description;
    private boolean directed;
    private BioPAXLevel level;

    private BinaryInteractionType(String tag, String description, boolean directed, BioPAXLevel level) {
        this.tag = tag;
        this.description = description;
        this.directed = directed;
        this.level = level;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public BioPAXLevel getLevel() {
        return this.level;
    }
}

