/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRule
implements InteractionRule {
    @Override
    public void inferInteractions(Set<SimpleInteraction> interactionSet, physicalEntity A, Model model, Map options) {
        if (A instanceof complex) {
            return;
        }
        for (physicalEntityParticipant pep : A.isPHYSICAL_ENTITYof()) {
            if (pep.isCOMPONENTof() == null) continue;
            complex comp = pep.isCOMPONENTof();
            this.processComplex(interactionSet, A, comp, options);
        }
    }

    private void processComplex(Set<SimpleInteraction> interactionSet, physicalEntity A, complex comp, Map options) {
        if (!options.containsKey((Object)BinaryInteractionType.COMPONENT_OF) || options.get((Object)BinaryInteractionType.COMPONENT_OF).equals(Boolean.TRUE)) {
            interactionSet.add(new SimpleInteraction(A, comp, BinaryInteractionType.COMPONENT_OF));
        }
        boolean mostOuter = true;
        for (physicalEntityParticipant pep : comp.isPHYSICAL_ENTITYof()) {
            if (pep.isCOMPONENTof() == null) continue;
            complex outer = pep.isCOMPONENTof();
            mostOuter = false;
            this.processComplex(interactionSet, A, outer, options);
        }
        if (mostOuter && (!options.containsKey((Object)BinaryInteractionType.COMPONENT_IN_SAME) || options.get((Object)BinaryInteractionType.COMPONENT_IN_SAME).equals(Boolean.TRUE))) {
            this.processComplexMembers(interactionSet, A, comp);
        }
    }

    private void processComplexMembers(Set<SimpleInteraction> interactionSet, physicalEntity pe, complex comp) {
        for (physicalEntityParticipant pep : comp.getCOMPONENTS()) {
            physicalEntity member = pep.getPHYSICAL_ENTITY();
            if (pe == member) continue;
            if (member instanceof complex) {
                this.processComplexMembers(interactionSet, pe, (complex)member);
                continue;
            }
            interactionSet.add(new SimpleInteraction(pe, member, BinaryInteractionType.COMPONENT_IN_SAME));
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return Arrays.asList(BinaryInteractionType.COMPONENT_OF, BinaryInteractionType.COMPONENT_IN_SAME);
    }
}

