/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.model;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalanceChecker {
    public static <T extends BioPAXElement> boolean isEquivalent(Set<? extends T> set1, Set<? extends T> set2) {
        boolean equals = false;
        if (set1 == null) {
            equals = set2 == null;
        } else if (set1.size() == set2.size()) {
            equals = true;
            for (BioPAXElement element1 : set1) {
                if (EquivalanceChecker.containsEquivalent(set2, element1)) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    public static boolean containsEquivalent(Set<? extends BioPAXElement> set, BioPAXElement element) {
        for (BioPAXElement bioPAXElement : set) {
            if (!element.isEquivalent(bioPAXElement)) continue;
            return true;
        }
        return false;
    }

    public static <T extends BioPAXElement> Set<T> findEquivalentIntersection(Set<? extends T> set1, Set<? extends T> set2) {
        HashSet<BioPAXElement> intersection = new HashSet<BioPAXElement>();
        for (BioPAXElement element : set1) {
            if (!EquivalanceChecker.containsEquivalent(set2, element)) continue;
            intersection.add(element);
        }
        return intersection;
    }
}

