/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.pathwaycommons.trans.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElementInfo
implements Comparable {
    private static final String NAME_HEADER = "Element Name";
    private static final String HAS_CHILDREN_HEADER = "Has Children";
    private static final String HAS_ATTS_HEADER = "Has Attributes";
    private static final String HAS_TEXT_HEADER = "Has Text";
    private static final String TOTAL_FILES_HEADER = "Total Files";
    private static final String TOTAL_CNT_HEADER = "Total Count";
    private static final String FULL_PATH_HEADER = "Full Path";
    private static TreeMap<String, XMLElementInfo> xeiMap = new TreeMap();
    private boolean hasChildrenFlag;
    private boolean hasTextFlag;
    private boolean hasAttsFlag;
    private String fullName;
    private String name;
    private TreeMap<String, Integer> usageMap = new TreeMap();

    private XMLElementInfo() {
    }

    protected XMLElementInfo(Element element, String refName) {
        this.setFullName(element);
        if (xeiMap.get(this.getFullName()) != null) {
            XMLElementInfo xeiOld = xeiMap.get(this.getFullName());
            xeiOld.setHasChildren(element);
            xeiOld.setHasAtts(element);
            xeiOld.setHasText(element);
            xeiOld.addUsage(refName, xeiOld.getUsage(refName) + 1);
            xeiMap.put(xeiOld.getFullName(), xeiOld);
        } else {
            this.setName(element);
            this.setHasChildren(element);
            this.setHasAtts(element);
            this.setHasText(element);
            this.addUsage(refName, 1);
            xeiMap.put(this.getFullName(), this);
        }
    }

    public static TreeMap<String, XMLElementInfo> getAll() {
        return xeiMap;
    }

    public static ArrayList<XMLElementInfo> getByName(String elementName) throws JDOMException {
        GenUtil.validateString((String)elementName);
        ArrayList<XMLElementInfo> matchingList = new ArrayList<XMLElementInfo>();
        for (String key : xeiMap.keySet()) {
            if (!elementName.equals(xeiMap.get(key).getName())) continue;
            matchingList.add(xeiMap.get(key));
        }
        if (matchingList.size() == 0) {
            throw new JDOMException("Element not found: " + elementName);
        }
        return matchingList;
    }

    protected void setHasChildren(Element element) {
        if (!this.hasChildrenFlag) {
            this.hasChildrenFlag = element.getChildren().size() > 0;
        }
    }

    protected void setHasText(Element element) {
        if (!this.hasTextFlag) {
            this.hasTextFlag = element.getTextTrim().length() > 0;
        }
    }

    protected void setHasAtts(Element element) {
        if (!this.hasAttsFlag) {
            this.hasAttsFlag = element.getAttributes().size() > 0;
        }
    }

    private void setFullName(Element element) {
        if (this.fullName == null) {
            GenUtil.validateNotNull((Object)element);
            this.fullName = XMLUtil.getPathToRoot(element, "");
        }
    }

    private void setName(Element element) {
        if (this.name == null) {
            GenUtil.validateNotNull((Object)element);
            this.name = element.getQualifiedName();
        }
    }

    protected void addUsage(String refName, int cnt) {
        GenUtil.validateString((String)refName);
        GenUtil.validatePositiveInt((int)cnt);
        this.usageMap.put(refName, new Integer(cnt));
    }

    public boolean hasChildren() {
        return this.hasChildrenFlag;
    }

    public boolean hasText() {
        return this.hasTextFlag;
    }

    public boolean hasAtts() {
        return this.hasAttsFlag;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public int getUsage(String refName) {
        GenUtil.validateString((String)refName);
        Integer cntInt = this.usageMap.get(refName);
        if (cntInt != null) {
            return cntInt;
        }
        return 0;
    }

    public int compareTo(Object obj2) {
        return this.getFullName().compareTo(((XMLElementInfo)obj2).getFullName());
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof XMLElementInfo) {
            return this.getFullName().equals(((XMLElementInfo)obj2).getFullName());
        }
        throw new IllegalArgumentException("Invalid object type: " + obj2.getClass());
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.hasChildrenFlag ? 1 : 0);
        hash = 79 * hash + (this.hasAttsFlag ? 1 : 0);
        hash = 79 * hash + (this.fullName != null ? this.fullName.hashCode() : 0);
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 79 * hash + (this.usageMap != null ? this.usageMap.hashCode() : 0);
        return hash;
    }

    public static String getHeaders() {
        String tempStr = NAME_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + HAS_CHILDREN_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + HAS_ATTS_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + HAS_TEXT_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + TOTAL_FILES_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + TOTAL_CNT_HEADER;
        tempStr = tempStr + "\t";
        tempStr = tempStr + FULL_PATH_HEADER;
        tempStr = tempStr + "\t";
        return tempStr;
    }

    public static void readFromFile() throws IOException {
        XMLElementInfo.readFromFile(DefParams.getDefaultProp((String)"DefXMLStatsFile"));
    }

    public static void readFromFile(String statsFileName) throws IOException {
        String line;
        GenUtil.validateString((String)statsFileName);
        BufferedReader bw = new BufferedReader(new FileReader(statsFileName));
        boolean skipHeader = true;
        while ((line = bw.readLine()) != null) {
            String[] tempArr = line.split("\t");
            if (skipHeader) {
                skipHeader = false;
                continue;
            }
            XMLElementInfo xei = new XMLElementInfo();
            xei.name = tempArr[0];
            xei.hasChildrenFlag = Boolean.parseBoolean(tempArr[1]);
            xei.hasAttsFlag = Boolean.parseBoolean(tempArr[2]);
            xei.hasTextFlag = Boolean.parseBoolean(tempArr[3]);
            xei.fullName = tempArr[tempArr.length - 1];
            xeiMap.put(xei.getFullName(), xei);
        }
        System.out.println("Done reading xml element info from: " + statsFileName);
    }

    public String toString() {
        String tempStr = this.getName();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.hasChildren();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.hasAtts();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.hasText();
        tempStr = tempStr + "\t";
        int totalCnt = 0;
        for (String refName : this.usageMap.keySet()) {
            totalCnt += this.usageMap.get(refName).intValue();
        }
        tempStr = tempStr + this.usageMap.size();
        tempStr = tempStr + "\t";
        tempStr = tempStr + totalCnt;
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getFullName();
        return tempStr;
    }
}

