/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import org.genemania.dw.util.GenUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.pathwaycommons.trans.util.XMLElementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtil {
    public static final String XSI_NAME = "xsi";
    public static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_LOC_ATT = "schemaLocation";
    public static final String XML_FILE_SUFFIX = ".xml";
    public static final String DEF_PARSER = "org.apache.xerces.parsers.SAXParser";
    public static final String XERCES_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String PREFIX_XERCES = "http://apache.org/xml/";
    public static final String CONT_FATAL_FEATURE_XERCES = "http://apache.org/xml/features/continue-after-fatal-error";
    public static final String DYNAMIC_CHECK_FEATURE_XERCES = "http://apache.org/xml/features/validation/dynamic";
    public static final String BUF_PROP_XERCES = "http://apache.org/xml/properties/input-buffer-size";
    private static PrintWriter log = GenUtil.getDefaultLog();
    private static SAXBuilder builder;

    private XMLUtil() {
    }

    public static Element readSchemaBasedXML(String inputFileName) throws JDOMException, IOException {
        builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
        builder.setFeature(DYNAMIC_CHECK_FEATURE_XERCES, true);
        builder.setFeature(CONT_FATAL_FEATURE_XERCES, true);
        builder.setProperty(BUF_PROP_XERCES, (Object)new Integer(16));
        Document doc = builder.build(inputFileName);
        return doc.getRootElement();
    }

    public static String getReversePathToRoot(Element element, String name) {
        name = name.length() == 0 ? element.getName() : name + "." + element.getName();
        if (!(element.getParent() instanceof Document)) {
            return XMLUtil.getReversePathToRoot((Element)element.getParent(), name);
        }
        return name;
    }

    public static ArrayList<String> getReversePathAsList(String fullPath) {
        String[] tempArr = fullPath.split("\\.");
        String[] elementNamesArr = new String[tempArr.length];
        int j = 0;
        for (int i = tempArr.length - 1; i >= 0; --i) {
            elementNamesArr[j++] = tempArr[i];
        }
        return new ArrayList<String>(Arrays.asList(elementNamesArr));
    }

    public static String getPathToRoot(Element element, String name) {
        String fullPath = XMLUtil.getReversePathToRoot(element, name);
        ArrayList<String> tempList = XMLUtil.getReversePathAsList(fullPath);
        fullPath = "";
        for (int i = 0; i < tempList.size(); ++i) {
            fullPath = fullPath + tempList.get(i);
            if (i == tempList.size() - 1) continue;
            fullPath = fullPath + ".";
        }
        return fullPath;
    }

    public static void dump(Element rootElement, String fileName) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
        XMLUtil.dump(rootElement, bw);
        System.out.println("Dumped xml file: " + fileName);
        bw.flush();
        bw.close();
    }

    public static void dump(Element rootElement, BufferedWriter bw) throws IOException {
        Format formatter = Format.getPrettyFormat();
        formatter.setExpandEmptyElements(true);
        formatter.setOmitDeclaration(false);
        XMLOutputter xmlPrint = new XMLOutputter(formatter);
        xmlPrint.output(rootElement, (Writer)bw);
    }

    public static boolean validateExists(String elementName, ArrayList<Element> elementList) {
        if (elementList.size() == 0) {
            // empty if block
        }
        return elementList.size() > 0;
    }

    public static boolean validateSingle(String elementName, ArrayList<Element> elementList) {
        if (elementList.size() == 0 || elementList.size() > 1) {
            for (int i = 0; i < elementList.size(); ++i) {
            }
        }
        return elementList.size() > 0;
    }

    public static boolean validateInt(Element e) {
        return e.getTextTrim().length() > 0 && Integer.parseInt(e.getTextTrim()) > 0;
    }

    public static int getDepth(String elementName) throws JDOMException {
        ArrayList<XMLElementInfo> xeiList = XMLElementInfo.getByName(elementName);
        if (xeiList.size() > 1) {
            System.err.println("Warning 1 - element List: Multiple occurences: " + elementName);
        }
        String[] parentsArr = xeiList.get(0).getFullName().split("\\.");
        return parentsArr.length;
    }

    public static ArrayList<Element> getElement(String elementName, Element parent, int index) throws JDOMException {
        return XMLUtil.getElement(elementName, parent, index, false);
    }

    public static ArrayList<Element> getElement(String elementName, Element parent, int index, boolean multipleFlag) throws JDOMException {
        ArrayList<XMLElementInfo> xeiList = XMLElementInfo.getByName(elementName);
        XMLElementInfo xei = null;
        int cnt = 0;
        for (int i = 0; i < xeiList.size(); ++i) {
            if (!xeiList.get(i).getFullName().contains(parent.getName())) continue;
            xei = xeiList.get(i);
            ++cnt;
        }
        if (cnt > 1 && !multipleFlag) {
            System.err.println("Warning 2 - element List: Multiple occurences: " + elementName + " under: " + parent.getName() + " " + xeiList.size());
        }
        if (cnt == 0) {
            System.err.println("Warning 3 - element List: No such element: " + elementName + " under " + parent.getName());
        }
        ArrayList<Element> tempList = new ArrayList<Element>();
        if (multipleFlag) {
            for (int i = 0; i < xeiList.size(); ++i) {
                xei = xeiList.get(i);
                String[] parentsArr = xei.getFullName().split("\\.");
                tempList.addAll(XMLUtil.getTargetChildren(parent, parentsArr, index));
            }
        } else {
            String[] parentsArr = xei.getFullName().split("\\.");
            tempList.addAll(XMLUtil.getTargetChildren(parent, parentsArr, index));
        }
        if (tempList.size() != 0 && !tempList.get(0).getName().equals(elementName)) {
            System.err.println("Error: Wrong Element retrieved " + tempList.get(0) + " " + elementName);
        }
        return tempList;
    }

    private static ArrayList<Element> getTargetChildren(Element parent, String[] parentsArr, int index) {
        ArrayList<Element> tempList = new ArrayList<Element>();
        tempList.addAll(parent.getChildren(parentsArr[index]));
        for (int i = 0; i < tempList.size(); ++i) {
            if (index >= parentsArr.length - 1) continue;
            return XMLUtil.getTargetChildren(tempList.get(i), parentsArr, ++index);
        }
        return tempList;
    }
}

