/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontology_manager.impl.local;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.ontology_manager.impl.local.OboLoader;
import psidev.psi.tools.ontology_manager.impl.local.Ontology;
import psidev.psi.tools.ontology_manager.impl.local.OntologyLoaderException;
import psidev.psi.tools.ontology_manager.interfaces.OntologyAccess;
import psidev.psi.tools.ontology_manager.interfaces.OntologyTermI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOntology
implements OntologyAccess {
    public static final Log log = LogFactory.getLog(LocalOntology.class);
    private Ontology ontology;
    private final String DEFAULT_ONTOLOGY_DIRECTORY = ".downloaded-ontologies";
    private File ontologyDirectory = null;
    private String ontologyID;

    public LocalOntology() {
        log.info((Object)"Creating new LocalOntology...");
        this.ontology = null;
    }

    @Override
    public void loadOntology(String ontologyID, String name, String version, String format, URI uri) throws OntologyLoaderException {
        this.ontologyID = ontologyID;
        if ("OBO".equals(format)) {
            URL url;
            if (uri == null) {
                throw new IllegalArgumentException("The given CvSource doesn't have a URL");
            }
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The given CvSource doesn't have a valid URL: " + uri);
            }
            OboLoader loader = new OboLoader(this.getOntologyDirectory());
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parsing URL: " + url));
                }
                this.ontology = loader.parseOboFile(url);
            }
            catch (OntologyLoaderException e) {
                throw new OntologyLoaderException("OboFile parser failed with Exception: ", e);
            }
        }
        throw new OntologyLoaderException("Unsupported ontology format: " + format);
        if (log.isInfoEnabled()) {
            log.info((Object)("Successfully created LocalOntology from values: ontology=" + ontologyID + " name=" + name + " version=" + version + " format=" + format + " location=" + uri));
        }
    }

    @Override
    public void setOntologyDirectory(File directory) {
        if (directory != null) {
            this.ontologyDirectory = directory;
        }
    }

    @Override
    public Set<OntologyTermI> getValidTerms(String accession, boolean allowChildren, boolean useTerm) {
        HashSet<OntologyTermI> collectedTerms = new HashSet<OntologyTermI>();
        OntologyTermI term = this.getTermForAccession(accession);
        if (term != null) {
            if (useTerm) {
                collectedTerms.add(term);
            }
            if (allowChildren) {
                collectedTerms.addAll(this.getAllChildren(term));
            }
        }
        return collectedTerms;
    }

    @Override
    public OntologyTermI getTermForAccession(String accession) {
        return this.ontology.search(accession);
    }

    @Override
    public boolean isObsolete(OntologyTermI term) {
        return this.ontology.isObsoleteTerm(term);
    }

    @Override
    public Set<OntologyTermI> getDirectParents(OntologyTermI term) {
        return this.ontology.getDirectParents(term);
    }

    @Override
    public Set<OntologyTermI> getDirectChildren(OntologyTermI term) {
        return this.ontology.getDirectChildren(term);
    }

    @Override
    public Set<OntologyTermI> getAllParents(OntologyTermI term) {
        return this.ontology.getAllParents(term);
    }

    @Override
    public Set<OntologyTermI> getAllChildren(OntologyTermI term) {
        return this.ontology.getAllChildren(term);
    }

    private File getOntologyDirectory() throws OntologyLoaderException {
        if (this.ontologyDirectory != null) {
            if (!this.ontologyDirectory.exists()) {
                if (!this.ontologyDirectory.mkdirs()) {
                    throw new OntologyLoaderException("Cannot create home directory for ontologies: " + this.ontologyDirectory.getAbsolutePath());
                }
                return this.ontologyDirectory;
            }
            if (this.ontologyDirectory.canWrite()) {
                return this.ontologyDirectory;
            }
            log.warn((Object)"Could not create or write to specified ontologies directory.");
        }
        log.info((Object)"Using default for ontology directory.");
        String path = System.getProperty("user.home") + File.separator + ".downloaded-ontologies";
        File dir = new File(path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new OntologyLoaderException("Cannot create home directory for ontologies: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.canWrite()) {
            return dir;
        }
        dir = null;
        path = System.getProperty("java.io.tmpdir", "tmp") + File.separator + this.ontologyDirectory;
        dir = new File(path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new OntologyLoaderException("Cannot create home directory for ontologies: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.canWrite()) {
            return dir;
        }
        throw new OntologyLoaderException("Cannot create home directory for ontologies, pleast check your config.");
    }
}

