/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontology_manager.impl.ols;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.ontology_manager.impl.OntologyTermImpl;
import psidev.psi.tools.ontology_manager.impl.local.OntologyLoaderException;
import psidev.psi.tools.ontology_manager.interfaces.OntologyAccess;
import psidev.psi.tools.ontology_manager.interfaces.OntologyTermI;
import uk.ac.ebi.ook.web.services.Query;
import uk.ac.ebi.ook.web.services.QueryServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlsOntology
implements OntologyAccess {
    public static final Log log = LogFactory.getLog(OlsOntology.class);
    protected static GeneralCacheAdministrator admin;
    private static String cacheConfig;
    static Query query;
    String ontologyID;
    Set<String> rootAccs;
    private final byte GET_VALID_IDS = 1;
    private final byte IS_OBSOLETE_ID = (byte)2;
    private final byte GET_TERM_NAME_BY_ID = (byte)3;
    private final byte GET_DIRECT_PARENTS_IDS = (byte)4;
    private final byte GET_CHILD_TERMS = (byte)5;
    private final byte GET_CHILDREN = (byte)6;
    private final byte GET_DIRECT_PARENTS = (byte)7;
    private final byte IS_OBSOLETE = (byte)8;
    private final byte GET_TERM_FOR_ACCESSION = (byte)9;
    private final boolean useByteCodeGroup = true;

    public OlsOntology() throws OntologyLoaderException {
        log.info((Object)"Creating new OlsOntology...");
        if (admin == null) {
            log.info((Object)"Setting up cache administrator...");
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(cacheConfig);
            Properties cacheProps = new Properties();
            try {
                cacheProps.load(is);
            }
            catch (IOException e) {
                log.error((Object)("Failed to load cache configuration properties: " + cacheConfig), (Throwable)e);
            }
            if (cacheProps.isEmpty()) {
                log.warn((Object)"Using default cache configuration!");
                admin = new GeneralCacheAdministrator();
            } else {
                log.info((Object)("Using custom cache configuration from file: " + cacheConfig));
                admin = new GeneralCacheAdministrator(cacheProps);
            }
        } else {
            log.info((Object)"Cache administrator already set-up.");
        }
        if (query == null) {
            log.info((Object)"Creating new OLS query client.");
            try {
                QueryServiceLocator locator = new QueryServiceLocator();
                query = locator.getOntologyQuery();
            }
            catch (Exception e) {
                log.error((Object)"Exception setting up OLS query client!", (Throwable)e);
                throw new OntologyLoaderException("Exception setting up OLS query client!", e);
            }
        } else {
            log.info((Object)"Reusing statically created OLS query client.");
        }
    }

    @Override
    public void loadOntology(String ontologyID, String name, String version, String format, URI uri) {
        this.ontologyID = ontologyID;
        try {
            HashMap roots = query.getRootTerms(ontologyID);
            this.rootAccs = new HashSet<String>();
            this.rootAccs.addAll(roots.keySet());
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        log.info((Object)("Successfully created OlsOntology from values: ontology=" + ontologyID + " name=" + name + " version=" + version + " format=" + format + " location=" + uri));
    }

    @Override
    public void setOntologyDirectory(File directory) {
        log.info((Object)"setOntologyDirectory does not have any effect on the OlsOntology.");
    }

    @Override
    public Set<OntologyTermI> getValidTerms(String accession, boolean allowChildren, boolean useTerm) {
        HashSet<OntologyTermI> validTerms = new HashSet<OntologyTermI>();
        OntologyTermI term = this.getTermForAccession(accession);
        if (term != null) {
            if (useTerm) {
                validTerms.add(term);
            }
            if (allowChildren) {
                validTerms.addAll(this.getChildren(term, -1));
            }
        }
        return validTerms;
    }

    public OntologyTermI getTermForAccessionUncached(String accession) {
        String termName;
        try {
            termName = query.getTermById(accession, this.ontologyID);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        OntologyTermImpl term = termName != null && termName.length() > 0 && !termName.equals(accession) ? new OntologyTermImpl(accession, termName) : null;
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyTermI getTermForAccession(String accession) {
        OntologyTermI result;
        String myKey = 104 + this.ontologyID + '_' + accession;
        try {
            result = (OntologyTermI)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getTermForAccessionUncached(accession);
                log.debug((Object)("Storing uncached terms for key: " + myKey));
                admin.putInCache(myKey, (Object)result);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    public boolean isObsoleteUncached(OntologyTermI term) {
        boolean retVal;
        try {
            retVal = query.isObsolete(term.getTermAccession(), this.ontologyID);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObsolete(OntologyTermI term) {
        boolean result;
        String myKey = 103 + this.ontologyID + '_' + term.getTermAccession();
        try {
            result = (Boolean)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.isObsoleteUncached(term);
                log.debug((Object)("Storing uncached terms for key: " + myKey));
                admin.putInCache(myKey, (Object)result);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    public Set<OntologyTermI> getDirectParentsUncached(OntologyTermI term) {
        HashMap results;
        try {
            results = query.getTermParents(term.getTermAccession(), this.ontologyID);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return this.olsMap2TermSet(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OntologyTermI> getDirectParents(OntologyTermI term) {
        Set<OntologyTermI> result;
        String myKey = 102 + this.ontologyID + '_' + term.getTermAccession();
        try {
            result = (Set<OntologyTermI>)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getDirectParentsUncached(term);
                log.debug((Object)("Storing uncached terms for key: " + myKey));
                admin.putInCache(myKey, result);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    @Override
    public Set<OntologyTermI> getAllParents(OntologyTermI term) {
        HashSet<OntologyTermI> allParents = new HashSet<OntologyTermI>();
        this.addParents(term, allParents);
        return allParents;
    }

    private void addParents(OntologyTermI term, Set<OntologyTermI> parents) {
        Set<OntologyTermI> dps = this.getDirectParents(term);
        for (OntologyTermI dp : dps) {
            if (parents.contains(dp)) continue;
            parents.add(dp);
            if (this.rootAccs.contains(dp.getTermAccession())) continue;
            this.addParents(dp, parents);
        }
    }

    public Set<OntologyTermI> getChildrenUncached(OntologyTermI term, int level) {
        HashMap results;
        int[] relationshipTypes = new int[]{1, 2, 3, 4};
        try {
            results = query.getTermChildren(term.getTermAccession(), this.ontologyID, level, relationshipTypes);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return this.olsMap2TermSet(results);
    }

    @Override
    public Set<OntologyTermI> getDirectChildren(OntologyTermI term) {
        return this.getChildren(term, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OntologyTermI> getChildren(OntologyTermI term, int level) {
        Set<OntologyTermI> result;
        String myKey = 101 + this.ontologyID + '_' + term.getTermAccession() + '_' + level;
        try {
            result = (Set<OntologyTermI>)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getChildrenUncached(term, level);
                log.debug((Object)("Storing uncached terms for key: " + myKey));
                admin.putInCache(myKey, result);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    @Override
    public Set<OntologyTermI> getAllChildren(OntologyTermI term) {
        return this.getChildren(term, -1);
    }

    private Set<OntologyTermI> olsMap2TermSet(Map results) {
        HashSet<OntologyTermI> terms = new HashSet<OntologyTermI>();
        for (Object o : results.keySet()) {
            Object v = results.get(o);
            if (o instanceof String && v instanceof String) {
                terms.add(new OntologyTermImpl((String)o, (String)v));
                continue;
            }
            throw new IllegalStateException("OLS query returned unexpected result! Expected Map with key and value of class String, but found key class: " + o.getClass().getName() + " and value class: " + v.getClass().getName());
        }
        return terms;
    }

    @Deprecated
    public Set<String> getValidIDsOld(String id, boolean allowChildren, boolean useTerm) {
        HashSet<String> terms = new HashSet<String>();
        try {
            if (useTerm) {
                String result = query.getTermById(id, this.ontologyID);
                if (result.equalsIgnoreCase(id)) {
                    log.warn((Object)("The Term ID '" + id + "' was not found in ontology '" + this.ontologyID + "'."));
                } else {
                    log.debug((Object)("Found valid id: " + id + " in ontology: " + this.ontologyID));
                    terms.add(id);
                }
            }
            if (allowChildren) {
                int[] relationshipTypes = new int[]{1, 2, 3, 4};
                HashMap resultMap = query.getTermChildren(id, this.ontologyID, -1, relationshipTypes);
                if (resultMap != null) {
                    log.debug((Object)("Found " + resultMap.keySet().size() + " child terms of id: " + id + " in ontology: " + this.ontologyID));
                    terms.addAll(resultMap.keySet());
                }
            }
        }
        catch (RemoteException e) {
            log.error((Object)"RemoteException while trying to connect to OLS.", (Throwable)e);
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return terms;
    }

    @Deprecated
    protected Set<String> getValidIDs2(String id, boolean allowChildren, boolean useTerm) {
        HashSet<String> terms = new HashSet<String>();
        try {
            if (useTerm) {
                String result = query.getTermById(id, this.ontologyID);
                if (result.equalsIgnoreCase(id)) {
                    log.warn((Object)("The Term ID '" + id + "' was not found in ontology '" + this.ontologyID + "'."));
                } else {
                    terms.add(id);
                }
            }
            if (allowChildren) {
                Set<String> children = this.getAllChildTerms(id);
                log.debug((Object)("Found " + children.size() + " child terms of id: " + id + " in ontology: " + this.ontologyID));
                terms.addAll(children);
            }
        }
        catch (RemoteException e) {
            log.error((Object)"RemoteException while trying to connect to OLS.", (Throwable)e);
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<String> getValidIDs(String queryTerm, boolean allowChildren, boolean useTerm) {
        Set<String> terms;
        String queryGroup = "getValidIDs_query";
        String myKey = 96 + this.ontologyID + '_' + queryTerm + '_' + allowChildren + '_' + useTerm;
        String[] groups = new String[]{queryGroup};
        try {
            terms = (Set<String>)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                terms = this.getValidIDsOld(queryTerm, allowChildren, useTerm);
                log.debug((Object)("Storing uncached terms with key: " + myKey));
                admin.putInCache(myKey, terms, groups);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return terms;
    }

    @Deprecated
    protected boolean isObsoleteIDUncached(String id) {
        boolean result;
        try {
            String s = query.getTermById(id, this.ontologyID);
            if (s.equalsIgnoreCase(id)) {
                throw new IllegalStateException("Checking obsolete on term '" + id + "' which does not exist in '" + this.ontologyID + "'!");
            }
            result = query.isObsolete(id, this.ontologyID);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isObsoleteID(String id) {
        Boolean result;
        String queryGroup = "isObsoleteID_query";
        String myKey = 97 + this.ontologyID + '_' + id;
        String[] groups = new String[]{queryGroup};
        try {
            result = (Boolean)admin.getFromCache(myKey);
            log.debug((Object)("Using cached term for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.isObsoleteIDUncached(id);
                log.debug((Object)("Storing uncached term with key: " + myKey));
                admin.putInCache(myKey, (Object)result, groups);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    @Deprecated
    protected String getTermNameByIDUncached(String id) {
        String result;
        try {
            result = query.getTermById(id, this.ontologyID);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to query OLS for: " + id + " in ontology: " + this.ontologyID);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getTermNameByID(String id) {
        String result;
        String queryGroup = "getTermNameByID_query";
        String myKey = 98 + this.ontologyID + '_' + id;
        String[] groups = new String[]{queryGroup};
        try {
            result = (String)admin.getFromCache(myKey);
            log.debug((Object)("Using cached term name for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getTermNameByIDUncached(id);
                log.debug((Object)("Storing uncached term name with key: " + myKey));
                admin.putInCache(myKey, (Object)result, groups);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    @Deprecated
    protected Set<String> getDirectParentsIDsUncached(String id) {
        Set<String> result;
        try {
            result = query.getTermParents(id, this.ontologyID).keySet();
        }
        catch (RemoteException e) {
            throw new IllegalStateException("RemoteException while trying to connect to OLS.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<String> getDirectParentsIDs(String id) {
        Set<String> result;
        String queryGroup = "getDirectParentsIDs_query";
        String myKey = 99 + this.ontologyID + '_' + id;
        String[] groups = new String[]{queryGroup};
        try {
            result = (Set<String>)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getDirectParentsIDsUncached(id);
                log.debug((Object)("Storing uncached terms with key: " + myKey));
                admin.putInCache(myKey, result, groups);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    @Deprecated
    public Set<String> getAllChildTerms(String id) throws RemoteException {
        TreeSet<String> retVal = new TreeSet<String>();
        this.appendChildTerms(retVal, this.getChildTerms(id));
        return retVal;
    }

    @Deprecated
    private void appendChildTerms(Set<String> set, Set<String> children) throws RemoteException {
        for (String child : children) {
            if (set.contains(child)) continue;
            set.add(child);
            this.appendChildTerms(set, this.getChildTerms(child));
        }
    }

    @Deprecated
    protected Set<String> getChildTermsUncached(String id) throws RemoteException {
        HashMap result = query.getTermChildren(id, this.ontologyID, 1, null);
        return result.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private Set<String> getChildTerms(String id) throws RemoteException {
        Set<String> result;
        String queryGroup = "getChildTerms_query";
        String myKey = 100 + this.ontologyID + '_' + id;
        String[] groups = new String[]{queryGroup};
        try {
            result = (Set<String>)admin.getFromCache(myKey);
            log.debug((Object)("Using cached terms for key: " + myKey));
        }
        catch (NeedsRefreshException nre) {
            boolean updated = false;
            try {
                result = this.getChildTermsUncached(id);
                log.debug((Object)("Storing uncached terms for key: " + myKey));
                admin.putInCache(myKey, result, groups);
                updated = true;
            }
            finally {
                if (!updated) {
                    admin.cancelUpdate(myKey);
                }
            }
        }
        return result;
    }

    static {
        cacheConfig = "olsontology-oscache.properties";
    }
}

