/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

public final class OsCache
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$cache$distributed$OsCache == null ? (class$org$castor$cache$distributed$OsCache = OsCache.class$("org.castor.cache.distributed.OsCache")) : class$org$castor$cache$distributed$OsCache));
    public static final String TYPE = "oscache";
    public static final String IMPLEMENTATION = "com.opensymphony.oscache.general.GeneralCacheAdministrator";
    public static final String NEEDS_REFRESH_EXCEPTION = "com.opensymphony.oscache.base.NeedsRefreshException";
    private static final Class[] TYPES_GET = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OsCache.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] TYPES_CANCEL = TYPES_GET;
    private static final Class[] TYPES_PUT = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OsCache.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = OsCache.class$("java.lang.Object")) : class$java$lang$Object, array$Ljava$lang$String == null ? (array$Ljava$lang$String = OsCache.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
    private static final Class[] TYPES_REMOVE = TYPES_GET;
    private static final Class[] TYPES_CLEAR = TYPES_GET;
    private final Object _cache;
    private Method _getMethod;
    private Method _cancelMethod;
    private Method _putMethod;
    private Method _removeMethod;
    private Method _clearMethod;
    private String[] _groups;
    static /* synthetic */ Class class$org$castor$cache$distributed$OsCache;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$String;

    public OsCache(Object cache) {
        this._cache = cache;
    }

    public void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        Class<?> cls = this._cache.getClass();
        try {
            this._getMethod = cls.getMethod("getFromCache", TYPES_GET);
            this._cancelMethod = cls.getMethod("cancelUpdate", TYPES_CANCEL);
            this._putMethod = cls.getMethod("putInCache", TYPES_PUT);
            this._removeMethod = cls.getMethod("flushEntry", TYPES_REMOVE);
            this._clearMethod = cls.getMethod("flushGroup", TYPES_CLEAR);
        }
        catch (Exception e) {
            String msg = "Failed to find method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
        this._groups = new String[]{this.getName()};
    }

    public String getType() {
        return TYPE;
    }

    public int size() {
        throw new UnsupportedOperationException("size()");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty()");
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue(Object)");
    }

    public Object get(Object key) {
        try {
            return this._getMethod.invoke(this._cache, String.valueOf(key));
        }
        catch (InvocationTargetException e) {
            if (e.getCause().getClass().getName().equals(NEEDS_REFRESH_EXCEPTION)) {
                this.invokeCacheMethod(this._cancelMethod, new Object[]{String.valueOf(key)});
                return null;
            }
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
        catch (Exception e) {
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._putMethod, new Object[]{String.valueOf(key), value, this._groups});
        return oldValue;
    }

    public Object remove(Object key) {
        Object oldValue = this.get(key);
        this.invokeCacheMethod(this._removeMethod, new Object[]{String.valueOf(key)});
        return oldValue;
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = String.valueOf(entry.getKey());
            this.invokeCacheMethod(this._putMethod, new Object[]{key, entry.getValue(), this._groups});
        }
    }

    public void clear() {
        this.invokeCacheMethod(this._clearMethod, new Object[]{this.getName()});
    }

    public Set keySet() {
        throw new UnsupportedOperationException("keySet()");
    }

    public Collection values() {
        throw new UnsupportedOperationException("values()");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    private Object invokeCacheMethod(Method method, Object[] arguments) {
        try {
            return method.invoke(this._cache, arguments);
        }
        catch (Exception e) {
            String msg = "Failed to call method on OSCache instance: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

