/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;
import org.castor.transactionmanager.TransactionManagerFactoryRegistry;
import org.castor.util.Configuration;

public final class TransactionManagerRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$transactionmanager$TransactionManagerRegistry == null ? (class$org$castor$transactionmanager$TransactionManagerRegistry = TransactionManagerRegistry.class$("org.castor.transactionmanager.TransactionManagerRegistry")) : class$org$castor$transactionmanager$TransactionManagerRegistry));
    public static final String PROPERTY_INIT_AT_REGISTRATION = "org.castor.transactionmanager.InitializeAtRegistration";
    private TransactionManagerFactoryRegistry _registry;
    private boolean _initializationAtRegistration;
    private Map _managers = new HashMap();
    static /* synthetic */ Class class$org$castor$transactionmanager$TransactionManagerRegistry;

    public TransactionManagerRegistry(Configuration config) {
        this._registry = new TransactionManagerFactoryRegistry(config);
        String property = config.getProperty(PROPERTY_INIT_AT_REGISTRATION, "false");
        this._initializationAtRegistration = Boolean.valueOf(property);
    }

    public void registerTransactionManager(String managerName, String factoryName, Properties properties) throws TransactionManagerAcquireException {
        Loader loader = new Loader(factoryName, properties);
        this.registerTransactionManager(managerName, loader);
        if (this._initializationAtRegistration) {
            loader.initialize();
        }
    }

    public void registerTransactionManager(String managerName, TransactionManager managerInstance) throws TransactionManagerAcquireException {
        Loader loader = new Loader(managerInstance);
        this.registerTransactionManager(managerName, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTransactionManager(String managerName, Loader loader) throws TransactionManagerAcquireException {
        Map map = this._managers;
        synchronized (map) {
            if (this._managers.containsKey(managerName)) {
                String msg = "A TransactionManager with the name '" + managerName + "' " + "has already been registered.";
                LOG.error((Object)msg);
                throw new TransactionManagerAcquireException(msg);
            }
            this._managers.put(managerName, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTransactionManager(String managerName) {
        Map map = this._managers;
        synchronized (map) {
            this._managers.remove(managerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTransactionManagerNames() {
        Map map = this._managers;
        synchronized (map) {
            String[] names = new String[this._managers.size()];
            return this._managers.keySet().toArray(names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager(String managerName) throws TransactionManagerAcquireException {
        Loader loader = null;
        Map map = this._managers;
        synchronized (map) {
            loader = (Loader)this._managers.get(managerName);
        }
        if (loader == null) {
            String msg = "A TransactionManager with the name '" + managerName + "' " + "has not been registered.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return loader.getManagerInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Loader {
        private TransactionManagerFactory _factory;
        private Properties _properties;
        private TransactionManager _managerInstance;

        public Loader(String factoryName, Properties properties) throws TransactionManagerAcquireException {
            this._factory = TransactionManagerRegistry.this._registry.getTransactionManagerFactory(factoryName);
            this._properties = properties;
            this._managerInstance = null;
        }

        public Loader(TransactionManager managerInstance) {
            this._factory = null;
            this._properties = null;
            this._managerInstance = managerInstance;
        }

        public TransactionManager getManagerInstance() throws TransactionManagerAcquireException {
            this.initialize();
            return this._managerInstance;
        }

        public synchronized void initialize() throws TransactionManagerAcquireException {
            if (this._managerInstance == null) {
                this._managerInstance = this._factory.getTransactionManager(this._properties);
            }
        }
    }
}

