/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JConstructor
extends JAnnotatedElementHelper {
    private JModifiers modifiers = null;
    private JNamedMap params = null;
    private JClass declaringClass = null;
    private JSourceCode sourceCode = null;
    private Vector exceptions = null;

    protected JConstructor(JClass declaringClass) {
        this.declaringClass = declaringClass;
        this.modifiers = new JModifiers();
        this.params = new JNamedMap();
        this.sourceCode = new JSourceCode();
        this.exceptions = new Vector(1);
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        for (int i = 0; i < this.exceptions.size(); ++i) {
            JClass jClass = (JClass)this.exceptions.elementAt(i);
            if (!expClassName.equals(jClass.getName())) continue;
            return;
        }
        this.exceptions.addElement(exp);
    }

    public JClass[] getExceptions() {
        Object[] jclasses = new JClass[this.exceptions.size()];
        this.exceptions.copyInto(jclasses);
        return jclasses;
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        JType jType;
        if (parameter == null) {
            return;
        }
        if (this.params.get(parameter.getName()) != null) {
            StringBuffer err = new StringBuffer();
            err.append("A parameter already exists for the constructor, ");
            err.append(this.declaringClass.getName());
            err.append(", with the name: ");
            err.append(parameter.getName());
            throw new IllegalArgumentException(err.toString());
        }
        this.params.put(parameter.getName(), parameter);
        if (this.declaringClass != null && !(jType = parameter.getType()).isPrimitive()) {
            this.declaringClass.addImport(jType.getName());
        }
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public JParameter[] getParameters() {
        JParameter[] jpArray = new JParameter[this.params.size()];
        for (int i = 0; i < jpArray.length; ++i) {
            jpArray[i] = (JParameter)this.params.get(i);
        }
        return jpArray;
    }

    public JSourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void print(JSourceWriter jsw) {
        JParameter jParameter;
        int i;
        this.printAnnotations(jsw);
        if (this.modifiers.isPrivate()) {
            jsw.write("private");
        } else if (this.modifiers.isProtected()) {
            jsw.write("protected");
        } else {
            jsw.write("public");
        }
        jsw.write(32);
        jsw.write(this.declaringClass.getLocalName());
        jsw.write(40);
        boolean parameterAnnotations = false;
        for (i = 0; i < this.params.size(); ++i) {
            jParameter = (JParameter)this.params.get(i);
            if (!jParameter.hasAnnotations()) continue;
            parameterAnnotations = true;
            break;
        }
        if (parameterAnnotations) {
            jsw.indent();
        }
        for (i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                jsw.write(", ");
            }
            if (parameterAnnotations) {
                jsw.writeln();
            }
            jParameter = (JParameter)this.params.get(i);
            jParameter.printAnnotations(jsw);
            String typeAndName = jParameter.toString();
            jsw.write(typeAndName);
        }
        if (parameterAnnotations) {
            jsw.unindent();
        }
        jsw.writeln(") ");
        if (this.exceptions.size() > 0) {
            jsw.write("    throws ");
            for (i = 0; i < this.exceptions.size(); ++i) {
                if (i > 0) {
                    jsw.write(", ");
                }
                JClass jClass = (JClass)this.exceptions.elementAt(i);
                jsw.write(jClass.getName());
            }
            jsw.writeln();
        }
        jsw.writeln(" {");
        this.sourceCode.print(jsw);
        if (!jsw.isNewline()) {
            jsw.writeln();
        }
        jsw.write("} //-- ");
        jsw.writeln(this.toString());
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = new JSourceCode(sourceCode);
    }

    public void setSourceCode(JSourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.declaringClass.getName());
        sb.append('(');
        for (int i = 0; i < this.params.size(); ++i) {
            JParameter jp = (JParameter)this.params.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jp.getType().getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

