/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import psidev.psi.mi.filemakers.xmlFlattener.XmlFlattener;
import psidev.psi.mi.filemakers.xmlMaker.gui.DictionaryPanel;
import psidev.psi.mi.filemakers.xmlMaker.gui.FlatFileTabbedPanel;
import psidev.psi.mi.filemakers.xmlMaker.gui.XsdTreePanelImpl;
import psidev.psi.mi.filemakers.xmlMaker.mapping.DictionaryMapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.FlatFileMapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.Mapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.TreeMapping;
import psidev.psi.mi.filemakers.xmlMaker.structure.Dictionary;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFile;
import psidev.psi.mi.filemakers.xmlMaker.structure.XsdTreeStructImpl;
import psidev.psi.mi.filemakers.xsd.JTextPaneMessageManager;
import psidev.psi.mi.filemakers.xsd.Utils;
import psidev.psi.mi.filemakers.xsd.XsdNode;

public class XmlMakerGui
extends JFrame {
    static String mappingFileName = null;
    public XsdTreePanelImpl treePanel;
    public FlatFileTabbedPanel flatFileTabbedPanel;
    public DictionaryPanel dictionnaryLists;
    public XsdTreeStructImpl xsdTree;

    private static void displayUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -classpath dist/xmlMakerFlattener.jar -Djava.ext.dirs=libs " + XmlFlattener.class.getName() + " [-mapping mapping.xml] ", options);
    }

    public void load() {
        JFileChooser fc = Utils.lastVisitedMappingDirectory != null ? new JFileChooser(Utils.lastVisitedMappingDirectory) : new JFileChooser(".");
        int returnVal = fc.showOpenDialog(new JFrame());
        if (returnVal != 0) {
            return;
        }
        this.load(fc.getSelectedFile());
    }

    private void load(File mappingFile) {
        try {
            URL url;
            FileInputStream fin = new FileInputStream(mappingFile);
            Utils.lastVisitedDirectory = mappingFile.getPath();
            Utils.lastVisitedMappingDirectory = mappingFile.getPath();
            XMLDecoder xdec = new XMLDecoder(fin);
            Mapping mapping = (Mapping)xdec.readObject();
            this.flatFileTabbedPanel.flatFileContainer.flatFiles = new ArrayList();
            int i = 0;
            while (i < mapping.flatFiles.size()) {
                FlatFileMapping ffm = (FlatFileMapping)mapping.flatFiles.get(i);
                FlatFile f = new FlatFile();
                if (ffm != null) {
                    f.lineSeparator = ffm.lineSeparator;
                    f.firstLineForTitles = ffm.fisrtLineForTitle;
                    f.setSeparators(ffm.getSeparators());
                    try {
                        url = new File(ffm.getFileURL()).toURL();
                        if (url != null) {
                            f.load(url);
                        }
                    }
                    catch (FileNotFoundException fe) {
                        JOptionPane.showMessageDialog(new JFrame(), "Unable to load file" + ffm.getFileURL(), "[PSI makers: PSI maker] load flat file", 0);
                    }
                }
                this.treePanel.flatFileTabbedPanel.flatFileContainer.addFlatFile(f);
                ++i;
            }
            this.treePanel.flatFileTabbedPanel.reload();
            this.dictionnaryLists.dictionaries.dictionaries = new ArrayList();
            i = 0;
            while (i < mapping.getDictionaries().size()) {
                DictionaryMapping dm = (DictionaryMapping)mapping.getDictionaries().get(i);
                Dictionary d = new Dictionary();
                try {
                    url = null;
                    if (dm.getFileURL() != null) {
                        url = new File(dm.getFileURL()).toURL();
                    }
                    d = url != null ? new Dictionary(url, dm.getSeparator(), dm.caseSensitive) : new Dictionary();
                }
                catch (FileNotFoundException fe) {
                    JOptionPane.showMessageDialog(new JFrame(), "Unable to load file" + dm.getFileURL(), "[PSI makers: PSI maker] load dictionnary", 0);
                    d = new Dictionary();
                }
                this.treePanel.dictionaryPanel.dictionaries.addDictionary(d);
                ++i;
            }
            this.treePanel.dictionaryPanel.reload();
            TreeMapping treeMapping = mapping.getTree();
            File schema = new File(treeMapping.getSchemaURL());
            try {
                this.treePanel.loadSchema(schema);
                ((XsdTreeStructImpl)this.treePanel.xsdTree).loadMapping(treeMapping);
                this.treePanel.xsdTree.check();
                this.treePanel.reload();
                int i2 = 0;
                while (i2 < mapping.flatFiles.size()) {
                    try {
                        this.flatFileTabbedPanel.tabbedPane.setTitleAt(i2, ((XsdNode)this.xsdTree.getAssociatedFlatFiles().get(i2)).toString());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            catch (FileNotFoundException fe) {
                JOptionPane.showMessageDialog(new JFrame(), "File not found: " + schema.getName(), "[PSI makers]", 0);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(new JFrame(), "Unable to load file" + ioe.toString(), "[PSI makers]", 0);
            }
            xdec.close();
            fin.close();
        }
        catch (FileNotFoundException fe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load mapping" + mappingFile.getName(), "[PSI makers: PSI maker] load mapping", 0);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "IO error, unable to load mapping", "[PSI makers: PSI maker] load mapping", 0);
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers]", 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void save() {
        block7: {
            try {
                fc = Utils.lastVisitedMappingDirectory != null ? new JFileChooser(Utils.lastVisitedMappingDirectory) : new JFileChooser(".");
                returnVal = fc.showSaveDialog(new JFrame());
                if (returnVal != 0) {
                    return;
                }
                fos = new FileOutputStream(fc.getSelectedFile());
                xenc = new XMLEncoder(fos);
                mapping = new Mapping();
                mapping.setTree(((XsdTreeStructImpl)this.treePanel.xsdTree).getMapping());
                i = 0;
                while (i < this.treePanel.dictionaryPanel.dictionaries.getDictionaries().size()) {
                    mapping.dictionaries.add(((Dictionary)this.xsdTree.dictionaries.getDictionaries().get(i)).getMapping());
                    ++i;
                }
                i = 0;
                while (i < this.xsdTree.flatFiles.flatFiles.size()) {
                    mapping.flatFiles.add(this.xsdTree.flatFiles.getFlatFile(i).getMapping());
                    ++i;
                }
                xenc.writeObject(mapping);
                xenc.close();
                fos.close();
                break block7;
            }
            catch (FileNotFoundException fe) {
                JOptionPane.showMessageDialog(new JFrame(), "Unable to write file", "[PSI makers: PSI maker] save mapping", 0);
                break block7;
            }
            catch (Exception ex) {
                System.out.println("pb: " + ex);
                s = ex.getStackTrace();
                i = 0;
                ** while (i < s.length)
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(s[i]);
                ++i;
                continue;
            }
        }
    }

    public XmlMakerGui() {
        super("XML Maker");
        this.getContentPane().setLayout(new BorderLayout());
        this.xsdTree = new XsdTreeStructImpl();
        JTextPaneMessageManager messageManager = new JTextPaneMessageManager();
        this.xsdTree.setMessageManager(messageManager);
        this.treePanel = new XsdTreePanelImpl(this.xsdTree, messageManager);
        this.flatFileTabbedPanel = new FlatFileTabbedPanel(this.xsdTree.flatFiles);
        this.flatFileTabbedPanel.setBorder(new TitledBorder("Flat files"));
        this.dictionnaryLists = new DictionaryPanel(this.xsdTree.dictionaries);
        this.dictionnaryLists.setBorder(new TitledBorder("Dictionnary"));
        Box associationsPanels = new Box(1);
        associationsPanels.add(this.flatFileTabbedPanel);
        associationsPanels.add(this.dictionnaryLists);
        this.getContentPane().add((Component)associationsPanels, "West");
        this.getContentPane().add((Component)this.treePanel, "Center");
        this.treePanel.setTabFileTabbedPanel(this.flatFileTabbedPanel);
        this.treePanel.setDictionnaryPanel(this.dictionnaryLists);
        CloseView fv = new CloseView();
        this.addWindowListener(fv);
        this.setJMenuBar(new XmlMakerMenu());
        this.pack();
        this.setVisible(true);
        if (mappingFileName != null) {
            this.load(new File(mappingFileName));
        }
    }

    public static void main(String[] args) {
        Option helpOpt = new Option("help", "print this message.");
        OptionBuilder.withArgName((String)"mapping");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the mapping file, created by the GUI application");
        Option mappingOpt = OptionBuilder.create((String)"mapping");
        mappingOpt.setRequired(false);
        Options options = new Options();
        options.addOption(helpOpt);
        options.addOption(mappingOpt);
        BasicParser parser = new BasicParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args, true);
        }
        catch (ParseException exp) {
            XmlMakerGui.displayUsage(options);
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            System.exit(1);
        }
        if (line.hasOption("help")) {
            XmlMakerGui.displayUsage(options);
            System.exit(0);
        }
        mappingFileName = line.getOptionValue("mapping");
        System.out.println("mapping: " + mappingFileName);
        new XmlMakerGui();
    }

    public void clear() {
        this.flatFileTabbedPanel.flatFileContainer.flatFiles = new ArrayList();
        this.flatFileTabbedPanel.flatFileContainer.flatFiles.add(new FlatFile());
        this.treePanel.flatFileTabbedPanel.reload();
        this.dictionnaryLists.dictionaries.dictionaries = new ArrayList();
        this.treePanel.dictionaryPanel.reload();
        this.getContentPane().remove(this.treePanel);
        this.xsdTree = new XsdTreeStructImpl();
        JTextPaneMessageManager messageManager = new JTextPaneMessageManager();
        this.xsdTree.setMessageManager(messageManager);
        this.treePanel = new XsdTreePanelImpl(this.xsdTree, messageManager);
        this.getContentPane().add((Component)this.treePanel, "Center");
        this.treePanel.setTabFileTabbedPanel(this.flatFileTabbedPanel);
        this.treePanel.setDictionnaryPanel(this.dictionnaryLists);
        this.treePanel.xsdTree.treeModel.reload();
        this.treePanel.xsdTree.emptySelectionLists();
        this.treePanel.reload();
    }

    public class CloseView
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        public void windowClosing(WindowEvent e) {
            this.close();
        }

        public void close() {
            XmlMakerGui.this.setVisible(false);
            XmlMakerGui.this.dispose();
            System.exit(0);
        }
    }

    public class clearListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XmlMakerGui.this.clear();
        }
    }

    public class SaveListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XmlMakerGui.this.save();
        }
    }

    public class XmlMakerMenu
    extends JMenuBar {
        public XmlMakerMenu() {
            JMenu file = new JMenu(new String("File"));
            JMenuItem save = new JMenuItem(new String("Save mapping"));
            JMenuItem load = new JMenuItem(new String("Load mapping"));
            JMenuItem clear = new JMenuItem(new String("New mapping"));
            JMenuItem exit = new JMenuItem(new String("Exit"));
            clear.addActionListener(new clearListener());
            load.addActionListener(new LoadListener());
            save.addActionListener(new SaveListener());
            exit.addActionListener(new CloseView());
            file.add(clear);
            file.add(load);
            file.add(save);
            file.add(exit);
            this.add(file);
            JMenu help = new JMenu(new String("Help"));
            JMenuItem documentation = new JMenuItem("Documentation");
            documentation.addActionListener(new DisplayDocumentationListener());
            JMenuItem about = new JMenuItem("About");
            about.addActionListener(new DisplayAboutListener());
            help.add(documentation);
            help.add(about);
            this.add(help);
        }

        public class DisplayDocumentationListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditable(false);
                try {
                    editorPane.setContentType("text/html");
                    editorPane.setPage("file:doc/documentation.html");
                    JScrollPane areaScrollPane = new JScrollPane(editorPane);
                    areaScrollPane.setVerticalScrollBarPolicy(22);
                    areaScrollPane.setPreferredSize(new Dimension(600, 650));
                    JOptionPane.showMessageDialog(new JFrame(), areaScrollPane);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(new JFrame(), "Documentation not found.", "Documentation", 0);
                }
            }
        }

        public class DisplayAboutListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditable(false);
                try {
                    editorPane.setPage("file:doc/about.html");
                    editorPane.setContentType("text/html");
                    JScrollPane areaScrollPane = new JScrollPane(editorPane);
                    areaScrollPane.setVerticalScrollBarPolicy(22);
                    areaScrollPane.setPreferredSize(new Dimension(600, 650));
                    JOptionPane.showMessageDialog(new JFrame(), areaScrollPane);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(new JFrame(), "About not found.", "About...", 0);
                }
            }
        }
    }

    public class LoadListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            XmlMakerGui.this.load();
        }
    }
}

