/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import psidev.psi.mi.filemakers.xmlMaker.structure.Dictionary;
import psidev.psi.mi.filemakers.xmlMaker.structure.DictionaryContainer;
import psidev.psi.mi.filemakers.xsd.Utils;

public class DictionaryPanel
extends JPanel {
    public DefaultListModel listModel = new DefaultListModel();
    public JTextField separatorLbl = new JTextField(3);
    JCheckBox caseSensitiveb = new JCheckBox("case sensitive");
    public JList list = new JList(this.listModel);
    public DictionaryContainer dictionaries;

    public void editDictionnary() throws IOException {
        if (this.list.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(new JFrame(), "No dictionnary selected", "[PSI makers: PSI maker]", 0);
            return;
        }
        Dictionary curentDictionnary = (Dictionary)this.list.getSelectedValue();
        JTextField separator = new JTextField(curentDictionnary.getSeparator());
        JTextField fileName = new JTextField(curentDictionnary.getFileURL().getPath());
        JCheckBox caseSensitive = new JCheckBox();
        caseSensitive.setSelected(curentDictionnary.isCaseSensitive());
        try {
            Box panel = new Box(1);
            String defaultDirectory = Utils.lastVisitedDirectory;
            if (Utils.lastVisitedDictionaryDirectory != null) {
                defaultDirectory = Utils.lastVisitedDictionaryDirectory;
            }
            JFileChooser fc = new JFileChooser(defaultDirectory);
            fc.setSelectedFile(new File(curentDictionnary.getFileURL().getPath()));
            panel.add(new JLabel("Separator"));
            panel.add(separator);
            panel.add(new JLabel("Case sensitive"));
            panel.add(caseSensitive);
            fc.setAccessory(panel);
            int returnVal = fc.showOpenDialog(new JFrame());
            if (returnVal != 0) {
                return;
            }
            URL url = fc.getSelectedFile().toURL();
            Dictionary newDico = new Dictionary(url, separator.getText(), caseSensitive.isSelected());
            this.listModel.setElementAt(newDico, this.list.getSelectedIndex());
            this.caseSensitiveb.setSelected(newDico.isCaseSensitive());
            this.separatorLbl.setText(newDico.getSeparator());
        }
        catch (FileNotFoundException fe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load dictionnary", 0);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load dictionnary", 0);
        }
    }

    public DictionaryPanel(DictionaryContainer dictionaries) {
        super(new BorderLayout());
        this.separatorLbl.setEditable(false);
        this.dictionaries = dictionaries;
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Dictionary curentDictionnary = (Dictionary)DictionaryPanel.this.list.getSelectedValue();
                if (curentDictionnary != null) {
                    DictionaryPanel.this.caseSensitiveb.setSelected(curentDictionnary.caseSensitive);
                    DictionaryPanel.this.separatorLbl.setText(curentDictionnary.getSeparator());
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        Box buttonsPanel = new Box(1);
        buttonsPanel.setBorder(new TitledBorder(""));
        Box line1Panel = new Box(0);
        line1Panel.setBorder(new TitledBorder(""));
        Box line2Panel = new Box(0);
        line2Panel.setBorder(new TitledBorder(""));
        JButton newDicob = new JButton("New");
        Utils.setDefaultSize(newDicob);
        newDicob.addActionListener(new addDictionnaryListener());
        line1Panel.add(newDicob);
        JButton loadDicob = new JButton("Edit");
        Utils.setDefaultSize(loadDicob);
        loadDicob.addActionListener(new editDictionnaryListener());
        line1Panel.add(loadDicob);
        JButton displayDicob = new JButton("View");
        Utils.setDefaultSize(displayDicob);
        displayDicob.addActionListener(new displayALineListener());
        line1Panel.add(displayDicob);
        JButton separatorb = new JButton("Separator");
        Utils.setDefaultSize(separatorb);
        separatorb.addActionListener(new separatorListener());
        line2Panel.add(separatorb);
        line2Panel.add(this.separatorLbl);
        this.caseSensitiveb.addItemListener(new caseSensitiveListener());
        line2Panel.add(this.caseSensitiveb);
        buttonsPanel.add(line1Panel);
        buttonsPanel.add(line2Panel);
        this.list.setFixedCellHeight(10);
        this.list.setFixedCellWidth(60);
        this.list.setLayoutOrientation(0);
        this.list.setAutoscrolls(true);
        this.list.setVisible(true);
        this.listModel.removeAllElements();
        JScrollPane scrollList = new JScrollPane(this.list);
        this.add((Component)scrollList, "Center");
        this.add((Component)buttonsPanel, "South");
    }

    public int getSelectedDictionnary() {
        return this.list.getSelectedIndex();
    }

    public String[] getExampleList() {
        return ((Dictionary)this.listModel.elementAt(this.list.getSelectedIndex())).exampleList();
    }

    public void addDictionnary() throws IOException {
        JTextField separator = new JTextField();
        JTextField fileName = new JTextField();
        JCheckBox caseSensitive = new JCheckBox();
        try {
            Box panel = new Box(1);
            String defaultDirectory = Utils.lastVisitedDirectory;
            if (Utils.lastVisitedDictionaryDirectory != null) {
                defaultDirectory = Utils.lastVisitedDictionaryDirectory;
            }
            JFileChooser fc = new JFileChooser(defaultDirectory);
            panel.add(new JLabel("Separator"));
            panel.add(separator);
            panel.add(new JLabel("Case sensitive"));
            panel.add(caseSensitive);
            fc.setAccessory(panel);
            int returnVal = fc.showOpenDialog(new JFrame());
            if (returnVal != 0) {
                return;
            }
            URL url = fc.getSelectedFile().toURL();
            Dictionary dico = new Dictionary(url, separator.getText(), caseSensitive.isSelected());
            if (dico != null) {
                dico.index = this.listModel.getSize();
                this.listModel.addElement(dico);
                this.dictionaries.addDictionary(dico);
            }
            this.caseSensitiveb.setSelected(dico.isCaseSensitive());
            this.separatorLbl.setText(dico.getSeparator());
        }
        catch (FileNotFoundException fe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load dictionnary", 0);
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load dictionnary", 0);
        }
    }

    public void removeDictionnary() {
        JTextField separator = new JTextField();
        JTextField fileName = new JTextField();
        JCheckBox caseSensitive = new JCheckBox();
        if (this.list.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(new JFrame(), "No dictionnary selected", "[PSI makers: PSI maker]", 0);
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(new JFrame(), "All associations done to this dictionnary will be lost. Do you want to continue?", "Associatation of a dictionnary", 0);
        if (confirm != 0) {
            return;
        }
        this.listModel.setElementAt("empty", this.list.getSelectedIndex());
    }

    public void editSeparator() {
        if (this.list.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(new JFrame(), "No dictionnary selected", "[PSI makers: PSI maker]", 0);
            return;
        }
        Dictionary curentDictionnary = (Dictionary)this.list.getSelectedValue();
        JTextField separator = new JTextField(curentDictionnary.getSeparator());
        try {
            String s = JOptionPane.showInputDialog(new JFrame("[PSI makers: PSI maker] Flat File"), "Line Separator (use regular expression, e.g.: \\| \n", "\\|");
            if (s != null) {
                curentDictionnary.setSeparator(s);
                this.separatorLbl.setText(s);
            }
        }
        catch (NullPointerException npe) {
            JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load dictionnary", 0);
        }
    }

    public void setCaseSensitive() {
        if (this.list.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(new JFrame(), "No dictionnary selected", "[PSI makers: PSI maker]", 0);
            return;
        }
        Dictionary curentDictionnary = (Dictionary)this.list.getSelectedValue();
        curentDictionnary.setCaseSensitive(this.caseSensitiveb.isSelected());
    }

    public void displayALine() {
        if (this.list.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(new JFrame(), "No dictionnary selected", "[PSI makers: PSI maker]", 0);
            return;
        }
        String exampleLine = ((Dictionary)this.list.getSelectedValue()).exampleLine();
        String separator = ((Dictionary)this.list.getSelectedValue()).getSeparator();
        JList<String> exampleList = new JList<String>((String.valueOf(exampleLine) + " ").split(separator));
        JScrollPane scrollList = new JScrollPane(exampleList);
        JFrame frame = new JFrame();
        Box box = new Box(1);
        box.add(new JLabel("example line: " + exampleLine));
        box.add(new JLabel("separator: " + separator + ", case sensitive: " + ((Dictionary)this.list.getSelectedValue()).isCaseSensitive()));
        box.add(scrollList);
        frame.getContentPane().add(box);
        frame.setTitle("dictionnary: " + this.list.getSelectedValue());
        frame.pack();
        frame.show();
    }

    public void reload() {
        this.listModel.clear();
        int i = 0;
        while (i < this.dictionaries.dictionaries.size()) {
            this.listModel.addElement((Dictionary)this.dictionaries.dictionaries.get(i));
            ++i;
        }
    }

    public class editDictionnaryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                DictionaryPanel.this.editDictionnary();
            }
            catch (IOException urie) {
                JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load flat file", 0);
            }
        }
    }

    public class removeDictionnaryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DictionaryPanel.this.removeDictionnary();
        }
    }

    public class addDictionnaryListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                DictionaryPanel.this.addDictionnary();
                DictionaryPanel.this.list.setSelectedIndex(DictionaryPanel.this.list.getLastVisibleIndex());
            }
            catch (IOException urie) {
                JOptionPane.showMessageDialog(new JFrame(), "Unable to load file", "[PSI makers: PSI maker] load flat file", 0);
            }
        }
    }

    public class separatorListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DictionaryPanel.this.editSeparator();
        }
    }

    public class caseSensitiveListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            DictionaryPanel.this.setCaseSensitive();
        }
    }

    public class displayALineListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            DictionaryPanel.this.displayALine();
        }
    }
}

