/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import psidev.psi.mi.filemakers.xmlMaker.gui.FlatFilePanel;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFile;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFileContainer;
import psidev.psi.mi.filemakers.xsd.Utils;

public class FlatFileTabbedPanel
extends JPanel {
    public JTextField fileLbl = new JTextField(15);
    public JTabbedPane tabbedPane = new JTabbedPane();
    public FlatFileContainer flatFileContainer;
    public FlatFilePanel flatFilePanel;

    public FlatFileTabbedPanel(FlatFileContainer flatFiles) {
        this.setLayout(new BorderLayout());
        this.flatFileContainer = flatFiles;
        this.fileLbl.setEditable(false);
        Box buttonBox = new Box(0);
        JButton addTabb = new JButton("New");
        Utils.setDefaultSize(addTabb);
        addTabb.addActionListener(new addFlatFileListener());
        buttonBox.add(addTabb);
        buttonBox.add(this.fileLbl);
        this.flatFilePanel = new FlatFilePanel();
        this.tabbedPane.add(this.flatFilePanel);
        this.flatFileContainer.addFlatFile(this.flatFilePanel.flatFile);
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonBox, "North");
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                FlatFilePanel curentFlatFile = (FlatFilePanel)FlatFileTabbedPanel.this.tabbedPane.getSelectedComponent();
                if (curentFlatFile != null) {
                    try {
                        FlatFileTabbedPanel.this.fileLbl.setText(Utils.relativizeURL(curentFlatFile.flatFile.fileURL).getPath());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        };
        this.tabbedPane.addMouseListener(mouseListener);
    }

    public String getSelectedPath() {
        return String.valueOf(this.tabbedPane.getSelectedIndex()) + "." + ((FlatFilePanel)this.tabbedPane.getSelectedComponent()).getSelectedPath();
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public FlatFile getSelectedFlatFile() {
        return ((FlatFilePanel)this.tabbedPane.getComponent((int)this.getSelectedIndex())).flatFile;
    }

    public FlatFilePanel getSelectedFlatFilePanel() {
        return (FlatFilePanel)this.tabbedPane.getComponent(this.getSelectedIndex());
    }

    public FlatFile getFlatFileByIndex(int index) {
        return ((FlatFilePanel)this.tabbedPane.getComponent((int)index)).flatFile;
    }

    public void setTabTitle(int index, String name) {
        this.tabbedPane.setTitleAt(index, name);
    }

    public void reload() {
        this.tabbedPane.removeAll();
        int i = 0;
        while (i < this.flatFileContainer.flatFiles.size()) {
            FlatFilePanel ffp = new FlatFilePanel();
            ffp.flatFile = this.flatFileContainer.getFlatFile(i);
            ffp.updateList();
            this.tabbedPane.add(ffp);
            ++i;
        }
    }

    public class addFlatFileListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FlatFilePanel ffp = new FlatFilePanel();
            FlatFileTabbedPanel.this.tabbedPane.add(ffp);
            FlatFileTabbedPanel.this.flatFileContainer.addFlatFile(ffp.flatFile);
        }
    }
}

