/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.structure;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import psidev.psi.mi.filemakers.xmlMaker.mapping.FlatFileMapping;
import psidev.psi.mi.filemakers.xsd.FileMakersException;
import psidev.psi.mi.filemakers.xsd.Utils;

public class FlatFile {
    public int index = 0;
    public Integer indexI = new Integer(9);
    public boolean firstLineForTitles = false;
    private HashMap separators = new HashMap();
    public String line = "";
    public int lineNumber = 0;
    public String restOfPreviousLine = new String();
    public boolean endOfFile = true;
    public String lineSeparator = null;
    public BufferedReader input;
    public URL fileURL;

    public FlatFileMapping getMapping() {
        if (this.fileURL == null) {
            return null;
        }
        FlatFileMapping mapping = new FlatFileMapping();
        mapping.setFileURL(Utils.relativizeURL(this.fileURL).getPath());
        mapping.setLineSeparator(this.lineSeparator);
        mapping.setSeparators(this.separators);
        mapping.setFisrtLineForTitle(this.firstLineForTitles());
        return mapping;
    }

    public void setSeparator(String path, String separator) {
        this.separators.remove(path);
        this.separators.put(path, separator);
    }

    public String getSeparator(String path) {
        return (String)this.separators.get(path);
    }

    public String getElementAt(String path, String modelPath) {
        if (path.length() == 0) {
            return this.line;
        }
        if (modelPath == null) {
            modelPath = path;
        }
        boolean pointIndex = false;
        String subpath = "";
        String[] paths = path.split("\\.");
        String[] modelPaths = modelPath.split("\\.");
        String index = "0";
        String field = this.line;
        int len = paths.length;
        int i = 0;
        while (i < paths.length) {
            String separator = (String)this.separators.get(subpath);
            String[] fields = separator == null ? new String[]{field} : field.split(separator);
            try {
                field = fields[Integer.parseInt(paths[i])];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return "";
            }
            subpath = i > 0 ? String.valueOf(subpath) + "." + modelPaths[i] : String.valueOf(subpath) + modelPaths[i];
            ++i;
        }
        return field;
    }

    public void setLine(String aLine) {
        this.line = aLine;
    }

    public void reload() throws FileMakersException, MalformedURLException, IOException {
        try {
            if (this.fileURL != null) {
                this.input = new BufferedReader(new InputStreamReader(this.fileURL.openStream()));
            }
            this.lineNumber = 0;
        }
        catch (FileNotFoundException fe) {
            throw new FileMakersException("[PSI makers: PSI maker] Flat File: unable to load file");
        }
    }

    public void load(URL url) throws FileNotFoundException, NullPointerException, MalformedURLException, IOException {
        this.lineNumber = 0;
        this.fileURL = url;
        this.input = new BufferedReader(new InputStreamReader(this.fileURL.openStream()));
        this.nextLine();
    }

    public void nextLine() {
        block12: {
            if (this.input == null) {
                this.endOfFile = true;
                return;
            }
            if (this.lineSeparator == null) {
                try {
                    String newLine = this.input.readLine();
                    if (newLine != null) {
                        this.setLine(newLine);
                        this.endOfFile = false;
                        ++this.lineNumber;
                        break block12;
                    }
                    this.endOfFile = true;
                }
                catch (IOException e) {
                    System.out.println("nextline pb: " + e.toString());
                    this.endOfFile = true;
                }
            } else {
                String line = this.restOfPreviousLine;
                StringBuffer newLine = new StringBuffer();
                try {
                    while (line.indexOf(this.lineSeparator) < 0) {
                        newLine.append(line);
                        line = this.input.readLine();
                        ++this.lineNumber;
                    }
                    newLine.append(line.substring(0, line.indexOf(this.lineSeparator)));
                    this.restOfPreviousLine = line.substring(line.indexOf(this.lineSeparator) + this.lineSeparator.length());
                    if (newLine != null) {
                        this.setLine(newLine.toString());
                        this.endOfFile = false;
                    } else {
                        this.endOfFile = true;
                    }
                }
                catch (IOException e) {
                    if (newLine.length() != 0) {
                        this.setLine(newLine.toString());
                        this.endOfFile = true;
                    }
                    this.endOfFile = true;
                }
            }
        }
    }

    public void nextLineWithField(String path) {
        if (this.input == null) {
            return;
        }
        this.nextLine();
        String elt = this.getElementAt(path, null);
        while (this.getElementAt(path, null).length() == 0 && !this.endOfFile) {
            elt = this.getElementAt(path, null);
            this.nextLine();
        }
    }

    public boolean hasLine() {
        return !this.endOfFile;
    }

    public void restartFile() throws FileMakersException, IOException {
        this.reload();
        this.nextLine();
    }

    public boolean firstLineForTitles() {
        return this.firstLineForTitles;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getCurLine() {
        return this.line;
    }

    public void save(XMLEncoder oos) {
        oos.writeObject(new Boolean(this.firstLineForTitles));
        oos.writeObject(this.lineSeparator);
        oos.writeObject(this.lineSeparator);
        oos.writeObject(this.separators);
    }

    public void load(XMLDecoder ois) {
        this.firstLineForTitles = (Boolean)ois.readObject();
        this.lineSeparator = (String)ois.readObject();
        this.separators = (HashMap)ois.readObject();
        String filePath = (String)ois.readObject();
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }

    public void setEndOfFile(boolean endOfFile) {
        this.endOfFile = endOfFile;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Integer getIndexI() {
        return this.indexI;
    }

    public void setIndexI(Integer indexI) {
        this.indexI = indexI;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getRestOfPreviousLine() {
        return this.restOfPreviousLine;
    }

    public void setRestOfPreviousLine(String restOfPreviousLine) {
        this.restOfPreviousLine = restOfPreviousLine;
    }

    public HashMap getSeparators() {
        return this.separators;
    }

    public void setSeparators(HashMap separators) {
        this.separators = separators;
    }

    public boolean isTitleLine() {
        return this.firstLineForTitles;
    }

    public void setTitleLine(boolean titleLine) {
        this.firstLineForTitles = titleLine;
    }

    public String getLine() {
        return this.line;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setFirstLineForTitles(boolean firstLineForTitles) {
        System.out.println("title line: " + firstLineForTitles);
        this.firstLineForTitles = firstLineForTitles;
    }
}

