/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xsd;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.apache.cocoon.util.NetUtils;

public class Utils {
    private static final Dimension buttonsDimension = new Dimension(60, 17);
    public static String lastVisitedDirectory = ".";
    public static String lastVisitedMappingDirectory = null;
    public static String lastMappingFile = null;
    public static String lastVisitedSchemaDirectory = null;
    public static String lastVisitedDictionaryDirectory = null;
    public static String lastVisitedFlatFileDirectory = null;
    public static String lastVisitedDocumentDirectory = null;
    public static String lastVisitedOutputDirectory = null;

    public static void setDefaultSize(JButton button) {
        button.setPreferredSize(buttonsDimension);
        button.setMinimumSize(buttonsDimension);
        button.setMaximumSize(new Dimension(Short.MAX_VALUE, (short)buttonsDimension.getHeight()));
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            File r = f.getCanonicalFile();
            while (r != null) {
                l.add(r.getName());
                r = r.getParentFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    public static String getRelativePath(File home, File f) {
        List homelist = Utils.getPathList(home);
        List filelist = Utils.getPathList(f);
        String s = Utils.matchPathLists(homelist, filelist);
        return s;
    }

    public static URL relativizeURL(URL url) {
        if (url == null) {
            return url;
        }
        if (url.getProtocol() == "http") {
            return url;
        }
        try {
            if (url.toString().startsWith(System.getProperty("user.dir"))) {
                return new URL("file:" + NetUtils.relativize((String)("file:" + System.getProperty("user.dir") + "/"), (String)url.toString()));
            }
            return url;
        }
        catch (MalformedURLException e) {
            System.out.println(e.toString());
            return url;
        }
    }

    public static URL absolutizeURL(URL url) {
        System.out.println("url:" + url);
        if (url == null) {
            return url;
        }
        if (url.getProtocol() == "http") {
            return url;
        }
        try {
            return new URL("file://" + url.toString());
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private static String matchPathLists(List r, List f) {
        String s = "";
        int i = r.size() - 1;
        int j = f.size() - 1;
        while (i >= 0 && j >= 0 && r.get(i).equals(f.get(j))) {
            --i;
            --j;
        }
        while (i >= 0) {
            s = String.valueOf(s) + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = String.valueOf(s) + f.get(j) + File.separator;
            --j;
        }
        s = String.valueOf(s) + f.get(j);
        return s;
    }

    public static URL absolutizeURL(String url) {
        try {
            if (url.startsWith("http:") || url.startsWith("file:")) {
                return new URL(url);
            }
            return new URL("file:" + url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getFileName(URL url) {
        return Utils.getFileName(url.getPath());
    }

    public static String getFileName(String url) {
        int index = url.lastIndexOf("/");
        if (index > 0) {
            return url.substring(index + 1);
        }
        return url;
    }
}

