/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVMapEntry {
    protected static TreeMap<String, CVMapEntry> CVMap = new TreeMap();
    private static final int PSIMI_PAD_LEN = 4;
    private static final String PSIMI_PAD_STR = "0";
    private String targetCategory;
    private String sourceName;
    private String targetName;
    private String sourceTerm;
    private String targetTerm;
    private String sourceID;
    private String targetID;
    private boolean isSpecialCase;
    private TreeMap<String, String> addInfoMap = new TreeMap();

    protected CVMapEntry() {
    }

    protected void setSourceName(String sourceName) {
        GenUtil.validateString((String)sourceName);
        this.sourceName = sourceName;
    }

    protected void setTargetName(String targetName) {
        GenUtil.validateString((String)targetName);
        this.targetName = targetName;
    }

    protected void setTargetCategory(String category) {
        GenUtil.validateString((String)category);
        this.targetCategory = category;
    }

    protected void setSourceTerm(String sourceTerm) {
        GenUtil.validateString((String)sourceTerm);
        this.sourceTerm = sourceTerm;
    }

    protected void setTargetTerm(String targetTerm) {
        GenUtil.validateString((String)targetTerm);
        if (!"N/A".equals(targetTerm)) {
            this.targetTerm = targetTerm;
        }
    }

    protected void setSourceID(String sourceID) {
        GenUtil.validateString((String)sourceID);
        if (!"N/A".equals(sourceID)) {
            this.sourceID = sourceID;
        }
    }

    protected void setTargetID(String targetID) {
        GenUtil.validateString((String)targetID);
        if (!"N/A".equals(targetID)) {
            if ("psimi".equals(this.targetName)) {
                for (int i = targetID.length(); i < 4; ++i) {
                    targetID = PSIMI_PAD_STR + targetID;
                }
                targetID = "MI:" + targetID;
            }
            this.targetID = targetID;
        }
    }

    protected void setIsSpecialCase(boolean isSpecialCase) {
        this.isSpecialCase = isSpecialCase;
    }

    protected void setAddInfo(TreeMap<String, String> addInfoMap) {
        GenUtil.validateNotNull(addInfoMap);
        this.addInfoMap = addInfoMap;
    }

    protected String getTargetCategory() {
        return this.targetCategory;
    }

    protected String getSourceName() {
        return this.sourceName;
    }

    protected String getTargetName() {
        return this.targetName;
    }

    protected String getSourceTerm() {
        return this.sourceTerm;
    }

    protected String getTargetTerm() {
        return this.targetTerm;
    }

    protected String getSourceID() {
        return this.sourceID;
    }

    protected String getTargetID() {
        return this.targetID;
    }

    protected boolean isSpecialCase() {
        return this.isSpecialCase;
    }

    protected String getPSIMITerm_SL() {
        return this.getPSIMITerm("shortLabel");
    }

    protected String getPSIMITerm_FL() {
        return this.getPSIMITerm("fullName");
    }

    protected String getPSIMITermID() {
        if (!this.getTargetTerm().contains(";")) {
            return this.getTargetID();
        }
        String[] tempArr = this.getTargetTerm().split(";");
        if (tempArr[0].trim().equals("participant xref") || tempArr[0].trim().equals("unknown participant") || tempArr[0].trim().equals("experimental interac") && !tempArr[1].trim().equals("experimental interaction detection")) {
            return null;
        }
        return this.getTargetID();
    }

    private String getPSIMITerm(String termType) {
        if (!this.getTargetTerm().contains(";")) {
            return this.getTargetTerm();
        }
        String[] tempArr = this.getTargetTerm().split(";");
        if (tempArr[0].trim().equals("participant xref") || tempArr[0].trim().equals("unknown participant") || tempArr[0].trim().equals("experimental interac") && !tempArr[1].trim().equals("experimental interaction detection")) {
            return tempArr[1].trim();
        }
        if ("shortLabel".equals(termType)) {
            return tempArr[0].trim();
        }
        if ("fullName".equals(termType)) {
            return tempArr[1].trim();
        }
        return null;
    }

    protected String getAddInfo(String attName, String val) {
        GenUtil.validateString((String)attName);
        if (!this.isSpecialCase()) {
            return this.addInfoMap.get(attName);
        }
        return this.handleSpecialCase(attName, val);
    }

    private String handleSpecialCase(String attName, String val) {
        if (this.getSourceName().equals("bind") && this.getSourceTerm().equalsIgnoreCase("WormBase")) {
            return this.handleSpecialCase_BIND_WB(attName, val);
        }
        return null;
    }

    private String handleSpecialCase_BIND_WB(String attName, String val) {
        GenUtil.validateString((String)val);
        if ("protein".equalsIgnoreCase(attName)) {
            if (val.startsWith("WBGene")) {
                return "gene product";
            }
            if (val.startsWith("WP")) {
                return "identity";
            }
            if (val.startsWith("CE")) {
                return "identity";
            }
            return "gene product";
        }
        if ("dna".equalsIgnoreCase(attName)) {
            if (val.startsWith("WBGene")) {
                return "identity";
            }
            return "identity";
        }
        if ("rna".equalsIgnoreCase(attName)) {
            if (val.startsWith("WBGene")) {
                return "gene product";
            }
            return "gene product";
        }
        if ("gene".equalsIgnoreCase(attName) && val.startsWith("WP")) {
            return "gene product";
        }
        return null;
    }

    protected static void loadCVMappings(String CVMappingFileName, String sourceName, String targetName) {
        GenUtil.validateString((String)CVMappingFileName);
        GenUtil.validateString((String)sourceName);
        GenUtil.validateString((String)targetName);
        if (!sourceName.equals("bind")) {
            throw new IllegalArgumentException("Invalid mapping source: " + sourceName);
        }
        CVMapEntry.loadBINDCVMappings(CVMappingFileName, sourceName, targetName);
    }

    private static void loadBINDCVMappings(String CVMappingFileName, String sourceName, String targetName) {
        GenUtil.validateString((String)CVMappingFileName);
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(CVMappingFileName));
            while ((line = br.readLine()) != null) {
                String[] tempArr = line.split("\t");
                CVMapEntry mapEntry = new CVMapEntry();
                mapEntry.setSourceName(sourceName);
                mapEntry.setTargetName(targetName);
                mapEntry.setTargetCategory(tempArr[0]);
                mapEntry.setIsSpecialCase(Boolean.parseBoolean(tempArr[1]));
                mapEntry.setSourceTerm(tempArr[2]);
                mapEntry.setSourceID(tempArr[3]);
                mapEntry.setTargetTerm(tempArr[4]);
                mapEntry.setTargetID(tempArr[5]);
                if (tempArr[0].equals("xref")) {
                    TreeMap<String, String> addInfoMap = new TreeMap<String, String>();
                    addInfoMap.put("protein", tempArr[6]);
                    addInfoMap.put("dna", tempArr[7]);
                    addInfoMap.put("rna", tempArr[8]);
                    addInfoMap.put("gene", tempArr[9]);
                    addInfoMap.put("small molecule", tempArr[10]);
                    addInfoMap.put("complex", tempArr[11]);
                    addInfoMap.put("unknown participant", tempArr[12]);
                    mapEntry.setAddInfo(addInfoMap);
                }
                if (CVMap.containsKey(mapEntry.getSourceTerm())) {
                    System.err.println("Error: non unique source term: " + mapEntry.getSourceTerm());
                }
                CVMap.put(mapEntry.getSourceTerm(), mapEntry);
            }
            System.out.println("Done reading CV Mapping from file: " + CVMappingFileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println("Unable to load mapping CVs from file: " + CVMappingFileName);
        }
    }

    protected static CVMapEntry getMappedEntry(String sourceTerm) {
        GenUtil.validateString((String)sourceTerm);
        return CVMap.get(sourceTerm);
    }

    public String toString() {
        String tempStr = this.getTargetCategory() + "\t";
        tempStr = tempStr + this.getSourceName() + "\t";
        tempStr = tempStr + this.getSourceID() + "\t";
        tempStr = tempStr + this.getSourceTerm() + "\t";
        tempStr = tempStr + this.getTargetName() + "\t";
        tempStr = tempStr + this.getTargetID() + "\t";
        tempStr = tempStr + this.getTargetTerm() + "\t";
        for (String att : this.addInfoMap.keySet()) {
            String val = this.addInfoMap.get(att);
            tempStr = tempStr + att + "(" + val + ")" + ";";
        }
        return tempStr;
    }
}

