/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.impl;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNException;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.config.RepositoryConfigEntry;
import uk.ac.ebi.ook.loader.cvsutils.CVSException;
import uk.ac.ebi.ook.loader.cvsutils.CVSUpdater;
import uk.ac.ebi.ook.loader.impl.AbstractLoader;
import uk.ac.ebi.ook.loader.lucene.OntologyIndexer;
import uk.ac.ebi.ook.loader.parser.OBOFormatParser;
import uk.ac.ebi.ook.loader.svnutils.SVNUpdater;
import uk.ac.ebi.ook.model.interfaces.DbXref;
import uk.ac.ebi.ook.model.ojb.AnnotationBean;
import uk.ac.ebi.ook.model.ojb.LoaderRunBean;
import uk.ac.ebi.ook.model.ojb.TermBean;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.proteomics.common.CommonUtilities;
import uk.ac.ebi.proteomics.common.log.LoggerFactory;

public class ConfigurableOBOLoader
extends AbstractLoader {
    private static Logger logger = LoggerFactory.getLogger((Class)(class$uk$ac$ebi$ook$loader$impl$ConfigurableOBOLoader == null ? (class$uk$ac$ebi$ook$loader$impl$ConfigurableOBOLoader = ConfigurableOBOLoader.class$("uk.ac.ebi.ook.loader.impl.ConfigurableOBOLoader")) : class$uk$ac$ebi$ook$loader$impl$ConfigurableOBOLoader), (URL)CommonUtilities.getResource((String)"ols-config.properties"));
    private static final String LOCK_FILE = "ConfigurableOBOLoader.lock";
    private static final String ONTOLOGY_LOAD_FILE = "ontology-load.properties";
    private MultiMap ontologies = new MultiHashMap();
    private String currentFullName;
    private String currentShortName;
    private String currentDefinition;
    private String currentQueryURL;
    private String currentSourceURL;
    private static LoaderRunBean runner;
    private static final String FORCE_REFRESH_PARAM = "-f";
    private static final String SHOW_USAGE_PARAM = "--help";
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$impl$ConfigurableOBOLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int returnValue;
        block32: {
            File lockFile = null;
            returnValue = -1;
            try {
                block31: {
                    try {
                        OntologyQueryHandler oqh;
                        String fpath;
                        ConfigurableOBOLoader obo = new ConfigurableOBOLoader();
                        boolean forceRefresh = false;
                        if (args.length > 0) {
                            if (args[0].equals(FORCE_REFRESH_PARAM)) {
                                forceRefresh = true;
                            } else if (args[0].equals(SHOW_USAGE_PARAM)) {
                                obo.printUsage();
                                System.exit(0);
                            }
                        }
                        HashSet<String> refreshOntologies = null;
                        if (args.length > 1) {
                            refreshOntologies = new HashSet<String>();
                            for (int i = 1; i < args.length; ++i) {
                                if (args[i].startsWith("-")) continue;
                                refreshOntologies.add(args[i]);
                            }
                        }
                        if ((fpath = System.getProperty("java.io.tmpdir", ConfigurationManager.getProperty("lucene.index.path"))) == null) {
                            logger.fatal((Object)"Can't write lock file, exiting!");
                            System.exit(2);
                        }
                        if ((lockFile = new File(fpath + File.separator + LOCK_FILE)).exists()) {
                            logger.error((Object)("Another process is currently running. If this is not the case, remove the lock file:" + lockFile.getAbsolutePath()));
                            System.exit(2);
                        } else {
                            logger.warn((Object)"Creating lock file.");
                            PrintWriter out = new PrintWriter(new FileWriter(lockFile));
                            out.println(new java.util.Date());
                            out.close();
                        }
                        HashSet updatedFiles = new HashSet();
                        if (!forceRefresh) {
                            HashSet cvsConfig = ConfigurationManager.getCvsConfig();
                            Iterator iterator = cvsConfig.iterator();
                            while (iterator.hasNext()) {
                                RepositoryConfigEntry entry = (RepositoryConfigEntry)iterator.next();
                                CVSUpdater cvs = new CVSUpdater();
                                if (entry.useSSH()) {
                                    logger.warn((Object)"Using non-anonymous CVS over SSH");
                                    cvs.enableSSH();
                                }
                                HashSet tmpFileSet = cvs.updateOBOFiles(entry.getRepository(), entry.getUserName(), entry.getPassword());
                                updatedFiles.addAll(tmpFileSet);
                                if (!cvs.errorsDetected()) continue;
                                throw new CVSException(cvs.getErrorMessage());
                            }
                            HashSet svnConfig = ConfigurationManager.getSvnConfig();
                            Iterator iterator2 = svnConfig.iterator();
                            while (iterator2.hasNext()) {
                                RepositoryConfigEntry entry = (RepositoryConfigEntry)iterator2.next();
                                SVNUpdater svn = new SVNUpdater();
                                HashSet tmpFileSet = svn.updateOBOFiles(entry.getRepository(), entry.getUserName(), entry.getPassword());
                                updatedFiles.addAll(tmpFileSet);
                            }
                        }
                        runner = new LoaderRunBean();
                        runner.setRunDate(new Date(System.currentTimeMillis()));
                        if (!updatedFiles.isEmpty() || forceRefresh) {
                            if (!forceRefresh) {
                                logger.warn((Object)"Updated ontologies: ");
                                Iterator i = updatedFiles.iterator();
                                while (i.hasNext()) {
                                    Object file = i.next();
                                    logger.warn((Object)file.toString());
                                }
                            }
                            obo.loadAndIndex(forceRefresh, updatedFiles, refreshOntologies);
                        }
                        if (!(oqh = new OntologyQueryHandler()).storeStats(runner)) break block31;
                        logger.warn((Object)"Loader run statistics persisted to the database.");
                    }
                    catch (IOException e) {
                        logger.fatal((Object)e.getMessage(), (Throwable)e);
                        returnValue = 2;
                        Object var15_21 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                            logger.warn((Object)"Removed lock file");
                        }
                        break block32;
                    }
                    catch (CVSException e) {
                        logger.fatal((Object)e.getMessage(), (Throwable)e);
                        returnValue = 3;
                        Object var15_22 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                            logger.warn((Object)"Removed lock file");
                        }
                        break block32;
                    }
                    catch (SVNException e) {
                        logger.fatal((Object)e.getMessage(), (Throwable)e);
                        returnValue = 3;
                        Object var15_23 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                            logger.warn((Object)"Removed lock file");
                        }
                        break block32;
                    }
                    catch (PersistenceException pe) {
                        logger.fatal((Object)pe.getMessage(), (Throwable)pe);
                        returnValue = 2;
                        Object var15_24 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                            logger.warn((Object)"Removed lock file");
                        }
                        break block32;
                    }
                    catch (RuntimeException e) {
                        logger.fatal((Object)e.getMessage(), (Throwable)e);
                        returnValue = 2;
                        Object var15_25 = null;
                        if (lockFile != null) {
                            lockFile.delete();
                            logger.warn((Object)"Removed lock file");
                        }
                        break block32;
                    }
                }
                Object var15_20 = null;
                if (lockFile == null) break block32;
                lockFile.delete();
            }
            catch (Throwable throwable) {
                Object var15_26 = null;
                if (lockFile == null) throw throwable;
                lockFile.delete();
                logger.warn((Object)"Removed lock file");
                throw throwable;
            }
            logger.warn((Object)"Removed lock file");
        }
        if (returnValue > 0) {
            System.exit(returnValue);
        }
        if (runner.getLoadedOntologies() != null && runner.getLoadedOntologies().size() > 0) {
            System.exit(0);
            return;
        }
        System.exit(1);
    }

    public ConfigurableOBOLoader() {
        URL toLoad = CommonUtilities.getResource((String)ONTOLOGY_LOAD_FILE);
        if (toLoad == null) {
            throw new IllegalStateException("Configuration file not found, exiting!");
        }
        this.LoadConfigFile(toLoad);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void LoadConfigFile(URL toLoad) {
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(toLoad.openStream()));
                String oneLine = null;
                while ((oneLine = in.readLine()) != null) {
                    if (oneLine.startsWith("#") || oneLine.trim().length() < 1) continue;
                    this.parseConfigLine(oneLine);
                }
                Object var5_5 = null;
                if (in == null) return;
            }
            catch (IOException ioe) {
                logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                throw new IllegalStateException("Configuration not properly loaded, cannot continue.");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        in.close();
        return;
    }

    private void parseConfigLine(String line) {
        StringTokenizer st = new StringTokenizer(line, "\t");
        if (st.countTokens() >= 5) {
            String namespace = st.nextToken().trim();
            String fileName = st.nextToken().trim();
            String sourceURL = st.nextToken().trim();
            String shortLabel = st.nextToken().trim();
            String definition = st.nextToken().trim();
            String queryURL = null;
            if (st.countTokens() == 1) {
                queryURL = st.nextToken().trim();
            }
            this.ontologies.put((Object)namespace, (Object)new Ontology(namespace, fileName, definition, shortLabel, queryURL, sourceURL));
        } else {
            logger.warn((Object)("Invalid ontology configuration line: " + line));
        }
    }

    private void loadAndIndex(boolean forceRefresh, Set updatedOntologies, Set refreshOntologies) {
        boolean updateMasterIndex = false;
        boolean useFailover = new Boolean(ConfigurationManager.getProperty("failover.use"));
        Vector<String> files = new Vector<String>();
        logger.warn((Object)(this.ontologies.size() + " ontologies are defined to load."));
        File indexPath = null;
        if (ConfigurationManager.getProperty("lucene.index.path") != null) {
            indexPath = new File(ConfigurationManager.getProperty("lucene.index.path"));
        } else {
            logger.warn((Object)"Indexing not properly configured, skipping.");
        }
        Iterator label = this.ontologies.keySet().iterator();
        while (label.hasNext()) {
            files.clear();
            boolean toLoad = false;
            this.currentShortName = (String)label.next();
            Collection tmpColl = (Collection)this.ontologies.get((Object)this.currentShortName);
            Iterator i = tmpColl.iterator();
            while (i.hasNext()) {
                Ontology ontology = (Ontology)i.next();
                this.currentFullName = ontology.getFullName();
                this.currentDefinition = ontology.getDefinition();
                this.currentQueryURL = ontology.getQueryURL();
                this.currentSourceURL = ontology.getSourceURL();
                if (!forceRefresh) {
                    if (updatedOntologies.contains(ontology.getFileName())) {
                        toLoad = true;
                        updatedOntologies.remove(ontology.getFileName());
                    }
                } else if (refreshOntologies == null) {
                    toLoad = true;
                } else if (refreshOntologies.contains(this.currentShortName)) {
                    toLoad = true;
                }
                files.add(ontology.getFileName());
            }
            try {
                if (toLoad) {
                    Vector<String> resolvedFilePaths = new Vector<String>();
                    Iterator fileIt = files.iterator();
                    while (fileIt.hasNext()) {
                        String fileName = (String)fileIt.next();
                        if (fileName.endsWith("obo")) {
                            resolvedFilePaths.add(this.resolveFilePath(fileName));
                            continue;
                        }
                        if (fileName.endsWith("tar")) {
                            resolvedFilePaths.addAll(this.processTarFile(this.resolveFilePath(fileName)));
                            continue;
                        }
                        logger.error((Object)("Unknown file type: " + fileName));
                    }
                    logger.warn((Object)("Loading: [" + this.currentShortName + "] " + this.currentFullName));
                    logger.debug((Object)files.toString());
                    this.configure();
                    this.parse(resolvedFilePaths);
                    this.process();
                    if (this.currentShortName.equals("MOD")) {
                        HashMap<String, Boolean> keysToFilter = new HashMap<String, Boolean>();
                        keysToFilter.put("Artifact", Boolean.FALSE);
                        keysToFilter.put("DiffAvg", Boolean.TRUE);
                        keysToFilter.put("DiffFormula", Boolean.FALSE);
                        keysToFilter.put("DiffMono", Boolean.TRUE);
                        keysToFilter.put("Formula", Boolean.FALSE);
                        keysToFilter.put("MassAvg", Boolean.TRUE);
                        keysToFilter.put("MassMono", Boolean.TRUE);
                        keysToFilter.put("Origin", Boolean.FALSE);
                        keysToFilter.put("TermSpec", Boolean.FALSE);
                        this.xrefsToAnnotations(keysToFilter);
                    }
                    this.load(useFailover);
                    if (this.ontBean.getTerms() != null) {
                        runner.addLoadedOntology(this.currentShortName, this.ontBean.getTerms().size());
                    }
                    if (indexPath != null) {
                        OntologyQueryHandler oqh = new OntologyQueryHandler();
                        logger.warn((Object)"Fetching ontology for indexing.");
                        uk.ac.ebi.ook.model.interfaces.Ontology loaded = oqh.getOntology(this.currentShortName);
                        OntologyIndexer.indexOntology(loaded, indexPath);
                        updateMasterIndex = true;
                    }
                    this.unload(useFailover);
                    this.clearCache();
                    continue;
                }
                logger.debug((Object)("[" + this.currentShortName + "] " + this.currentFullName + " is up to date."));
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (PersistenceException pe) {
                logger.error((Object)pe.getMessage(), (Throwable)pe);
            }
        }
        if (updateMasterIndex) {
            OntologyIndexer.mergeAllIndexes(indexPath);
        }
        if (updatedOntologies.size() > 0) {
            logger.warn((Object)"The following files were updated from CVS but are unknown to the loader:");
            Iterator i = updatedOntologies.iterator();
            while (i.hasNext()) {
                logger.warn(i.next());
            }
        }
    }

    private String resolveFilePath(String fileName) throws IllegalStateException {
        String retval = null;
        HashSet cvsConfig = ConfigurationManager.getCvsConfig();
        Iterator iterator = cvsConfig.iterator();
        while (iterator.hasNext()) {
            RepositoryConfigEntry cvs = (RepositoryConfigEntry)iterator.next();
            File f = new File(cvs.getRepository() + File.separator + fileName);
            logger.debug((Object)("looking for " + f.getAbsolutePath()));
            if (f.exists()) {
                if (retval == null) {
                    retval = f.getAbsolutePath();
                    continue;
                }
                throw new IllegalStateException("Ambiguous location for file: " + retval + ", " + f.getAbsolutePath());
            }
            logger.debug((Object)(f.getAbsolutePath() + " does not exist!"));
        }
        HashSet svnConfig = ConfigurationManager.getSvnConfig();
        Iterator iterator2 = svnConfig.iterator();
        while (iterator2.hasNext()) {
            RepositoryConfigEntry svn = (RepositoryConfigEntry)iterator2.next();
            File f = new File(svn.getRepository() + File.separator + fileName);
            logger.debug((Object)("looking for " + f.getAbsolutePath()));
            if (f.exists()) {
                if (retval == null) {
                    retval = f.getAbsolutePath();
                    continue;
                }
                throw new IllegalStateException("Ambiguous location for file: " + retval + ", " + f.getAbsolutePath());
            }
            logger.debug((Object)(f.getAbsolutePath() + " does not exist!"));
        }
        if (retval != null) {
            return retval;
        }
        throw new IllegalStateException("File not found: " + fileName);
    }

    private void clearCache() {
        String urlProp = ConfigurationManager.getProperty("loader.cacherefresh.url");
        if (urlProp != null && !"".equals(urlProp.trim())) {
            String[] urls = urlProp.split(",");
            for (int i = 0; i < urls.length; ++i) {
                try {
                    URL url = new URL(urls[i]);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    if (conn.getResponseCode() == 200) {
                        logger.warn((Object)("Cache Cleared on " + urls[i]));
                        continue;
                    }
                    logger.warn((Object)("Could not clear cache: " + conn.getResponseMessage() + " at " + urls[i]));
                    continue;
                }
                catch (IOException e) {
                    logger.error((Object)("While clearing cache: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void xrefsToAnnotations(Map keysToConvert) {
        if (this.ontBean.getTerms() != null) {
            Iterator terms = this.ontBean.getTerms().iterator();
            while (terms.hasNext()) {
                TermBean termBean = (TermBean)terms.next();
                if (termBean.getXrefs() == null) continue;
                ArrayList<AnnotationBean> annotations = new ArrayList<AnnotationBean>();
                if (termBean.getAnnotations() != null) {
                    annotations.addAll(termBean.getAnnotations());
                }
                ArrayList<DbXref> dbxref = new ArrayList<DbXref>();
                Iterator xrefs = termBean.getXrefs().iterator();
                while (xrefs.hasNext()) {
                    DbXref info = (DbXref)xrefs.next();
                    if (keysToConvert == null || keysToConvert != null && keysToConvert.keySet().contains(info.getDbName())) {
                        AnnotationBean annot = new AnnotationBean();
                        annot.setAnnotationType(StringEscapeUtils.escapeXml((String)info.getDbName()));
                        if (keysToConvert != null && keysToConvert.get(info.getDbName()) != null && keysToConvert.get(info.getDbName()).equals(Boolean.TRUE)) {
                            annot.setAnnotationDoubleValue(info.getDescription());
                        } else {
                            annot.setAnnotationStringValue(StringEscapeUtils.escapeXml((String)info.getDescription()));
                        }
                        annotations.add(annot);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Added annotation:" + annot.toString()));
                        continue;
                    }
                    dbxref.add(info);
                }
                if (dbxref.isEmpty()) {
                    termBean.setXrefs(null);
                } else {
                    termBean.setXrefs(dbxref);
                }
                termBean.setAnnotations(annotations);
            }
        }
    }

    private Collection processTarFile(String fileName) {
        ArrayList<String> retval = new ArrayList<String>();
        String untarDir = System.getProperty("java.io.tmpdir");
        if (untarDir == null) {
            untarDir = ".";
        }
        logger.warn((Object)("TAR file extracted to : " + untarDir));
        try {
            TarInputStream tin = new TarInputStream((InputStream)new FileInputStream(fileName));
            TarEntry tarEntry = tin.getNextEntry();
            while (tarEntry != null) {
                File destPath = new File(untarDir + File.separatorChar + tarEntry.getName());
                if (!tarEntry.isDirectory()) {
                    if (destPath.getAbsolutePath().endsWith("obo")) {
                        destPath.deleteOnExit();
                        FileOutputStream fout = new FileOutputStream(destPath);
                        tin.copyEntryContents((OutputStream)fout);
                        fout.close();
                        retval.add(destPath.getAbsolutePath());
                    } else {
                        logger.warn((Object)("Skipping file: " + destPath.getAbsolutePath()));
                    }
                } else {
                    destPath.mkdir();
                }
                tarEntry = tin.getNextEntry();
            }
            tin.close();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new RuntimeException("Error processing TAR file: " + ioe.getMessage(), ioe);
        }
        return retval;
    }

    protected void configure() {
        this.ONTOLOGY_DEFINITION = this.safeTrim(this.currentDefinition);
        this.FULL_NAME = this.safeTrim(this.currentFullName);
        this.SHORT_NAME = this.safeTrim(this.currentShortName);
        this.QUERY_URL = this.safeTrim(this.currentQueryURL);
        this.SOURCE_URL = this.safeTrim(this.currentSourceURL);
        this.parser = new OBOFormatParser();
    }

    protected void parse(Object params) throws IOException {
        ((OBOFormatParser)this.parser).configure((Vector)params);
        this.parser.parseFile();
    }

    protected void load(boolean useFailover) throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process()?");
        }
        logger.warn((Object)"Getting main broker.");
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        oqh.storeOntology(this.ontBean, true);
        logger.warn((Object)("Success! Loaded " + this.ontBean.getTerms().size() + " terms for " + this.ontBean.getShortOntologyName()));
        oqh.switchLoadedFlag(this.ontBean.getShortOntologyName());
        if (useFailover) {
            String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
            if (dbAlias == null) {
                throw new PersistenceException("Failover dbalias not properly configured");
            }
            logger.warn((Object)"Getting secondary broker.");
            oqh = new OntologyQueryHandler(dbAlias);
            oqh.storeOntology(this.ontBean, true);
            logger.warn((Object)("Success! Loaded " + this.ontBean.getTerms().size() + " terms for " + this.ontBean.getShortOntologyName()));
            oqh.switchLoadedFlag(this.ontBean.getShortOntologyName());
        }
    }

    protected void unload(boolean useFailover) throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process() and load()?");
        }
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        Collection loaded = oqh.getOntologyReport(this.ontBean.getShortOntologyName(), false);
        if (loaded != null && loaded.size() > 0) {
            logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies), this may take some time."));
            Iterator i = loaded.iterator();
            while (i.hasNext()) {
                Object[] objects = (Object[])i.next();
                boolean isOracle = Boolean.valueOf(ConfigurationManager.getProperty("ols.dbalias.is_oracle"));
                oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle);
            }
        }
        if (useFailover) {
            String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
            if (dbAlias == null) {
                throw new PersistenceException("Failover dbalias not properly configured");
            }
            oqh = new OntologyQueryHandler(dbAlias);
            loaded = oqh.getOntologyReport(this.ontBean.getShortOntologyName(), false);
            if (loaded != null && loaded.size() > 0) {
                logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies) from failover database."));
                Iterator i = loaded.iterator();
                while (i.hasNext()) {
                    Object[] objects = (Object[])i.next();
                    boolean isOracle = Boolean.valueOf(ConfigurationManager.getProperty("failover.dbalias.is_oracle"));
                    oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle);
                }
            }
        }
    }

    protected void printUsage() {
        logger.fatal((Object)"Usage: ConfigurableOBOLoader [-f] [--help] [ontologylabels]");
        logger.fatal((Object)"\t-f : force refresh of ontologies (optional)");
        logger.fatal((Object)"\t--helpf : prints this message (optional)");
        logger.fatal((Object)"\tontologylabels : list of ontologies to refresh. if not indicated, all ontologies will be refreshed. (optional)");
        logger.fatal((Object)"\tEnsure that you the file ontology-load.properties exists and is in the classpath");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Ontology {
        private String namespace;
        private String fileName;
        private String definition;
        private String fullName;
        private String queryURL;
        private String sourceURL;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getQueryURL() {
            return this.queryURL;
        }

        public void setQueryURL(String queryURL) {
            this.queryURL = queryURL;
        }

        public String getSourceURL() {
            return this.sourceURL;
        }

        public void setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
        }

        public Ontology(String namespace, String fileName, String definition, String fullName, String queryURL, String sourceURL) {
            this.namespace = namespace;
            this.fileName = fileName;
            this.definition = definition;
            this.fullName = fullName;
            this.queryURL = queryURL;
            this.sourceURL = sourceURL;
        }

        public String toString() {
            return "Ontology{" + "namespace='" + this.namespace + '\'' + ", sourceURL='" + this.sourceURL + '\'' + ", fileName='" + this.fileName + '\'' + ", queryURL='" + this.queryURL + '\'' + ", definition='" + this.definition + '\'' + ", fullName='" + this.fullName + '\'' + '}';
        }
    }
}

