/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.model.interfaces.Ontology;
import uk.ac.ebi.ook.model.interfaces.Term;
import uk.ac.ebi.ook.model.interfaces.TermSynonym;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.ook.persistence.query.ServiceQueryHandler;
import uk.ac.ebi.proteomics.common.CommonUtilities;
import uk.ac.ebi.proteomics.common.log.LoggerFactory;

public class OntologyIndexer {
    private static final String INDEX_PREFIX = "__";
    private static final String MASTER_INDEX = "MASTER_INDEX";
    public static final String ONTOLOGY_NAME = "ontology_name";
    public static final String TERM_NAME = "term_name";
    public static final String TERM_NAME_LENGTH = "term_name_len";
    public static final String TERM_ACCESSION = "term_acc";
    public static final String TERM_IS_SYNONYM = "term_syn";
    public static final String TERM_IS_OBSOLETE = "term_obs";
    public static final String TERM_ID = "term_id";
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$uk$ac$ebi$ook$loader$lucene$OntologyIndexer == null ? (class$uk$ac$ebi$ook$loader$lucene$OntologyIndexer = OntologyIndexer.class$("uk.ac.ebi.ook.loader.lucene.OntologyIndexer")) : class$uk$ac$ebi$ook$loader$lucene$OntologyIndexer), (URL)CommonUtilities.getResource((String)"ols-config.properties"));
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$lucene$OntologyIndexer;

    public static void indexOntology(Ontology ontology, File outDir) {
        if (ontology == null) {
            logger.warn((Object)"Null ontology passed to indexer, aborting.");
            return;
        }
        try {
            IndexWriter writer;
            if (outDir.isDirectory()) {
                String ontologyName = ontology.getShortOntologyName();
                logger.warn((Object)("Indexing ontology: " + ontologyName));
                String path = outDir.getAbsolutePath();
                if (!path.endsWith(File.separator)) {
                    path = path + File.separator;
                }
                if (ontology.getShortOntologyName() == null) {
                    logger.warn((Object)"ShortOntologyName is null, this is badness!");
                    return;
                }
                path = path + INDEX_PREFIX + ontology.getShortOntologyName().toUpperCase();
                File savePath = new File(path);
                writer = new IndexWriter(savePath, (Analyzer)new StandardAnalyzer(), true);
                writer.mergeFactor = 200;
                writer.minMergeDocs = 200;
                logger.warn((Object)"Fetching terms to index.");
                if (ontology.getTerms() == null) {
                    logger.warn((Object)"Ontology has no terms, this is badness!");
                    return;
                }
                ontology.getTerms().iterator();
                logger.warn((Object)("Size of ontology to index: " + ontology.getTerms().size()));
                int counter = 0;
                int cacheCount = -1;
                int currentCount = -1;
                int totalCount = ontology.getTerms().size();
                Iterator i = ontology.getTerms().iterator();
                while (i.hasNext()) {
                    float ratio;
                    if ((currentCount = Math.round(ratio = (float)(++counter) / (float)totalCount * 100.0f)) % 5 == 0 && currentCount != cacheCount) {
                        cacheCount = currentCount;
                        logger.info((Object)("Indexed: %" + currentCount));
                    }
                    Term term = (Term)i.next();
                    Document termDoc = new Document();
                    termDoc.add(Field.Text((String)ONTOLOGY_NAME, (String)("" + ontologyName)));
                    termDoc.add(Field.Text((String)TERM_NAME, (String)("" + term.getName())));
                    termDoc.add(Field.Text((String)TERM_ACCESSION, (String)("" + term.getIdentifier())));
                    termDoc.add(Field.Text((String)TERM_NAME_LENGTH, (String)OntologyIndexer.makeLength(term.getName())));
                    termDoc.add(Field.Text((String)TERM_IS_SYNONYM, (String)Boolean.FALSE.toString()));
                    termDoc.add(Field.Text((String)TERM_IS_OBSOLETE, (String)Boolean.toString(term.isObsolete())));
                    termDoc.add(Field.UnIndexed((String)TERM_ID, (String)("" + term.getTermId())));
                    writer.addDocument(termDoc);
                    if (term.getSynonyms() == null) continue;
                    Iterator j = term.getSynonyms().iterator();
                    while (j.hasNext()) {
                        TermSynonym ts = (TermSynonym)j.next();
                        termDoc = new Document();
                        termDoc.add(Field.Text((String)ONTOLOGY_NAME, (String)("" + ontologyName)));
                        termDoc.add(Field.Text((String)TERM_NAME, (String)("" + ts.getSynonym())));
                        termDoc.add(Field.Text((String)TERM_ACCESSION, (String)term.getIdentifier()));
                        termDoc.add(Field.Text((String)TERM_NAME_LENGTH, (String)OntologyIndexer.makeLength(ts.getSynonym())));
                        termDoc.add(Field.Text((String)TERM_IS_SYNONYM, (String)Boolean.TRUE.toString()));
                        termDoc.add(Field.Text((String)TERM_IS_OBSOLETE, (String)Boolean.toString(term.isObsolete())));
                        termDoc.add(Field.UnIndexed((String)TERM_ID, (String)("" + term.getTermId())));
                        writer.addDocument(termDoc);
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid directory specified: " + outDir);
            }
            logger.warn((Object)"Optimizing index");
            writer.optimize();
            writer.close();
            logger.warn((Object)"done!");
        }
        catch (Exception e) {
            logger.error((Object)("Error during indexing: " + e.getMessage()), (Throwable)e);
        }
    }

    private static String makeLength(String str) {
        String retval = str != null ? "" + str.length() : "0";
        return retval;
    }

    public static void mergeAllIndexes(File indexDir) {
        try {
            if (!indexDir.isDirectory()) {
                throw new IllegalArgumentException("Invalid directory specified: " + indexDir);
            }
            File masterDir = new File(indexDir.getAbsolutePath() + File.separator + MASTER_INDEX);
            IndexWriter writer = new IndexWriter(masterDir, (Analyzer)new StandardAnalyzer(), true);
            ArrayList<IndexReader> indexes = new ArrayList<IndexReader>();
            String[] subDirs = indexDir.list();
            for (int i = 0; i < subDirs.length; ++i) {
                String subDir = subDirs[i];
                if (!subDir.startsWith(INDEX_PREFIX)) continue;
                logger.warn((Object)("Merging: " + subDir));
                indexes.add(IndexReader.open((String)(indexDir.getAbsolutePath() + File.separator + subDir)));
            }
            writer.addIndexes(indexes.toArray(new IndexReader[0]));
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)("Error during merging: " + e.getMessage()), (Throwable)e);
        }
    }

    public static IndexReader getIndexReader(String shortOntologyName) {
        try {
            File index = OntologyIndexer.getIndexFile(shortOntologyName);
            if (IndexReader.indexExists((File)index)) {
                return IndexReader.open((File)index);
            }
            logger.warn((Object)("Not a valid index file: " + index.getAbsolutePath()));
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)ioe.getMessage(), (Throwable)ioe);
            return null;
        }
    }

    private static File getIndexFile(String shortOntologyName) throws IOException {
        if (shortOntologyName != null) {
            String indexPathStr = ConfigurationManager.getProperty("lucene.index.path");
            if (indexPathStr == null) {
                logger.error((Object)"OntologyIndexer.getIndexFile(): Index property not set, cannot continue!");
                return null;
            }
            File indexFile = new File(indexPathStr + File.separator + INDEX_PREFIX + shortOntologyName.trim().toUpperCase());
            if (!indexFile.exists()) {
                throw new FileNotFoundException("Lucene Index not created for ontology: " + shortOntologyName.trim() + "\nLooked in path: " + indexFile.getAbsolutePath());
            }
            return indexFile;
        }
        return OntologyIndexer.getMasterIndexFile();
    }

    private static File getMasterIndexFile() throws IOException {
        String indexPathStr = ConfigurationManager.getProperty("lucene.index.path");
        if (indexPathStr == null) {
            logger.error((Object)"OntologyIndexer.getMasterIndexFile(): Index property not set, cannot continue!");
            return null;
        }
        File masterIndexFile = new File(indexPathStr + File.separator + MASTER_INDEX);
        if (!masterIndexFile.exists()) {
            throw new FileNotFoundException("Lucene Master Index not created!: " + masterIndexFile.getAbsolutePath());
        }
        return masterIndexFile;
    }

    public static void main(String[] args) {
        try {
            ServiceQueryHandler qh = new ServiceQueryHandler();
            HashMap ontologies = qh.getOntologyNames();
            String indexPath = ConfigurationManager.getProperty("lucene.index.path");
            if (indexPath != null) {
                File path = new File(indexPath);
                OntologyQueryHandler oqh = new OntologyQueryHandler();
                Iterator i = ontologies.keySet().iterator();
                while (i.hasNext()) {
                    String label = (String)i.next();
                    logger.warn((Object)("Fetching ontology: " + label));
                    OntologyIndexer.indexOntology(oqh.getOntology(label), path);
                }
                OntologyIndexer.mergeAllIndexes(path);
            } else {
                logger.error((Object)"No path set for indexing");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

