/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.persistence.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.collections.MultiHashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import uk.ac.ebi.ook.loader.lucene.OntologyIndexer;

public class IndexedTermQueryHandler {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$persistence$lucene$IndexedTermQueryHandler == null ? (class$uk$ac$ebi$ook$persistence$lucene$IndexedTermQueryHandler = IndexedTermQueryHandler.class$("uk.ac.ebi.ook.persistence.lucene.IndexedTermQueryHandler")) : class$uk$ac$ebi$ook$persistence$lucene$IndexedTermQueryHandler));
    private static String INTERNAL_SEPARATOR = "@@";
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$lucene$IndexedTermQueryHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getTermsByName(String partialName, String ontologyName, boolean includeObsoleteTerms, Integer maxHits, boolean reverseKeyOrder, boolean includePrefix) {
        HashMap<String, String> retval;
        block31: {
            block30: {
                IOException ioe222;
                IndexSearcher searcher;
                IndexReader reader;
                block27: {
                    MultiHashMap tempMap = new MultiHashMap();
                    retval = new HashMap<String, String>();
                    reader = OntologyIndexer.getIndexReader(ontologyName);
                    searcher = null;
                    if (reader == null) break block30;
                    searcher = new IndexSearcher(reader);
                    TopDocs docs = this.getTopDocsByName(partialName, (Searcher)searcher, maxHits);
                    if (docs != null) {
                        boolean includeInRetval = true;
                        for (int i = 0; i < docs.scoreDocs.length; ++i) {
                            Document doc = searcher.doc(docs.scoreDocs[i].doc);
                            String termName = doc.getField("term_name").stringValue();
                            String termAcc = doc.getField("term_acc").stringValue();
                            String isSyn = doc.getField("term_syn").stringValue();
                            String isObs = doc.getField("term_obs").stringValue();
                            if (includePrefix) {
                                String ontName = doc.getField("ontology_name").stringValue();
                                termName = ontName + ":" + termName;
                            }
                            if (!includeObsoleteTerms) {
                                includeInRetval = !Boolean.TRUE.toString().equals(isObs);
                            }
                            if (!includeInRetval) continue;
                            if (!reverseKeyOrder) {
                                tempMap.put((Object)termAcc, (Object)(termName + INTERNAL_SEPARATOR + isSyn));
                                continue;
                            }
                            tempMap.put((Object)termName, (Object)termAcc);
                        }
                        if (!tempMap.isEmpty()) {
                            Iterator i = tempMap.keySet().iterator();
                            while (i.hasNext()) {
                                Collection values;
                                String name;
                                if (reverseKeyOrder) {
                                    name = (String)i.next();
                                    values = (Collection)tempMap.get((Object)name);
                                    if (values.size() == 1) {
                                        String acc = (String)values.toArray()[0];
                                        retval.put(name, acc);
                                        continue;
                                    }
                                    Iterator j = values.iterator();
                                    while (j.hasNext()) {
                                        String acc = (String)j.next();
                                        retval.put(name + " [" + acc + "]", acc);
                                    }
                                    continue;
                                }
                                String acc = (String)i.next();
                                values = (Collection)tempMap.get((Object)acc);
                                name = this.getPreferredValueForAccession(values);
                                retval.put(acc, name);
                            }
                        }
                    }
                    Object var25_29 = null;
                    if (searcher == null) break block27;
                    try {
                        searcher.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block31;
                {
                    catch (Exception e) {
                        IOException ioe222;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        HashMap hashMap = new HashMap();
                        Object var25_30 = null;
                        if (searcher != null) {
                            try {
                                searcher.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        return hashMap;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var25_31 = null;
                    if (searcher != null) {
                        try {
                            searcher.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            logger.warn((Object)"getTermsByName: couldn't get valid indexreader, so aborting");
            return new HashMap();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getTermsByLuceneQuery(String query, String ontologyName, boolean includeObsoleteTerms, Integer maxHits, boolean reverseKeyOrder, boolean includePrefix) {
        HashMap<String, String> retval;
        block31: {
            block30: {
                IOException ioe222;
                IndexSearcher searcher;
                IndexReader reader;
                block27: {
                    MultiHashMap tempMap = new MultiHashMap();
                    retval = new HashMap<String, String>();
                    reader = OntologyIndexer.getIndexReader(ontologyName);
                    searcher = null;
                    if (reader == null) break block30;
                    searcher = new IndexSearcher(reader);
                    TopDocs docs = this.getTopDocsByRawQuery(query, (Searcher)searcher, maxHits);
                    if (docs != null) {
                        boolean includeInRetval = true;
                        for (int i = 0; i < docs.scoreDocs.length; ++i) {
                            Document doc = searcher.doc(docs.scoreDocs[i].doc);
                            String termName = doc.getField("term_name").stringValue();
                            String termAcc = doc.getField("term_acc").stringValue();
                            String isSyn = doc.getField("term_syn").stringValue();
                            String isObs = doc.getField("term_obs").stringValue();
                            if (includePrefix) {
                                String ontName = doc.getField("ontology_name").stringValue();
                                termName = ontName + ":" + termName;
                            }
                            if (!includeObsoleteTerms) {
                                includeInRetval = !Boolean.TRUE.toString().equals(isObs);
                            }
                            if (!includeInRetval) continue;
                            if (!reverseKeyOrder) {
                                tempMap.put((Object)termAcc, (Object)(termName + INTERNAL_SEPARATOR + isSyn));
                                continue;
                            }
                            tempMap.put((Object)termName, (Object)termAcc);
                        }
                        if (!tempMap.isEmpty()) {
                            Iterator i = tempMap.keySet().iterator();
                            while (i.hasNext()) {
                                Collection values;
                                String name;
                                if (reverseKeyOrder) {
                                    name = (String)i.next();
                                    values = (Collection)tempMap.get((Object)name);
                                    if (values.size() == 1) {
                                        String acc = (String)values.toArray()[0];
                                        retval.put(name, acc);
                                        continue;
                                    }
                                    Iterator j = values.iterator();
                                    while (j.hasNext()) {
                                        String acc = (String)j.next();
                                        retval.put(name + " [" + acc + "]", acc);
                                    }
                                    continue;
                                }
                                String acc = (String)i.next();
                                values = (Collection)tempMap.get((Object)acc);
                                name = this.getPreferredValueForAccession(values);
                                retval.put(acc, name);
                            }
                        }
                    }
                    Object var25_29 = null;
                    if (searcher == null) break block27;
                    try {
                        searcher.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block31;
                {
                    catch (Exception e) {
                        IOException ioe222;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        HashMap hashMap = new HashMap();
                        Object var25_30 = null;
                        if (searcher != null) {
                            try {
                                searcher.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        return hashMap;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var25_31 = null;
                    if (searcher != null) {
                        try {
                            searcher.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            logger.warn((Object)"getTermsByName: couldn't get valid indexreader, so aborting");
            return new HashMap();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getTermCountByName(String partialName, String ontologyName) {
        int retval;
        block22: {
            block21: {
                IOException ioe222;
                IndexSearcher searcher;
                IndexReader reader;
                block18: {
                    block17: {
                        retval = -1;
                        reader = OntologyIndexer.getIndexReader(ontologyName);
                        searcher = null;
                        if (reader == null) break block21;
                        searcher = new IndexSearcher(reader);
                        TopDocs docs = this.getTopDocsByName(partialName, (Searcher)searcher, null);
                        if (docs == null) break block17;
                        retval = docs.totalHits;
                    }
                    Object var9_8 = null;
                    if (searcher == null) break block18;
                    try {
                        searcher.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block22;
                {
                    catch (Exception e) {
                        IOException ioe222;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        int n = retval;
                        Object var9_9 = null;
                        if (searcher != null) {
                            try {
                                searcher.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var9_10 = null;
                    if (searcher != null) {
                        try {
                            searcher.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            logger.warn((Object)"getTermsByName: couldn't get valid indexreader, so aborting");
            return retval;
        }
        return retval;
    }

    private String permissiveTokenizeQuery(String str) {
        StringBuffer buffer = new StringBuffer();
        if (str != null) {
            try {
                StringTokenizer stk = new StringTokenizer(str.trim().toLowerCase());
                int count = stk.countTokens();
                if (count == 1) {
                    return buffer.append(this.removeControlChars(stk.nextToken())).append('*').toString();
                }
                for (int i = 0; i < count - 1; ++i) {
                    buffer.append(" +").append(this.removeControlChars(stk.nextToken()));
                }
                buffer.append(" +").append(this.removeControlChars(stk.nextToken())).append('*');
            }
            catch (NoSuchElementException e) {
                logger.error((Object)("Error during tokenization of query string. Initial string was >" + str + "< Process so far gave: " + buffer.toString()));
            }
        } else {
            return null;
        }
        logger.debug((Object)("Query is:" + buffer.toString()));
        return buffer.toString();
    }

    private String restrictiveTokenizeQuery(String str) {
        StringBuffer buffer = new StringBuffer();
        if (str != null) {
            try {
                StringTokenizer stk = new StringTokenizer(str.trim().toLowerCase());
                int count = stk.countTokens();
                if (count == 1) {
                    buffer.append(stk.nextToken());
                } else {
                    for (int i = 0; i < count; ++i) {
                        buffer.append('+').append(stk.nextToken()).append(' ');
                    }
                }
            }
            catch (NoSuchElementException e) {
                logger.error((Object)("Error during tokenization of query string. Initial string was >" + str + "< Process so far gave: " + buffer.toString()));
            }
        } else {
            return null;
        }
        logger.debug((Object)("Query is:" + buffer.toString()));
        return buffer.toString();
    }

    private String removeControlChars(String token) {
        StringBuffer retval = new StringBuffer();
        if (token != null) {
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if (c == '+' || c == '-' || c == '&' || c == '|' || c == '!' || c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '^' || c == '\"' || c == '~' || c == '*' || c == '?' || c == ':' || c == '.' || c == '\\') {
                    retval.append('\\').append(c);
                    continue;
                }
                retval.append(c);
            }
        }
        return retval.toString();
    }

    private TopDocs getTopDocsByName(String partialName, Searcher searcher, Integer maxHits) throws IOException, ParseException {
        TopFieldDocs docs;
        TreeSet<ScoreDoc> scoreDocs;
        block6: {
            scoreDocs = new TreeSet<ScoreDoc>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    ScoreDoc s1 = (ScoreDoc)o1;
                    ScoreDoc s2 = (ScoreDoc)o2;
                    if (s1.doc == s2.doc) {
                        return 0;
                    }
                    return s1.doc > s2.doc ? 1 : -1;
                }
            });
            docs = null;
            Query query = null;
            try {
                Sort sort = new Sort(new SortField("term_name_len", 4));
                QueryParser qp = new QueryParser("term_name", (Analyzer)new StandardAnalyzer());
                String queryStr = this.restrictiveTokenizeQuery(partialName);
                query = qp.parse(queryStr);
                docs = maxHits != null ? searcher.search(query, null, maxHits.intValue(), sort) : searcher.search(query, null, 1, sort);
                if (docs.scoreDocs.length > 0) {
                    scoreDocs.addAll(Arrays.asList(docs.scoreDocs));
                }
                BooleanQuery.setMaxClauseCount((int)5120);
                qp = new QueryParser("term_name", (Analyzer)new StandardAnalyzer());
                qp.setLowercaseWildcardTerms(true);
                queryStr = this.permissiveTokenizeQuery(partialName);
                query = qp.parse(queryStr);
                try {
                    docs = maxHits != null ? searcher.search(query, null, maxHits.intValue(), sort) : searcher.search(query, null, 5120, sort);
                    if (docs.scoreDocs.length > 0) {
                        scoreDocs.addAll(Arrays.asList(docs.scoreDocs));
                    }
                }
                catch (BooleanQuery.TooManyClauses tmc) {
                    logger.debug((Object)"Query with too many clauses");
                }
            }
            catch (BooleanQuery.TooManyClauses tmc) {
                if (query == null) break block6;
                logger.warn((Object)("Query with too many fields: " + query.toString()));
            }
        }
        docs.scoreDocs = scoreDocs.toArray(new ScoreDoc[scoreDocs.size()]);
        docs.totalHits = scoreDocs.size();
        return docs;
    }

    private TopDocs getTopDocsByRawQuery(String queryString, Searcher searcher, Integer maxHits) throws IOException, ParseException {
        TopFieldDocs docs;
        block2: {
            docs = null;
            Query query = null;
            try {
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                QueryParser qp = new QueryParser("term_name", (Analyzer)new StandardAnalyzer());
                qp.setLowercaseWildcardTerms(true);
                query = qp.parse(queryString);
                Sort sort = new Sort(new SortField("term_name_len", 4));
                docs = maxHits != null ? searcher.search(query, null, maxHits.intValue(), sort) : searcher.search(query, null, 1, sort);
            }
            catch (BooleanQuery.TooManyClauses tmc) {
                if (query == null) break block2;
                logger.warn((Object)("Query with too many fields: " + query.toString()));
            }
        }
        return docs;
    }

    private String getPreferredValueForAccession(Collection values) {
        String retval = null;
        Iterator i = values.iterator();
        while (i.hasNext()) {
            String termName = (String)i.next();
            String isSyn = termName.substring(termName.indexOf(INTERNAL_SEPARATOR) + INTERNAL_SEPARATOR.length() + 1);
            if (isSyn.equals(Boolean.FALSE.toString())) {
                retval = termName.substring(0, termName.indexOf(INTERNAL_SEPARATOR));
                break;
            }
            if (retval != null) continue;
            retval = termName.substring(0, termName.indexOf(INTERNAL_SEPARATOR));
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

