/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.persistence.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import uk.ac.ebi.ook.model.interfaces.Term;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.AbstractQueryHandler;

public class TermQueryHandler
extends AbstractQueryHandler {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$persistence$query$TermQueryHandler == null ? (class$uk$ac$ebi$ook$persistence$query$TermQueryHandler = TermQueryHandler.class$("uk.ac.ebi.ook.persistence.query.TermQueryHandler")) : class$uk$ac$ebi$ook$persistence$query$TermQueryHandler));
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$query$TermQueryHandler;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$TermBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$TermPathBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$AnnotationBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$DbXrefBean;

    public TermQueryHandler() {
    }

    public TermQueryHandler(String dbAlias) {
        super(dbAlias);
    }

    private Term internalGetTermById(String termId, String ontologyName) throws PersistenceException {
        Criteria idCr = new Criteria();
        idCr.addEqualTo("identifier", (Object)termId);
        Criteria altIdCr = new Criteria();
        altIdCr.addEqualTo("synonyms.synonym", (Object)termId);
        idCr.addOrCriteria(altIdCr);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
        if (ontologyName != null) {
            criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
        }
        criteria.addAndCriteria(idCr);
        QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$TermBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermBean")) : class$uk$ac$ebi$ook$model$ojb$TermBean, criteria, true);
        Term retval = null;
        retval = (Term)this.strictObjectQuery((Query)query);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Term getTermById(String termId, String ontologyName) {
        Term retval;
        block8: {
            logger.debug((Object)("Retrieving term for id '" + termId + "' in ontology '" + ontologyName + "'."));
            retval = null;
            this.initializeBroker();
            retval = this.internalGetTermById(termId, ontologyName);
            Object var6_4 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block8;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermsById failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var6_5 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Term getTermById(String termId) {
        Term retval;
        block9: {
            logger.debug((Object)("Retrieving term for id '" + termId + "'."));
            retval = null;
            this.initializeBroker();
            String ontologyName = null;
            int colon = termId.indexOf(58);
            if (colon > 0) {
                ontologyName = termId.substring(0, colon);
            }
            retval = this.internalGetTermById(termId, ontologyName);
            Object var6_6 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block9;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermsById failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var6_7 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermsById failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    public Map getTermsByName(String termName) {
        return this.getTermsByName(termName, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getTermsByName(String termName, String ontologyName, boolean includeSynonyms, boolean reverseKeyOrder) {
        HashMap<Object, Object> retval;
        block14: {
            if (termName == null) {
                throw new IllegalArgumentException("Term name cannot be null!");
            }
            logger.debug((Object)("Retrieving all terms for name '" + termName + "'."));
            Criteria nameCr = new Criteria();
            nameCr.addEqualTo("name", (Object)termName.trim());
            if (includeSynonyms) {
                Criteria synCr = new Criteria();
                synCr.addEqualTo("synonyms.synonym", (Object)termName.trim());
                nameCr.addOrCriteria(synCr);
            }
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            if (ontologyName != null) {
                criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
            }
            criteria.addAndCriteria(nameCr);
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermBean")) : class$uk$ac$ebi$ook$model$ojb$TermBean), (Criteria)criteria, (boolean)true);
            if (!reverseKeyOrder) {
                query.setAttributes(new String[]{"identifier", "name"});
            } else {
                query.setAttributes(new String[]{"name", "identifier"});
            }
            retval = new HashMap<Object, Object>();
            this.initializeBroker();
            Iterator it = this.reportQuery((Query)query);
            while (it.hasNext()) {
                Object[] aTerm = (Object[])it.next();
                retval.put(aTerm[0], aTerm[1]);
            }
            Object var12_12 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermsByName failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block14;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermsByName failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var12_13 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermsByName failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermsByName failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermChildren(String termId, String ontologyName, Integer distance, int[] relationTypes) {
        ArrayList<Object[]> retval;
        block14: {
            logger.debug((Object)("Retrieving term for id '" + termId + "'."));
            retval = new ArrayList<Object[]>();
            this.initializeBroker();
            Term tmpTerm = this.internalGetTermById(termId, ontologyName);
            if (tmpTerm != null) {
                Criteria criteria = new Criteria();
                criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
                if (ontologyName != null) {
                    criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
                }
                Criteria parentTerm = new Criteria();
                parentTerm.addEqualTo("objectTerm.identifier", (Object)tmpTerm.getIdentifier());
                criteria.addAndCriteria(parentTerm);
                if (distance != null && distance > 0) {
                    Criteria distanceCrit = new Criteria();
                    distanceCrit.addLessOrEqualThan((Object)"distance", (Object)distance);
                    criteria.addAndCriteria(distanceCrit);
                }
                if (relationTypes != null && relationTypes.length > 0) {
                    Criteria reltypeCriteria = new Criteria();
                    ArrayList<Integer> values = new ArrayList<Integer>(relationTypes.length);
                    for (int i = 0; i < relationTypes.length; ++i) {
                        values.add(new Integer(relationTypes[i]));
                    }
                    reltypeCriteria.addColumnIn("relationship_type_id", values);
                    criteria.addAndCriteria(reltypeCriteria);
                }
                ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermPathBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermPathBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermPathBean")) : class$uk$ac$ebi$ook$model$ojb$TermPathBean), (Criteria)criteria);
                query.setAttributes(new String[]{"subjectTerm.identifier", "subjectTerm.name", "predicateTerm.name", "distance"});
                query.addOrderByAscending("subjectTerm.identifier");
                query.addOrderByAscending("distance");
                Iterator it = this.reportQuery((Query)query);
                while (it.hasNext()) {
                    retval.add((Object[])it.next());
                }
            }
            Object var13_13 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermChildren failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block14;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermChildren failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var13_14 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermChildren failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermChildren failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    public Term getUpdatedTerm(Term deprecatedTerm) {
        return null;
    }

    public Map getChildrenFromRootTerm(String rootTermId, String ontologyName, Collection childrenTermIds) {
        if (childrenTermIds == null) {
            return new HashMap();
        }
        Collection allChildrenTerms = this.getTermChildren(rootTermId, ontologyName, null, null);
        HashMap<Object, Object> allChildren = new HashMap<Object, Object>();
        Iterator i = allChildrenTerms.iterator();
        while (i.hasNext()) {
            Object[] data = (Object[])i.next();
            allChildren.put(data[0], data[1]);
        }
        HashMap retval = new HashMap();
        Iterator i2 = childrenTermIds.iterator();
        while (i2.hasNext()) {
            String id = (String)i2.next();
            if (!allChildren.containsKey(id)) continue;
            retval.put(id, allChildren.get(id));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getRootTerms(String ontologyName) {
        ArrayList retval;
        block8: {
            logger.debug((Object)("Retrieving root terms for  '" + ontologyName + "'."));
            retval = new ArrayList();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
            criteria.addEqualTo("rootTerm", (Object)Boolean.TRUE);
            QueryByCriteria query = QueryFactory.newQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermBean")) : class$uk$ac$ebi$ook$model$ojb$TermBean), (Criteria)criteria, (boolean)true);
            query.addOrderByAscending("identifier");
            retval.addAll(this.collectionQuery((Query)query));
            Object var6_6 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getRootTerms failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block8;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermChildren failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var6_7 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getRootTerms failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getRootTerms failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermRelationships(String termId, String ontologyName) {
        ArrayList<Object[]> retval;
        block10: {
            retval = new ArrayList<Object[]>();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            if (ontologyName != null) {
                criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
            }
            Criteria parentTerm = new Criteria();
            parentTerm.addEqualTo("objectTerm.identifier", (Object)termId);
            criteria.addAndCriteria(parentTerm);
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermRelationshipBean")) : class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean), (Criteria)criteria);
            query.setAttributes(new String[]{"subjectTerm.identifier", "subjectTerm.name", "subjectTerm.leaf", "predicateTerm.name"});
            query.addOrderByAscending("subjectTerm.identifier");
            Iterator it = this.reportQuery((Query)query);
            while (it.hasNext()) {
                Object[] objArr = (Object[])it.next();
                retval.add(objArr);
            }
            Object var10_10 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block10;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermRelationships failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var10_11 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getParentTermRelationships(String termId, String ontologyName) {
        ArrayList<Object[]> retval;
        block10: {
            retval = new ArrayList<Object[]>();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            if (ontologyName != null) {
                criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
            }
            Criteria parentTerm = new Criteria();
            parentTerm.addEqualTo("subjectTerm.identifier", (Object)termId);
            criteria.addAndCriteria(parentTerm);
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermRelationshipBean")) : class$uk$ac$ebi$ook$model$ojb$TermRelationshipBean), (Criteria)criteria);
            query.setAttributes(new String[]{"objectTerm.identifier", "objectTerm.name", "objectTerm.leaf", "predicateTerm.name"});
            query.addOrderByAscending("objectTerm.identifier");
            Iterator it = this.reportQuery((Query)query);
            while (it.hasNext()) {
                Object[] objArr = (Object[])it.next();
                retval.add(objArr);
            }
            Object var10_10 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getParentTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block10;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getParentTermRelationships failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var10_11 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getParentTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getParentTermRelationships failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermsByAnnotations(String ontologyName, String annotationType, String strValue, Double fromDblValue, Double toDblValue) {
        ArrayList<Object[]> retval;
        block15: {
            if (strValue == null && toDblValue == null && fromDblValue == null) {
                throw new IllegalArgumentException("No arguments provided to getTermsByAnnotations");
            }
            if (toDblValue != null && fromDblValue == null || toDblValue == null && fromDblValue != null) {
                throw new IllegalArgumentException("To use a numeric search range, you must provide both lower and upper cut-off values");
            }
            retval = new ArrayList<Object[]>();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentTerm.parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            if (ontologyName != null && ontologyName.trim().length() > 0) {
                criteria.addEqualTo("parentTerm.parentOntology.shortOntologyName", (Object)ontologyName.trim());
            }
            if (annotationType != null && annotationType.trim().length() > 0) {
                Criteria annotType = new Criteria();
                annotType.addEqualTo("annotationType", (Object)annotationType.trim());
                criteria.addAndCriteria(annotType);
            }
            if (strValue != null && strValue.trim().length() > 0) {
                Criteria stringValue = new Criteria();
                stringValue.addLike((Object)"annotationStringValue", (Object)strValue.trim());
                criteria.addAndCriteria(stringValue);
            }
            if (fromDblValue != null && toDblValue != null) {
                Criteria rangeCriteria = new Criteria();
                rangeCriteria.addGreaterOrEqualThan((Object)"annotationNumberValue", (Object)fromDblValue);
                rangeCriteria.addLessOrEqualThan((Object)"annotationNumberValue", (Object)toDblValue);
                criteria.addAndCriteria(rangeCriteria);
            }
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$AnnotationBean == null ? (class$uk$ac$ebi$ook$model$ojb$AnnotationBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.AnnotationBean")) : class$uk$ac$ebi$ook$model$ojb$AnnotationBean), (Criteria)criteria);
            query.setAttributes(new String[]{"parentTerm.identifier", "parentTerm.name", "annotationType", "annotationStringValue", "annotationNumberValue"});
            query.addOrderByAscending("annotationNumberValue");
            query.addOrderByAscending("parentTerm.identifier");
            Iterator it = this.reportQuery((Query)query);
            while (it.hasNext()) {
                Object[] objArr = (Object[])it.next();
                retval.add(objArr);
            }
            Object var12_12 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermsByAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block15;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermsByAnnotations failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var12_13 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermsByAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermsByAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermAnnotations(String termId, String ontologyName) {
        Collection retval;
        block9: {
            block8: {
                logger.debug((Object)("Retrieving term for id '" + termId + "'."));
                retval = new ArrayList();
                this.initializeBroker();
                Term tmpTerm = this.internalGetTermById(termId, ontologyName);
                if (tmpTerm == null) break block8;
                Criteria criteria = new Criteria();
                criteria.addEqualTo("parentTermId", (Object)new Long(tmpTerm.getTermId()));
                ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$AnnotationBean == null ? (class$uk$ac$ebi$ook$model$ojb$AnnotationBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.AnnotationBean")) : class$uk$ac$ebi$ook$model$ojb$AnnotationBean), (Criteria)criteria);
                query.addOrderByAscending("annotationType");
                retval = this.collectionQuery((Query)query);
            }
            Object var8_8 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block9;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermAnnotations failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var8_9 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermAnnotations(long termId) {
        Collection retval;
        block8: {
            logger.debug((Object)("Retrieving term for id '" + termId + "'."));
            retval = new ArrayList();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentTermId", (Object)new Long(termId));
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$AnnotationBean == null ? (class$uk$ac$ebi$ook$model$ojb$AnnotationBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.AnnotationBean")) : class$uk$ac$ebi$ook$model$ojb$AnnotationBean), (Criteria)criteria);
            query.addOrderByAscending("annotationType");
            retval = this.collectionQuery((Query)query);
            Object var7_6 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block8;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermAnnotations failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var7_7 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermAnnotations failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermXrefs(String termId, String ontologyName) {
        Collection retval;
        block9: {
            block8: {
                logger.debug((Object)("Retrieving term for id '" + termId + "'."));
                retval = new ArrayList();
                this.initializeBroker();
                Term tmpTerm = this.internalGetTermById(termId, ontologyName);
                if (tmpTerm == null) break block8;
                Criteria criteria = new Criteria();
                criteria.addEqualTo("parentTermId", (Object)new Long(tmpTerm.getTermId()));
                ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$DbXrefBean == null ? (class$uk$ac$ebi$ook$model$ojb$DbXrefBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.DbXrefBean")) : class$uk$ac$ebi$ook$model$ojb$DbXrefBean), (Criteria)criteria);
                query.addOrderByAscending("xrefType");
                retval = this.collectionQuery((Query)query);
            }
            Object var8_8 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block9;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermXrefs failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var8_9 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getTermXrefs(long termId) {
        Collection retval;
        block8: {
            logger.debug((Object)("Retrieving term for id '" + termId + "'."));
            retval = new ArrayList();
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentTermId", (Object)new Long(termId));
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$DbXrefBean == null ? (class$uk$ac$ebi$ook$model$ojb$DbXrefBean = TermQueryHandler.class$("uk.ac.ebi.ook.model.ojb.DbXrefBean")) : class$uk$ac$ebi$ook$model$ojb$DbXrefBean), (Criteria)criteria);
            query.addOrderByAscending("xrefType");
            retval = this.collectionQuery((Query)query);
            Object var7_6 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block8;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermXrefs failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var7_7 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermXrefs failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

