/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.ajax;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajaxtags.servlets.BaseAjaxServlet;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.web.ajax.AjaxHandler;

public class AjaxServlet
extends BaseAjaxServlet {
    private static Properties props = null;
    private static final String CONFIG_INIT_PARAM = "config";
    private static final String QUERY_TYPE_PARAM = "q";
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$ajax$AjaxServlet == null ? (class$uk$ac$ebi$ook$web$ajax$AjaxServlet = AjaxServlet.class$("uk.ac.ebi.ook.web.ajax.AjaxServlet")) : class$uk$ac$ebi$ook$web$ajax$AjaxServlet));
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$ajax$AjaxServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String configFile = config.getInitParameter(CONFIG_INIT_PARAM);
        if (configFile != null) {
            try {
                URL url = this.getServletContext().getResource(configFile);
                if (url == null) {
                    url = ((Object)((Object)this)).getClass().getResource(configFile);
                }
                if (url == null) {
                    this.logger.error((Object)("No configuration found for the AJAX servlet: " + configFile));
                    throw new ServletException("No configuration found for the AJAX servlet: " + configFile);
                }
                props = new Properties();
                props.load(url.openStream());
                this.logger.debug((Object)"AJAX servlet configured");
            }
            catch (IOException ioe) {
                props = null;
                this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                throw new ServletException("Error during servlet configuration: " + ioe.getMessage(), (Throwable)ioe);
            }
        } else {
            throw new ServletException("No configuration file specified for the AJAX servlet");
        }
    }

    public String getXmlContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String requestType;
        if (this.logger.isDebugEnabled()) {
            this.dumpRequest(request);
        }
        if ((requestType = request.getParameter(QUERY_TYPE_PARAM)) != null) {
            if (props != null) {
                String handlerClassName = props.getProperty(requestType);
                if (handlerClassName != null) {
                    try {
                        Class<?> handlerClass = Class.forName(handlerClassName);
                        this.logger.debug((Object)("Found class: " + handlerClass));
                        AjaxHandler processor = (AjaxHandler)handlerClass.newInstance();
                        this.logger.debug((Object)"Got instance of processor.");
                        return processor.getXmlContent(request, response);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.logger.error((Object)cnfe.getMessage(), (Throwable)cnfe);
                        throw new ServletException("No handler class available to process request: " + cnfe.getMessage(), (Throwable)cnfe);
                    }
                    catch (ClassCastException cce) {
                        this.logger.error((Object)cce.getMessage(), (Throwable)cce);
                        throw new ServletException("Class " + handlerClassName + " does not implement the required AjaxHandler interface.");
                    }
                }
                this.logger.error((Object)("No handler class defined for request type: " + requestType));
                throw new ServletException("No handler class defined for request type: " + requestType);
            }
            this.logger.error((Object)"AJAX Servlet improperly configured!");
            throw new ServletException("AJAX Servlet improperly configured!");
        }
        this.logger.error((Object)"No request type defiled for AJAX processor");
        throw new ServletException("No request type defiled for AJAX processor");
    }

    private void dumpRequest(HttpServletRequest request) {
        this.logger.debug((Object)"Dumping requests parameters!");
        Map params = request.getParameterMap();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String paramName = (String)i.next();
            String[] paramValue = (String[])params.get(paramName);
            if (paramValue != null) {
                for (int j = 0; j < paramValue.length; ++j) {
                    String s = paramValue[j];
                    this.logger.debug((Object)(paramName + " -> " + s));
                }
                continue;
            }
            this.logger.debug((Object)(paramName + " -> NO_VALUE!"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

