/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.ajax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import uk.ac.ebi.ook.Constants;
import uk.ac.ebi.ook.persistence.query.ServiceQueryHandler;
import uk.ac.ebi.ook.web.ajax.AjaxHandler;

public class TreeBuilderAjaxServlet
implements AjaxHandler {
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$ajax$TreeBuilderAjaxServlet == null ? (class$uk$ac$ebi$ook$web$ajax$TreeBuilderAjaxServlet = TreeBuilderAjaxServlet.class$("uk.ac.ebi.ook.web.ajax.TreeBuilderAjaxServlet")) : class$uk$ac$ebi$ook$web$ajax$TreeBuilderAjaxServlet));
    public static final String TERM_ID_PARAMETER = "id";
    public static final String ONTOLOGY_NAME_PARAMETER = "ontologyname";
    public static final String ROOT_TERM_ID = "root_term";
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String NODE_TAG = "node";
    public static final String TREE_TAG = "tree";
    public static final String ACCESSION_ATTRIBUTE = "accession";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String NAMESPACE = null;
    public static final String RELTYPE_ID_ATTRIBUTE = "relation_id";
    public static final String RELTYPE_NAME_ATTRIBUTE = "relation_name";
    public static final String HAS_CHILDREN_ATTRIBUTE = "has_children";
    public static final String HAS_CHILDREN = "1";
    public static final String NO_CHILDREN = "0";
    public static final String IS_LEAF_TRUE = "1";
    public static final String DUPLICATE_ID_TAG = "_duplicate_";
    private static XmlPullParserFactory iFactory = null;
    private XmlSerializer iSerializer = null;
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$ajax$TreeBuilderAjaxServlet;

    public String getXmlContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String xml = "";
        try {
            String termId = request.getParameter(TERM_ID_PARAMETER);
            String ontName = request.getParameter(ONTOLOGY_NAME_PARAMETER);
            if (termId == null) {
                termId = ROOT_TERM_ID;
            }
            if (termId != null && ontName != null) {
                ServiceQueryHandler query = new ServiceQueryHandler();
                if (termId.equals(ROOT_TERM_ID)) {
                    this.logger.debug((Object)("querying for root terms for " + ontName));
                    HashMap terms = query.getRootTerms(ontName);
                    xml = this.serializeRoots(terms, termId);
                } else {
                    int ndx = termId.indexOf(DUPLICATE_ID_TAG);
                    String tmpId = ndx > 0 ? termId.substring(ndx + DUPLICATE_ID_TAG.length()) : termId;
                    this.logger.debug((Object)("querying for children terms for " + tmpId));
                    List terms = query.getRawTermRelations(tmpId, ontName);
                    xml = this.serializeRelations(terms, termId);
                }
            } else {
                this.logger.debug((Object)"Invaild parameters submitted, returning empty tree");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return xml;
    }

    private void initXMLMarshaller() {
        if (iFactory == null) {
            try {
                iFactory = XmlPullParserFactory.newInstance(null, null);
            }
            catch (XmlPullParserException xppe) {
                this.logger.warn((Object)xppe.getMessage(), (Throwable)xppe);
            }
        }
        try {
            this.iSerializer = iFactory.newSerializer();
        }
        catch (XmlPullParserException xppe) {
            this.logger.warn((Object)xppe.getMessage(), (Throwable)xppe);
        }
    }

    private String serializeRoots(Map terms, String termId) throws IOException {
        this.initXMLMarshaller();
        StringWriter xml = new StringWriter();
        this.iSerializer.setOutput((Writer)xml);
        this.iSerializer.startDocument(UTF8_ENCODING, new Boolean(true));
        this.iSerializer.text("\n");
        this.iSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
        this.iSerializer.startTag(NAMESPACE, TREE_TAG);
        this.iSerializer.attribute(NAMESPACE, TERM_ID_PARAMETER, termId);
        if (!terms.isEmpty()) {
            Iterator iterator = terms.keySet().iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                String name = (String)terms.get(id);
                this.iSerializer.startTag(NAMESPACE, NODE_TAG);
                this.iSerializer.attribute(NAMESPACE, ACCESSION_ATTRIBUTE, id);
                this.iSerializer.attribute(NAMESPACE, NAME_ATTRIBUTE, name);
                this.iSerializer.attribute(NAMESPACE, HAS_CHILDREN_ATTRIBUTE, "1");
                this.iSerializer.attribute(NAMESPACE, RELTYPE_ID_ATTRIBUTE, "4");
                this.iSerializer.attribute(NAMESPACE, RELTYPE_NAME_ATTRIBUTE, ROOT_TERM_ID);
                this.iSerializer.endTag(NAMESPACE, NODE_TAG);
            }
        } else {
            this.iSerializer.startTag(NAMESPACE, NODE_TAG);
            this.iSerializer.attribute(NAMESPACE, ACCESSION_ATTRIBUTE, NO_CHILDREN);
            this.iSerializer.attribute(NAMESPACE, NAME_ATTRIBUTE, "No Root Term defined!");
            this.iSerializer.attribute(NAMESPACE, HAS_CHILDREN_ATTRIBUTE, NO_CHILDREN);
            this.iSerializer.attribute(NAMESPACE, RELTYPE_ID_ATTRIBUTE, "4");
            this.iSerializer.attribute(NAMESPACE, RELTYPE_NAME_ATTRIBUTE, ROOT_TERM_ID);
            this.iSerializer.endTag(NAMESPACE, NODE_TAG);
        }
        this.iSerializer.endTag(NAMESPACE, TREE_TAG);
        this.iSerializer.endDocument();
        return xml.toString();
    }

    private String serializeRelations(Collection terms, String termId) throws IOException {
        this.initXMLMarshaller();
        StringWriter xml = new StringWriter();
        this.iSerializer.setOutput((Writer)xml);
        this.iSerializer.startDocument(UTF8_ENCODING, new Boolean(true));
        this.iSerializer.text("\n");
        this.iSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"\t");
        this.iSerializer.startTag(NAMESPACE, TREE_TAG);
        this.iSerializer.attribute(NAMESPACE, TERM_ID_PARAMETER, termId);
        Iterator iterator = terms.iterator();
        while (iterator.hasNext()) {
            Object[] values = (Object[])iterator.next();
            String id = (String)values[0];
            String name = (String)values[1];
            String is_leaf = (String)values[2];
            String reltype = (String)values[3];
            if (Constants.RELATIONSHIPS_TO_IGNORE.contains(reltype)) continue;
            this.iSerializer.startTag(NAMESPACE, NODE_TAG);
            this.iSerializer.attribute(NAMESPACE, ACCESSION_ATTRIBUTE, id);
            this.iSerializer.attribute(NAMESPACE, NAME_ATTRIBUTE, name);
            if (is_leaf.equals("1")) {
                this.iSerializer.attribute(NAMESPACE, HAS_CHILDREN_ATTRIBUTE, NO_CHILDREN);
            } else {
                this.iSerializer.attribute(NAMESPACE, HAS_CHILDREN_ATTRIBUTE, "1");
            }
            this.iSerializer.attribute(NAMESPACE, RELTYPE_ID_ATTRIBUTE, this.getRelationType(reltype));
            this.iSerializer.attribute(NAMESPACE, RELTYPE_NAME_ATTRIBUTE, reltype);
            this.iSerializer.endTag(NAMESPACE, NODE_TAG);
        }
        this.iSerializer.endTag(NAMESPACE, TREE_TAG);
        this.iSerializer.endDocument();
        return xml.toString();
    }

    private String getRelationType(String typeString) {
        if ("is_a".equals(typeString)) {
            return "1";
        }
        if ("part_of".equals(typeString)) {
            return "2";
        }
        if ("develops_from".equals(typeString)) {
            return "3";
        }
        return "4";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

