/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.services.client;

import javax.xml.rpc.ServiceException;
import uk.ac.ebi.ook.web.services.Query;
import uk.ac.ebi.ook.web.services.client.ConfigurableQueryServiceLocator;

public class QueryServiceFactory {
    private static QueryServiceFactory instance = null;
    private static String ONTOLOGY_QUERY_SERVICE_NAME = null;
    private static String ONTOLOGY_QUERY_SERVICE_URL = null;

    private QueryServiceFactory(String url, String serviceName) {
        ONTOLOGY_QUERY_SERVICE_NAME = serviceName;
        ONTOLOGY_QUERY_SERVICE_URL = url;
    }

    public static Query getQueryService(String url, String serviceName) throws ServiceException {
        if (instance == null) {
            instance = new QueryServiceFactory(url, serviceName);
        }
        return instance.getService();
    }

    private Query getService() throws ServiceException {
        if (ONTOLOGY_QUERY_SERVICE_NAME == null || ONTOLOGY_QUERY_SERVICE_URL == null) {
            throw new RuntimeException("Service URL and name are not configured!");
        }
        ConfigurableQueryServiceLocator sl = new ConfigurableQueryServiceLocator();
        sl.setWSDDServiceName(ONTOLOGY_QUERY_SERVICE_NAME);
        sl.setOntologyQueryEndpointAddress(ONTOLOGY_QUERY_SERVICE_URL);
        return sl.getOntologyQuery();
    }
}

