/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.struts.business;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.proteomics.common.cache.Cacheable;
import uk.ac.ebi.proteomics.common.cache.CachedEntry;
import uk.ac.ebi.proteomics.common.cache.NeedsRefreshException;
import uk.ac.ebi.proteomics.common.cache.TimedLRUMapCache;

public class MonthlyLoaderStatsReportSingleton {
    private static MonthlyLoaderStatsReportSingleton instance = new MonthlyLoaderStatsReportSingleton();
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$struts$business$MonthlyLoaderStatsReportSingleton == null ? (class$uk$ac$ebi$ook$web$struts$business$MonthlyLoaderStatsReportSingleton = MonthlyLoaderStatsReportSingleton.class$("uk.ac.ebi.ook.web.struts.business.MonthlyLoaderStatsReportSingleton")) : class$uk$ac$ebi$ook$web$struts$business$MonthlyLoaderStatsReportSingleton));
    private Collection monthlyStats = null;
    private static TimedLRUMapCache cache = TimedLRUMapCache.getInstance();
    private static String LOADER_STATS_KEY = "loader_stats";
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$struts$business$MonthlyLoaderStatsReportSingleton;

    private MonthlyLoaderStatsReportSingleton() {
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        try {
            this.monthlyStats = oqh.getMonthyStats(-1, -1);
        }
        catch (PersistenceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.monthlyStats = new ArrayList();
        }
    }

    public static synchronized MonthlyLoaderStatsReportSingleton getInstance() {
        return instance;
    }

    public static synchronized void clearCache() {
        instance = new MonthlyLoaderStatsReportSingleton();
    }

    public Collection getMonthlyLoaderStats() {
        return this.monthlyStats;
    }

    public Collection getMonthlyLoaderStats(int month, int year) {
        Collection retval = new ArrayList();
        String key = LOADER_STATS_KEY + month + year;
        try {
            Cacheable tmpEntry = cache.getFromCache((Object)key);
            retval = (Collection)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException nre) {
            OntologyQueryHandler oqh = new OntologyQueryHandler();
            try {
                retval = oqh.getMonthyStats(month, year);
            }
            catch (PersistenceException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                retval = new ArrayList();
            }
            cache.putInCache((Object)key, (Object)new CachedEntry(retval));
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

