/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.AdapterWidgetI;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterUIException;
import org.geneontology.dataadapter.GraphicalUI;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.dataadapter.UIConfiguration;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.dataadapter.OBOSerializationEngine;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterBuilder;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.LinkFilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.util.EditableString;

public class AdvancedOBOUI
extends JPanel
implements GraphicalUI {
    private static final long serialVersionUID = 4097591578255403651L;
    public static final int MAX_HISTORY_LENGTH = 5;
    protected JButton browseButton = new JButton("Browse...");
    protected IOOperation op;
    protected String defaultBrowsePath = System.getProperty("user.home");
    protected ListEditor pathList;
    protected ListEditor namespaceList;
    protected OBOFileAdapter.OBOAdapterConfiguration currentProfile;
    protected JLabel pathLabel;
    protected JLabel pathOrURLLabel = new JLabel("Path or URL");
    protected JLabel urlLabel = new JLabel("URL for import");
    protected JCheckBox importExternalRefsBox = new JCheckBox("Import external references");
    protected JCheckBox allowDanglingBox = new JCheckBox("Allow dangling references");
    protected JTextField pathField = new JTextField(20);
    protected JTextField urlField = new JTextField(20);
    protected JLabel nsLabel = new JLabel("Namespace");
    protected JTextField nsField = new JTextField(10);
    protected JPanel nsPanel = new JPanel();
    protected static Font boldFont = new Font("Arial", 1, 12);
    protected JButton delButton = new JButton("Delete");
    protected boolean notListPick = false;
    protected int currentSelectedIndex = -1;
    protected Vector paths = new Vector();
    protected HashMap nsmap = new HashMap();
    protected OBOSession currentHistory;
    protected JPanel pathBox;
    protected JButton addSaveButton = new JButton("Add save record");
    protected JButton delSaveButton = new JButton("Delete save record");
    protected JPanel saveButtonPanel = new JPanel();
    protected boolean embed = false;
    protected JPanel serializerPanel = new JPanel();
    protected JLabel serializerLabel = new JLabel("Output type");
    protected JComboBox serializerBox = new JComboBox();
    protected GraphicalUI simpleUI;

    public void setUIConfiguration(UIConfiguration uiconfig) {
    }

    public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
        this.collectParams();
        if (!storeonly && this.op.equals(IOOperation.WRITE)) {
            LinkedList<String> overwrite = new LinkedList<String>();
            Iterator it = this.currentProfile.getSaveRecords().iterator();
            while (it.hasNext()) {
                OBOSerializationEngine.FilteredPath path;
                Object o = it.next();
                if (o == null) {
                    System.err.println("!!!NULL saved record!!!!");
                }
                if ((path = (OBOSerializationEngine.FilteredPath)o).getPath().length() == 0) {
                    throw new DataAdapterUIException("Cannot save to empty path.");
                }
                if (!new File(path.getPath()).exists()) continue;
                overwrite.add(path.getPath());
            }
            if (overwrite.size() > 0) {
                StringBuffer out = new StringBuffer();
                out.append("The following files exist:\n");
                it = overwrite.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    out.append("   * " + s + "\n");
                }
                out.append("Overwrite these files?");
                int val = JOptionPane.showConfirmDialog(this, out.toString(), "Overwrite files?", 0);
                if (val != 0) {
                    throw new DataAdapterUIException();
                }
            }
        }
    }

    public UIConfiguration getUIConfiguration() {
        return null;
    }

    public Set getFiles(IOOperation op) {
        return new HashSet();
    }

    public GraphicalUI getAdvancedUI() {
        return null;
    }

    public void setSimpleUI(GraphicalUI simpleUI) {
        this.simpleUI = simpleUI;
    }

    public GraphicalUI getSimpleUI() {
        return this.simpleUI;
    }

    public AdvancedOBOUI() {
        this.serializerBox.addItem("OBO_1_2");
        this.serializerBox.addItem("OBO_1_0");
        this.serializerPanel.setOpaque(false);
        this.serializerPanel.setLayout(new BoxLayout(this.serializerPanel, 0));
        this.serializerPanel.add(Box.createHorizontalGlue());
        this.serializerPanel.add(this.serializerLabel);
        this.serializerPanel.add(Box.createHorizontalStrut(10));
        this.serializerPanel.add(this.serializerBox);
        this.serializerPanel.add(Box.createHorizontalGlue());
        this.serializerBox.setBackground(Preferences.defaultButtonColor());
        this.nsPanel.setLayout(new BoxLayout(this.nsPanel, 0));
        this.nsPanel.add(this.nsLabel);
        this.nsPanel.add(Box.createHorizontalStrut(10));
        this.nsPanel.add(this.nsField);
        this.nsPanel.setOpaque(false);
        this.setOpaque(false);
        this.namespaceList = new ListEditor((GenericEditorComponent)new IOProfileEditor(), false, true, true, true, false);
        this.namespaceList.setBackground(Preferences.defaultBackgroundColor());
        this.pathList = new ListEditor((GenericEditorComponent)new PathEditor(), true, true, true, true, false);
        this.pathList.setBackground(Preferences.defaultBackgroundColor());
        this.addSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOBOUI.this.namespaceList.add();
            }
        });
        this.delSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOBOUI.this.namespaceList.del();
            }
        });
        this.pathLabel = new JLabel("File path");
        this.pathList.setPreferredSize(new Dimension(500, 200));
        this.namespaceList.setPreferredSize(new Dimension(500, 200));
        this.saveButtonPanel.setLayout(new BoxLayout(this.saveButtonPanel, 0));
        this.saveButtonPanel.add(Box.createHorizontalGlue());
        this.saveButtonPanel.add(this.addSaveButton);
        this.saveButtonPanel.add(Box.createHorizontalStrut(10));
        this.saveButtonPanel.add(this.delSaveButton);
        this.saveButtonPanel.add(Box.createHorizontalGlue());
        this.pathBox = new JPanel();
        this.pathBox.setLayout(new BorderLayout());
        this.pathBox.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.allowDanglingBox.setOpaque(false);
        this.allowDanglingBox.setAlignmentX(0.5f);
        this.pathBox.setAlignmentX(0.0f);
        this.pathLabel.setAlignmentX(0.0f);
        this.urlLabel.setAlignmentX(0.0f);
        this.importExternalRefsBox.setAlignmentX(0.0f);
        this.pathField.setAlignmentX(0.0f);
        this.urlField.setAlignmentX(0.0f);
        this.delButton.setAlignmentX(0.0f);
        this.nsLabel.setAlignmentX(0.0f);
        this.nsField.setAlignmentX(0.0f);
        this.nsPanel.setAlignmentX(0.0f);
        this.add(this.pathBox);
        this.setPreferredSize(new Dimension(600, 400));
    }

    protected void storeProfile(OBOFileAdapter.OBOAdapterConfiguration profile) {
        profile.getReadPaths().clear();
        Vector temp = this.pathList.getData();
        for (int i = 0; i < temp.size(); ++i) {
            profile.getReadPaths().add(temp.get(i).toString());
        }
        profile.setAllowDangling(this.allowDanglingBox.isSelected());
        profile.setSerializer((String)this.serializerBox.getSelectedItem());
        profile.setSaveRecords(this.namespaceList.getData());
        profile.setBasicSave(false);
    }

    public void setConfiguration(AdapterConfiguration config) {
        OBOFileAdapter.OBOAdapterConfiguration profile;
        this.currentProfile = profile = (OBOFileAdapter.OBOAdapterConfiguration)config;
        Vector<EditableString> out = new Vector<EditableString>();
        Iterator it = profile.getReadPaths().iterator();
        while (it.hasNext()) {
            out.add(new EditableString((String)it.next()));
        }
        this.pathList.setData(out);
        this.allowDanglingBox.setSelected(profile.getAllowDangling());
        System.err.println("setConfiguration called, allowDanglingBox.setSelected(" + profile.getAllowDangling() + ")");
        this.serializerBox.setSelectedItem(profile.getSerializer());
        Vector v = new Vector();
        v.addAll(profile.getSaveRecords());
        this.namespaceList.setData(v);
        if (v.size() > 0) {
            this.namespaceList.select(0);
        }
    }

    public void cleanup() {
    }

    public AdapterConfiguration createEmptyConfig() {
        return new OBOFileAdapter.OBOAdapterConfiguration();
    }

    public void init(AdapterWidgetI widget, IOOperation op, DataAdapter adapter, Object input) {
        this.op = op;
        this.currentHistory = (OBOSession)input;
        this.pathBox.removeAll();
        if (op.equals(IOOperation.READ)) {
            this.pathBox.add((Component)this.pathList, "Center");
            this.pathBox.add((Component)this.allowDanglingBox, "South");
        } else {
            this.pathBox.add((Component)this.namespaceList, "Center");
            this.pathBox.add((Component)this.serializerPanel, "South");
        }
        this.setConfiguration(this.createEmptyConfig());
        this.validate();
        this.repaint();
    }

    protected void collectParams() {
        this.paths.clear();
        this.namespaceList.commit();
        Vector temp = this.pathList.getData();
        for (int i = 0; i < temp.size(); ++i) {
            this.paths.add(temp.get(i).toString());
        }
        this.storeProfile(this.currentProfile);
    }

    public AdapterConfiguration getConfig(IOOperation op, DataAdapter adapter, Object input) {
        return this.currentProfile;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.pathLabel != null) {
            this.pathLabel.setFont(font);
        }
        if (this.serializerBox != null) {
            this.serializerBox.setFont(font);
        }
        if (this.serializerLabel != null) {
            this.serializerLabel.setFont(font);
        }
        if (this.allowDanglingBox != null) {
            this.allowDanglingBox.setFont(font);
        }
        if (this.addSaveButton != null) {
            this.addSaveButton.setFont(font);
        }
        if (this.delSaveButton != null) {
            this.delSaveButton.setFont(font);
        }
        if (this.pathOrURLLabel != null) {
            this.pathOrURLLabel.setFont(font);
        }
        if (this.delButton != null) {
            this.delButton.setFont(font);
        }
        if (this.browseButton != null) {
            this.browseButton.setFont(font);
        }
        if (this.pathList != null) {
            this.pathList.setFont(font);
        }
        if (this.namespaceList != null) {
            this.namespaceList.setFont(font);
        }
        if (this.urlLabel != null) {
            this.urlLabel.setFont(font);
        }
        if (this.importExternalRefsBox != null) {
            this.importExternalRefsBox.setFont(font);
        }
        if (this.pathField != null) {
            this.pathField.setFont(font);
        }
        if (this.nsLabel != null) {
            this.nsLabel.setFont(font);
        }
        if (this.nsField != null) {
            this.nsField.setFont(font);
        }
        if (this.urlField != null) {
            this.urlField.setFont(font);
        }
    }

    public void setDefaultBrowsePath(String defaultBrowsePath) {
        this.defaultBrowsePath = defaultBrowsePath;
    }

    protected class PathEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = -6933319183519890664L;
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public PathEditor() {
            this.setBackground(Preferences.defaultBackgroundColor());
            FocusListener listener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PathEditor.this.editor.commit();
                }

                public void focusGained(FocusEvent e) {
                }
            };
            AdvancedOBOUI.this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File startFile = new File(((PathEditor)PathEditor.this).AdvancedOBOUI.this.pathField.getText());
                    String startPath = null;
                    if (startFile.exists()) {
                        startPath = startFile.isDirectory() ? startFile.toString() : startFile.getParent();
                    } else if (startFile.getParentFile() != null && startFile.getParentFile().exists()) {
                        startPath = startFile.getParent();
                    }
                    JFileChooser chooser = startPath == null ? new JFileChooser() : new JFileChooser(startPath);
                    if (chooser.showOpenDialog(AdvancedOBOUI.this) == 0) {
                        File file = chooser.getSelectedFile();
                        ((PathEditor)PathEditor.this).AdvancedOBOUI.this.pathField.setText(file.toString());
                        PathEditor.this.editor.commit();
                    }
                }
            });
            AdvancedOBOUI.this.pathField.addFocusListener(listener);
            AdvancedOBOUI.this.pathField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PathEditor.this.editor.commit();
                }
            });
            this.setAlignmentX(0.0f);
            this.add(AdvancedOBOUI.this.pathOrURLLabel);
            AdvancedOBOUI.this.pathOrURLLabel.setAlignmentX(0.0f);
            JPanel temp = new JPanel();
            temp.setOpaque(false);
            temp.setLayout(new BoxLayout(temp, 0));
            temp.setAlignmentX(0.0f);
            temp.add(AdvancedOBOUI.this.pathField);
            temp.add(Box.createHorizontalStrut(10));
            temp.add(AdvancedOBOUI.this.browseButton);
            this.add(temp);
        }

        public Object createNewValue() {
            return new EditableString("<new path>");
        }

        public void load(Object o) {
            EditableString es = (EditableString)o;
            AdvancedOBOUI.this.pathField.setText(es.toString());
        }

        public void setEditable(boolean in) {
        }

        public void store(Object saveme) {
            EditableString es = (EditableString)saveme;
            es.setValue(AdvancedOBOUI.this.pathField.getText());
        }
    }

    protected class IOProfileEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = -6166108451127532061L;
        protected ListEditor editor;
        protected JPanel panel = new JPanel();
        protected FilterBuilder objectFilterEditor = new FilterBuilder();
        protected FilterBuilder linkFilterEditor = new FilterBuilder();
        protected JTextField pathField = new JTextField();
        protected JTextArea remarkField = new JTextArea(3, 20);
        protected JScrollPane remarkScroller = new JScrollPane(this.remarkField, 20, 31);
        protected JCheckBox categoryBox = new JCheckBox("Discard unused categories");
        protected JCheckBox filterBox = new JCheckBox("Filter terms");
        protected JCheckBox filterTypesBox = new JCheckBox("Always save properties");
        protected JCheckBox linkFilterBox = new JCheckBox("Filter links");
        protected JCheckBox allowDanglingBox = new JCheckBox("Allow dangling parents");
        protected JCheckBox prefilterBox = new JCheckBox("Do type prefiltering");
        protected JComboBox prefilterTypeChooser = new JComboBox();
        protected JLabel rootAlgorithmLabel = new JLabel("Root selection algorithm");
        protected JComboBox rootAlgorithmChooser = new JComboBox();
        protected JCheckBox saveImpliedBox = new JCheckBox("Save implied links");
        protected JComboBox impliedTypeBox = new JComboBox();
        protected JCheckBox realizeImpliedBox = new JCheckBox("Realize implied links");
        protected JComboBox idRuleSelector = new JComboBox();

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public IOProfileEditor() {
            this.setLayout(new BorderLayout());
            this.impliedTypeBox.addItem("Save for presentation");
            this.impliedTypeBox.addItem("Save all links");
            this.idRuleSelector.addItem("Don't write id rules");
            this.idRuleSelector.addItem("Write current id rules");
            this.idRuleSelector.addItem("Write originally loaded id rules");
            this.rootAlgorithmChooser.addItem("GREEDY");
            this.rootAlgorithmChooser.addItem("STRICT");
            AdvancedOBOUI.this.currentHistory = Controller.getController().getSession();
            Iterator it = AdvancedOBOUI.this.currentHistory.getRelationshipTypes().iterator();
            while (it.hasNext()) {
                OBOProperty property = (OBOProperty)it.next();
                this.prefilterTypeChooser.addItem(property);
            }
            this.idRuleSelector.setBackground(Preferences.defaultButtonColor());
            this.objectFilterEditor.setButtonColor(Preferences.defaultButtonColor());
            this.linkFilterEditor.setButtonColor(Preferences.defaultButtonColor());
            this.objectFilterEditor.setFilterFactory(new ObjectFilterFactory());
            this.linkFilterEditor.setFilterFactory(new LinkFilterFactory());
            this.objectFilterEditor.setPreferredSize(null);
            this.linkFilterEditor.setPreferredSize(null);
            this.objectFilterEditor.setShowCompoundFilter(true);
            this.linkFilterEditor.setShowCompoundFilter(true);
            this.objectFilterEditor.setOpaque(false);
            this.linkFilterEditor.setOpaque(false);
            this.filterBox.setOpaque(false);
            this.categoryBox.setOpaque(false);
            this.filterTypesBox.setOpaque(false);
            this.linkFilterBox.setOpaque(false);
            this.prefilterBox.setOpaque(false);
            this.allowDanglingBox.setOpaque(false);
            this.saveImpliedBox.setOpaque(false);
            this.realizeImpliedBox.setOpaque(false);
            JButton newButton = new JButton(Preferences.loadLibraryIcon("file.gif"));
            JButton loadButton = new JButton(Preferences.loadLibraryIcon("folder.gif"));
            JButton saveButton = new JButton(Preferences.loadLibraryIcon("floppy.gif"));
            newButton.setPreferredSize(new Dimension(20, 20));
            loadButton.setPreferredSize(new Dimension(20, 20));
            saveButton.setPreferredSize(new Dimension(20, 20));
            newButton.setBackground(Preferences.defaultButtonColor());
            loadButton.setBackground(Preferences.defaultButtonColor());
            saveButton.setBackground(Preferences.defaultButtonColor());
            this.impliedTypeBox.setBackground(Preferences.defaultButtonColor());
            this.prefilterTypeChooser.setBackground(Preferences.defaultButtonColor());
            this.rootAlgorithmChooser.setBackground(Preferences.defaultButtonColor());
            newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOProfileEditor.this.objectFilterEditor.setFilter(new CompoundFilterImpl());
                    IOProfileEditor.this.linkFilterEditor.setFilter(new CompoundFilterImpl());
                    IOProfileEditor.this.rebuildPanel();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPair pair = FilterPairEditor.loadFilterPair();
                    if (pair != null) {
                        IOProfileEditor.this.objectFilterEditor.setFilter(pair.getObjectFilter() == null ? new ObjectFilterImpl() : pair.getObjectFilter());
                        IOProfileEditor.this.linkFilterEditor.setFilter(pair.getObjectFilter() == null ? new ObjectFilterImpl() : pair.getObjectFilter());
                        IOProfileEditor.this.filterBox.setSelected(pair.getObjectFilter() != null);
                        IOProfileEditor.this.linkFilterEditor.setEnabled(pair.getLinkFilter() != null);
                        IOProfileEditor.this.rebuildPanel();
                    }
                }
            });
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPairImpl pair = new FilterPairImpl();
                    IOProfileEditor.this.objectFilterEditor.acceptEdits();
                    IOProfileEditor.this.linkFilterEditor.acceptEdits();
                    if (IOProfileEditor.this.filterBox.isSelected()) {
                        pair.setObjectFilter(IOProfileEditor.this.objectFilterEditor.getFilter());
                    }
                    if (IOProfileEditor.this.linkFilterBox.isSelected()) {
                        pair.setLinkFilter(IOProfileEditor.this.linkFilterEditor.getFilter());
                    }
                    FilterPairEditor.save(pair);
                }
            });
            TitledBorder linkBorder = new TitledBorder("Link filtering");
            TitledBorder objectBorder = new TitledBorder("Object filtering");
            TitledBorder remarkBorder = new TitledBorder("OBO File Remark");
            remarkBorder.setTitleFont(Controller.getController().getDefaultFont());
            linkBorder.setTitleFont(Controller.getController().getDefaultFont());
            objectBorder.setTitleFont(Controller.getController().getDefaultFont());
            this.pathField.setFont(Controller.getController().getDefaultFont());
            this.filterBox.setFont(Controller.getController().getDefaultFont());
            this.categoryBox.setFont(Controller.getController().getDefaultFont());
            this.filterTypesBox.setFont(Controller.getController().getDefaultFont());
            this.allowDanglingBox.setFont(Controller.getController().getDefaultFont());
            this.saveImpliedBox.setFont(Controller.getController().getDefaultFont());
            this.realizeImpliedBox.setFont(Controller.getController().getDefaultFont());
            this.linkFilterBox.setFont(Controller.getController().getDefaultFont());
            this.impliedTypeBox.setFont(Controller.getController().getDefaultFont());
            this.idRuleSelector.setFont(Controller.getController().getDefaultFont());
            this.remarkField.setFont(Controller.getController().getDefaultFont());
            this.prefilterBox.setFont(Controller.getController().getDefaultFont());
            this.prefilterTypeChooser.setFont(Controller.getController().getDefaultFont());
            this.rootAlgorithmLabel.setFont(Controller.getController().getDefaultFont());
            this.rootAlgorithmChooser.setFont(Controller.getController().getDefaultFont());
            this.objectFilterEditor.setBorder(objectBorder);
            this.linkFilterEditor.setBorder(linkBorder);
            this.remarkScroller.setBorder(remarkBorder);
            JButton browseButton = new JButton("Browse...");
            browseButton.setFont(Controller.getController().getDefaultFont());
            browseButton.setBackground(Preferences.defaultButtonColor());
            browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File startFile = new File(IOProfileEditor.this.pathField.getText());
                    String startPath = null;
                    if (startFile.exists()) {
                        startPath = startFile.isDirectory() ? startFile.toString() : startFile.getParent();
                    } else if (startFile.getParentFile() != null && startFile.getParentFile().exists()) {
                        startPath = startFile.getParent();
                    }
                    JFileChooser chooser = startPath == null ? new JFileChooser() : new JFileChooser(startPath);
                    if (chooser.showSaveDialog(AdvancedOBOUI.this) == 0) {
                        File file = chooser.getSelectedFile();
                        IOProfileEditor.this.pathField.setText(file.toString());
                        IOProfileEditor.this.editor.commit();
                    }
                }
            });
            JLabel pathLabel = new JLabel("Save path");
            pathLabel.setFont(Controller.getController().getDefaultFont());
            Box labelBox = new Box(0);
            labelBox.add(pathLabel);
            labelBox.add(Box.createHorizontalStrut(10));
            JPanel pathPanel = new JPanel();
            pathPanel.setLayout(new BorderLayout());
            pathPanel.add((Component)labelBox, "West");
            pathPanel.add((Component)this.pathField, "Center");
            pathPanel.add((Component)browseButton, "East");
            pathPanel.setOpaque(false);
            this.add((Component)pathPanel, "North");
            this.panel.setOpaque(false);
            Box checkboxMainPanel = new Box(1);
            Box checkboxPanelA = new Box(0);
            Box checkboxPanelA2 = new Box(0);
            Box checkboxPanelA3 = new Box(0);
            Box checkboxPanelB = new Box(0);
            Box checkboxPanelC = new Box(0);
            checkboxPanelA.add(Box.createHorizontalGlue());
            checkboxPanelA.add(this.filterBox);
            checkboxPanelA.add(Box.createHorizontalStrut(10));
            checkboxPanelA.add(this.filterTypesBox);
            checkboxPanelA.add(Box.createHorizontalStrut(10));
            checkboxPanelA.add(this.linkFilterBox);
            checkboxPanelA.add(Box.createHorizontalStrut(10));
            checkboxPanelA.add(newButton);
            checkboxPanelA.add(loadButton);
            checkboxPanelA.add(saveButton);
            checkboxPanelA2.add(this.prefilterBox);
            checkboxPanelA2.add(this.prefilterTypeChooser);
            checkboxPanelA2.add(Box.createHorizontalStrut(10));
            checkboxPanelA2.add(this.categoryBox);
            checkboxPanelA3.add(this.rootAlgorithmLabel);
            checkboxPanelA3.add(Box.createHorizontalStrut(5));
            checkboxPanelA3.add(this.rootAlgorithmChooser);
            checkboxPanelA3.add(Box.createHorizontalStrut(10));
            checkboxPanelA3.add(this.allowDanglingBox);
            checkboxPanelA.add(Box.createHorizontalGlue());
            checkboxPanelB.add(this.saveImpliedBox);
            checkboxPanelB.add(Box.createHorizontalStrut(10));
            checkboxPanelB.add(this.impliedTypeBox);
            checkboxPanelB.add(Box.createHorizontalStrut(10));
            checkboxPanelB.add(this.realizeImpliedBox);
            checkboxPanelC.add(Box.createHorizontalGlue());
            checkboxPanelC.add(this.idRuleSelector);
            checkboxPanelC.add(Box.createHorizontalGlue());
            checkboxMainPanel.add(checkboxPanelA);
            checkboxMainPanel.add(checkboxPanelA2);
            checkboxMainPanel.add(checkboxPanelA3);
            checkboxMainPanel.add(checkboxPanelB);
            checkboxMainPanel.add(checkboxPanelC);
            JPanel southPanel = new JPanel();
            southPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
            southPanel.setLayout(new BorderLayout());
            southPanel.add((Component)checkboxMainPanel, "South");
            southPanel.add((Component)this.remarkScroller, "Center");
            this.add((Component)this.panel, "Center");
            this.add((Component)southPanel, "South");
            this.filterBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOProfileEditor.this.rebuildPanel();
                }
            });
            this.prefilterBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOProfileEditor.this.rebuildPanel();
                }
            });
            this.linkFilterBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOProfileEditor.this.rebuildPanel();
                }
            });
            this.saveImpliedBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IOProfileEditor.this.impliedTypeBox.setEnabled(IOProfileEditor.this.saveImpliedBox.isSelected());
                    IOProfileEditor.this.realizeImpliedBox.setEnabled(IOProfileEditor.this.saveImpliedBox.isSelected());
                }
            });
            this.rebuildPanel();
            this.setBackground(Preferences.defaultBackgroundColor());
        }

        protected void rebuildPanel() {
            this.panel.remove(this.objectFilterEditor);
            this.panel.remove(this.linkFilterEditor);
            int count = 0;
            if (this.filterBox.isSelected()) {
                this.panel.add(this.objectFilterEditor);
                ++count;
            }
            if (this.linkFilterBox.isSelected()) {
                this.panel.add(this.linkFilterEditor);
                ++count;
            }
            boolean rootAlgorithmControlsEnabled = this.filterBox.isSelected() || this.linkFilterBox.isSelected() || this.prefilterBox.isSelected();
            this.rootAlgorithmLabel.setEnabled(rootAlgorithmControlsEnabled);
            this.rootAlgorithmChooser.setEnabled(rootAlgorithmControlsEnabled);
            this.categoryBox.setEnabled(rootAlgorithmControlsEnabled);
            this.impliedTypeBox.setEnabled(this.saveImpliedBox.isSelected());
            this.realizeImpliedBox.setEnabled(this.saveImpliedBox.isSelected());
            this.prefilterTypeChooser.setEnabled(this.prefilterBox.isSelected());
            this.filterTypesBox.setEnabled(this.filterBox.isSelected());
            if (count < 1) {
                count = 1;
            }
            this.panel.setLayout(new GridLayout(count, 1));
            this.panel.validate();
            this.panel.repaint();
        }

        public Object createNewValue() {
            OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath(new FilterPairImpl(), "<new save path>");
            path.setRemark(Controller.getController().getSession().getCurrentHistory().getComment());
            return path;
        }

        public void load(Object o) {
            if (!(o instanceof OBOSerializationEngine.FilteredPath)) {
                return;
            }
            OBOSerializationEngine.FilteredPath profile = (OBOSerializationEngine.FilteredPath)o;
            this.pathField.setText(profile.getPath());
            this.remarkField.setText(profile.getRemark());
            this.objectFilterEditor.setFilter(profile.getFilterPair().getObjectFilter());
            this.linkFilterEditor.setFilter(profile.getFilterPair().getLinkFilter());
            this.allowDanglingBox.setSelected(profile.getAllowDangling());
            this.saveImpliedBox.setSelected(profile.getSaveImplied());
            this.impliedTypeBox.setSelectedItem(profile.getImpliedType());
            this.realizeImpliedBox.setSelected(profile.getRealizeImpliedLinks());
            this.prefilterBox.setSelected(profile.getPrefilterProperty() != null);
            if (profile.getPrefilterProperty() != null) {
                OBOProperty property = (OBOProperty)Controller.getController().getSession().getObject(profile.getPrefilterProperty());
                this.prefilterTypeChooser.setSelectedItem(property);
            }
            this.rootAlgorithmChooser.setSelectedItem(profile.getRootAlgorithm());
            this.idRuleSelector.setSelectedIndex(profile.getIDRuleMode());
            this.categoryBox.setSelected(profile.getDiscardUnusedCategories());
            this.filterBox.setSelected(profile.getDoFilter());
            this.filterTypesBox.setSelected(profile.getSaveTypes());
            this.linkFilterBox.setSelected(profile.getDoLinkFilter());
            this.rebuildPanel();
        }

        public void setEditable(boolean in) {
        }

        public void store(Object saveme) {
            if (!(saveme instanceof OBOSerializationEngine.FilteredPath)) {
                return;
            }
            OBOSerializationEngine.FilteredPath profile = (OBOSerializationEngine.FilteredPath)saveme;
            profile.setPath(this.pathField.getText());
            profile.setIDRuleMode(this.idRuleSelector.getSelectedIndex());
            if (this.remarkField.getText().trim().length() > 0) {
                profile.setRemark(this.remarkField.getText().trim());
            }
            profile.setAllowDangling(this.allowDanglingBox.isSelected());
            profile.setSaveImplied(this.saveImpliedBox.isSelected());
            profile.setImpliedType((String)this.impliedTypeBox.getSelectedItem());
            profile.setRealizeImpliedLinks(this.realizeImpliedBox.isSelected());
            profile.setDoFilter(this.filterBox.isSelected());
            profile.setSaveTypes(this.filterTypesBox.isSelected());
            profile.setDoLinkFilter(this.linkFilterBox.isSelected());
            if (this.prefilterBox.isSelected()) {
                profile.setPrefilterProperty(((OBOProperty)this.prefilterTypeChooser.getSelectedItem()).getID());
            }
            profile.setDiscardUnusedCategories((this.prefilterBox.isSelected() || this.filterBox.isSelected() || this.linkFilterBox.isSelected()) && this.categoryBox.isSelected());
            profile.setRootAlgorithm((String)this.rootAlgorithmChooser.getSelectedItem());
            this.objectFilterEditor.acceptEdits();
            this.linkFilterEditor.acceptEdits();
            System.err.println("storing objectFilter: " + this.objectFilterEditor.getFilter());
            if (this.filterBox.isSelected()) {
                profile.getFilterPair().setObjectFilter(this.objectFilterEditor.getFilter());
            }
            if (this.linkFilterBox.isSelected()) {
                profile.getFilterPair().setLinkFilter(this.linkFilterEditor.getFilter());
            }
        }
    }
}

