/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.geneontology.oboedit.dataadapter.OBOConstants;
import org.geneontology.oboedit.dataadapter.OBOSerializationEngine;
import org.geneontology.oboedit.dataadapter.OBOSerializer;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.Type;
import org.geneontology.oboedit.datamodel.impl.PropertyValueImpl;

public class OBO_1_2_Serializer
implements OBOSerializer {
    protected PrintStream stream;
    protected List scratch = new ArrayList();
    protected List writeNestedValueScratch = new ArrayList();
    protected Namespace defaultNamespace = new Namespace("<default namespace>");
    protected IdentifiedObject currentObject;

    public void setOutputStream(OutputStream stream) throws IOException {
        this.stream = new PrintStream(stream);
    }

    public void startSerialize() throws IOException {
    }

    public void endSerialize() throws IOException {
    }

    public List getHeaderTagOrdering() {
        return null;
    }

    public List getStanzaOrdering() {
        return null;
    }

    public List getTagOrdering() {
        return null;
    }

    public Comparator getObjectComparator() {
        return null;
    }

    public Comparator getIDComparator() {
        return null;
    }

    public Comparator getDbxrefComparator() {
        return null;
    }

    public Comparator getSynonymComparator() {
        return null;
    }

    public Comparator getSynonymCategoryComparator() {
        return null;
    }

    public Comparator getCategoryComparator() {
        return null;
    }

    public Comparator getXrefComparator() {
        return null;
    }

    public Comparator getObsoleteComparator() {
        return null;
    }

    public Comparator getLinkComparator() {
        return null;
    }

    public static String escapeSpaces(String s) {
        return OBOSerializationEngine.escapeSpaces(s);
    }

    public static String escapeQuoted(String s) {
        return OBOSerializationEngine.escapeQuoted(s, '\"');
    }

    public static String escapeQuoted(String s, char c) {
        return OBOSerializationEngine.escapeQuoted(s, c);
    }

    public static String escapeBeforeQuotes(String s) {
        return OBOSerializationEngine.escapeBeforeQuotes(s);
    }

    public static String escapePVName(String s) {
        return OBOSerializationEngine.escapePVName(s);
    }

    public static String escapePVValue(String s) {
        return OBOSerializationEngine.escapePVValue(s);
    }

    public static String escapeDbxref(String s) {
        return OBOSerializationEngine.escapeDbxref(s);
    }

    public static String escape(String s) {
        return OBOSerializationEngine.escape(s);
    }

    public static String escapeBlocktext(String s) {
        return OBOSerializationEngine.escapeBlocktext(s);
    }

    public void startHeader() throws IOException {
    }

    public void endHeader() throws IOException {
        this.println();
    }

    public void writeFormatVersionHeaderTag() throws IOException {
        this.print("format-version: 1.2\n");
    }

    public void writeDataVersionHeaderTag(String dataVersion) throws IOException {
        this.print("data-version: " + dataVersion + "\n");
    }

    public void writeDateHeaderTag(Date date) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("dd:MM:yyyy HH:mm");
        this.print("date: " + format.format(date) + "\n");
    }

    public void writeSavedByHeaderTag(String user) throws IOException {
        this.print("saved-by: " + user + "\n");
    }

    public void writeAutoGeneratedByHeaderTag(String generatedBy) throws IOException {
        this.println("auto-generated-by: " + generatedBy);
    }

    public void writeSubsetDefHeaderTag(TermCategory category) throws IOException {
        this.print("subsetdef: " + OBO_1_2_Serializer.escapeBeforeQuotes(category.getName()) + " \"" + OBO_1_2_Serializer.escapeQuoted(category.getDesc(), '\"') + "\"\n");
    }

    public void writeNamespaceIDRuleHeaderTag(String ns, String rule) throws IOException {
        String nsName = "*";
        if (ns != null) {
            nsName = ns;
        }
        this.print("namespace-id-rule: " + OBO_1_2_Serializer.escapeSpaces(nsName) + " " + rule + "\n");
    }

    public void writeSynonymTypeDefHeaderTag(SynonymCategory category) throws IOException {
        this.print("synonymtypedef: " + OBO_1_2_Serializer.escapeBeforeQuotes(category.getID()) + " \"" + OBO_1_2_Serializer.escapeQuoted(category.getName()) + "\"");
        if (category.getScope() != -1) {
            this.print(" " + OBO_1_2_Serializer.getScopeStr(category.getScope()));
        }
        this.println();
    }

    public void writeDefaultNamespaceHeaderTag(Namespace namespace) throws IOException {
        this.defaultNamespace = namespace;
        this.print("default-namespace: " + OBO_1_2_Serializer.escape(namespace.getID()) + "\n");
    }

    public void writeRemarkHeaderTag(String remark) throws IOException {
        if (remark == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(remark, "\n");
        while (tokenizer.hasMoreTokens()) {
            String remarkLine = tokenizer.nextToken();
            this.print("remark: " + remarkLine);
            this.println();
        }
    }

    public void startStanza(IdentifiedObject obj) throws IOException {
        if (TermUtil.isClass(obj)) {
            this.print("[Term]\n");
        } else if (TermUtil.isProperty(obj)) {
            this.print("[Typedef]\n");
        } else if (TermUtil.isInstance(obj)) {
            this.print("[Instance]\n");
        } else {
            this.print("[" + obj.getType().getID() + "]\n");
        }
        this.currentObject = obj;
    }

    public void endStanza(IdentifiedObject obj) throws IOException {
        this.println();
        this.currentObject = null;
    }

    public void writeIDTag(String id, NestedValue nv) throws IOException {
        this.print("id: " + id);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeIsAnonymousTag(boolean value, NestedValue nv) throws IOException {
        if (value || nv != null) {
            this.print("is_anonymous: " + value);
            this.writeNestedValue(nv);
            this.println();
        }
    }

    public void writeNameTag(String name, NestedValue nv) throws IOException {
        this.print("name: " + OBO_1_2_Serializer.escape(name));
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeNamespaceTag(Namespace ns, NestedValue nv) throws IOException {
        if (nv == null && (ns == null || ns.equals(this.defaultNamespace))) {
            return;
        }
        if (ns == null) {
            ns = this.defaultNamespace;
        }
        this.print("namespace: " + ns.getID());
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeAltIDTag(String id, NestedValue nv) throws IOException {
        this.print("alt_id: " + id);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeDefTag(String def, Collection dbxrefs, NestedValue nv) throws IOException {
        if (def.length() > 0 || nv != null) {
            this.print("def: \"" + OBO_1_2_Serializer.escapeQuoted(def) + "\"");
            this.writeDbxrefList(dbxrefs);
            this.writeNestedValue(nv);
            this.println();
        }
    }

    public void writeCommentTag(String comment, NestedValue nv) throws IOException {
        if (comment != null && comment.length() > 0 || nv != null) {
            this.print("comment: " + OBO_1_2_Serializer.escapeBlocktext(comment));
            this.writeNestedValue(nv);
            this.println();
        }
    }

    public void writeSubsetTag(TermCategory category, NestedValue nv) throws IOException {
        this.print("subset: " + category.getName());
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeSynonymTag(Synonym syn, NestedValue nv) throws IOException {
        this.print("synonym: \"" + OBO_1_2_Serializer.escapeQuoted(syn.getText()) + "\"");
        if (syn.getScope() != 0 || syn.getScope() != -1 || syn.getSynonymCategory() != null) {
            this.print(" " + OBO_1_2_Serializer.getScopeStr(syn.getScope()));
            if (syn.getSynonymCategory() != null) {
                this.print(" " + syn.getSynonymCategory().getID());
            }
        }
        ArrayList dbxrefs = new ArrayList(syn.getDbxrefs());
        Comparator c = this.getDbxrefComparator();
        if (c == null) {
            c = OBOConstants.DEFAULT_DBXREF_COMPARATOR;
        }
        Collections.sort(dbxrefs, c);
        this.writeDbxrefList(dbxrefs);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeXrefTag(Dbxref ref) throws IOException {
        this.print("xref: ");
        this.writeDbxref(ref);
        this.println();
    }

    public void writeInstanceOfTag(OBOClass type, NestedValue nv) throws IOException {
        this.print("instance_of: " + type.getID());
        this.writeNestedValue(nv);
        this.println();
    }

    public void writePropertyValueTag(PropertyValue pv, NestedValue nv, int depth) throws IOException {
        throw new UnsupportedOperationException("can't write operations");
    }

    public void writeDomainTag(IdentifiedObject domain, NestedValue nv) throws IOException {
        this.print("domain: " + domain.getID());
        this.writeNestedValue(nv);
        this.print(" ! " + domain.getName());
        this.println();
    }

    public void writeRangeTag(Type range, NestedValue nv) throws IOException {
        this.print("range: " + range.getID());
        this.writeNestedValue(nv);
        this.print(" ! " + range.getName());
        this.println();
    }

    public void writeIsCyclicTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_cyclic: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeIsReflexiveTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_reflexive: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeIsSymmetricTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_symmetric: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeIsTransitiveTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_transitive: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeLinkTag(OBORestriction link, NestedValue nv) throws IOException {
        this.scratch.clear();
        if (link.completes()) {
            this.stream.print("intersection_of: ");
            if (!link.getType().equals(OBOProperty.IS_A)) {
                this.stream.print(link.getType().getID() + " ");
            }
        } else if (link.getType().equals(OBOProperty.IS_A)) {
            this.stream.print("is_a: ");
        } else if (link.getType().equals(OBOProperty.DISJOINT_FROM)) {
            this.stream.print("disjoint_from: ");
        } else if (link.getType().equals(OBOProperty.UNION_OF)) {
            this.stream.print("union_of: ");
        } else if (link.getType().equals(OBOProperty.INVERSE_OF)) {
            this.stream.print("inverse_of: ");
        } else {
            if (!link.isNecessarilyTrue()) {
                this.scratch.add(new PropertyValueImpl("necessary", "false"));
            }
            if (link.isInverseNecessarilyTrue()) {
                this.scratch.add(new PropertyValueImpl("inverse_necessary", "true"));
            }
            if (link.getCardinality() != null) {
                this.scratch.add(new PropertyValueImpl("cardinality", link.getCardinality().toString()));
            }
            if (link.getMaxCardinality() != null) {
                this.scratch.add(new PropertyValueImpl("maxCardinality", link.getMaxCardinality().toString()));
            }
            if (link.getMinCardinality() != null) {
                this.scratch.add(new PropertyValueImpl("minCardinality", link.getMinCardinality().toString()));
            }
            this.stream.print("relationship: " + link.getType().getID() + " ");
        }
        if (link.getNamespace() != null && !link.getNamespace().equals(link.getChild().getNamespace())) {
            this.scratch.add(new PropertyValueImpl("namespace", link.getNamespace().toString()));
        }
        if (link.isImplied()) {
            this.scratch.add(new PropertyValueImpl("implied", "true"));
        }
        this.stream.print(link.getParent().getID());
        this.writeNestedValue(nv, this.scratch);
        this.print(" ! " + link.getParent().getName());
        this.println();
    }

    public void writeIsObsoleteTag(boolean value, NestedValue nv) throws IOException {
        if (!value) {
            return;
        }
        this.print("is_obsolete: " + value);
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeReplacedByTag(ObsoletableObject replacedBy, NestedValue nv) throws IOException {
        this.print("replaced_by: " + replacedBy.getID());
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeConsiderTag(ObsoletableObject consider, NestedValue nv) throws IOException {
        this.print("consider: " + consider.getID());
        this.writeNestedValue(nv);
        this.println();
    }

    public void writeUnrecognizedTag(PropertyValue pv) throws IOException {
        this.println(pv.getProperty() + ": " + pv.getValue());
    }

    protected void print(String s) throws IOException {
        this.stream.print(s);
    }

    protected void println(String s) throws IOException {
        this.stream.print(s + "\n");
    }

    protected void println() throws IOException {
        this.stream.print("\n");
    }

    protected static String getScopeStr(int scope) {
        if (scope == -1 || scope == 0) {
            return "RELATED";
        }
        if (scope == 1) {
            return "EXACT";
        }
        if (scope == 3) {
            return "BROAD";
        }
        if (scope == 2) {
            return "NARROW";
        }
        return null;
    }

    protected void writeDbxrefList(Collection dbxrefs) throws IOException {
        this.print(" [");
        Iterator it = dbxrefs.iterator();
        boolean first = true;
        while (it.hasNext()) {
            Dbxref dbxref = (Dbxref)it.next();
            if (!first) {
                this.print(", ");
            }
            this.writeDbxref(dbxref);
            first = false;
        }
        this.print("]");
    }

    protected void writeDbxref(Dbxref dbxref) throws IOException {
        this.print(OBO_1_2_Serializer.escapeDbxref(dbxref.getDatabase()));
        this.print(":");
        this.print(OBO_1_2_Serializer.escapeDbxref(dbxref.getID()));
        if (dbxref.getDesc() != null && dbxref.getDesc().length() > 0) {
            this.print(" \"" + OBO_1_2_Serializer.escapeQuoted(dbxref.getDesc()) + "\"");
        }
        this.writeNestedValue(dbxref.getNestedValue());
    }

    protected void writeNestedValue(NestedValue nv) throws IOException {
        this.writeNestedValue(nv, null);
    }

    protected void writeNestedValue(NestedValue nv, List additionalVals) throws IOException {
        boolean notFirst = false;
        this.writeNestedValueScratch.clear();
        if (nv != null) {
            this.writeNestedValueScratch.addAll(nv.getPropertyValues());
        }
        if (additionalVals != null) {
            this.writeNestedValueScratch.addAll(additionalVals);
        }
        if (this.writeNestedValueScratch.size() == 0 && (nv == null || nv.getSuggestedComment() == null)) {
            return;
        }
        if (this.writeNestedValueScratch.size() > 0) {
            Collections.sort(this.writeNestedValueScratch, PropertyValue.COMPARATOR);
            Iterator it = this.writeNestedValueScratch.iterator();
            this.print(" {");
            while (it.hasNext()) {
                if (notFirst) {
                    this.print(", ");
                }
                PropertyValue pv = (PropertyValue)it.next();
                this.print(OBO_1_2_Serializer.escapePVName(pv.getProperty()) + "=" + OBO_1_2_Serializer.escapePVValue(pv.getValue()));
            }
            this.print("}");
        }
        if (nv != null && nv.getSuggestedComment() != null) {
            this.print(" ! " + nv.getSuggestedComment());
        }
    }

    public String getID() {
        return "OBO 1.2";
    }

    public String toString() {
        return this.getID();
    }
}

