/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.DefaultHistoryList;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkHistoryItem;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.util.ObjectUtil;

public class LinkTypeHistoryItem
extends LinkHistoryItem {
    private static final long serialVersionUID = 4652336581904427325L;
    String relType;

    public LinkTypeHistoryItem() {
        this(null, (String)null);
    }

    public LinkTypeHistoryItem(HistoryItem.StringRelationship rel, String relType) {
        this.rel = rel;
        this.target = null;
        this.type = 15;
        this.setRelType(relType);
    }

    public LinkTypeHistoryItem(Link tr, OBOProperty relType) {
        this.rel = LinkTypeHistoryItem.createStringRelationship(tr);
        this.target = null;
        this.type = 15;
        this.setRelType(relType);
    }

    public List getGraphEditList() {
        Vector<HistoryItem.GraphOperation> out = new Vector<HistoryItem.GraphOperation>();
        out.add(new HistoryItem.GraphOperation(3, new HistoryItem.StringRelationship(this.rel.getParent(), this.rel.getChild(), this.relType)));
        out.add(new HistoryItem.GraphOperation(4, this.rel));
        return out;
    }

    public int hashCode() {
        return LinkTypeHistoryItem.getHash(this.rel) ^ LinkTypeHistoryItem.getHash(this.relType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinkTypeHistoryItem)) {
            return false;
        }
        LinkTypeHistoryItem item = (LinkTypeHistoryItem)o;
        return ObjectUtil.equals((Object)this.rel, (Object)item.getRel()) && ObjectUtil.equals((Object)this.relType, (Object)item.getRelationshipType());
    }

    public String getShortName() {
        return "change relationship";
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

    public void setRelType(OBOProperty type) {
        this.relType = type.getID();
    }

    public String getRelationshipType() {
        return this.relType;
    }

    public String toString() {
        return "Changed relationship of " + this.rel + " to " + this.relType;
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        if (this.rel.canForward(oldID) || ObjectUtil.equals((Object)this.target, (Object)oldID)) {
            DefaultHistoryList out = new DefaultHistoryList();
            Iterator it = newIDs.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                try {
                    LinkTypeHistoryItem newitem = (LinkTypeHistoryItem)this.clone();
                    newitem.getRel().forwardID(oldID, id);
                    if (newitem.getRelationshipType().equals(oldID)) {
                        newitem.setRelType(id);
                    }
                    out.addItem(newitem);
                }
                catch (CloneNotSupportedException e) {}
            }
            return out;
        }
        return null;
    }
}

