/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.util.ObjectUtil;

public class SynonymCategoryHistoryItem
extends HistoryItem {
    private static final long serialVersionUID = 2764272842685200832L;
    protected SynonymCategory oldcat;
    protected SynonymCategory newcat;
    protected boolean isAdd;
    protected boolean isDel;

    public SynonymCategoryHistoryItem() {
        this(null, null, false, false);
    }

    public SynonymCategoryHistoryItem(SynonymCategory oldcat, SynonymCategory newcat, boolean isAdd, boolean isDel) {
        this.type = 17;
        if (oldcat != null) {
            this.oldcat = (SynonymCategory)oldcat.clone();
        }
        if (newcat != null) {
            this.newcat = (SynonymCategory)newcat.clone();
        }
        this.isAdd = isAdd;
        this.isDel = isDel;
    }

    public List getGraphEditList() {
        return Collections.singletonList(new HistoryItem.GraphOperation(1));
    }

    public int hashCode() {
        return SynonymCategoryHistoryItem.getHash(this.oldcat) ^ SynonymCategoryHistoryItem.getHash(this.newcat) ^ SynonymCategoryHistoryItem.getHash(this.isAdd) ^ SynonymCategoryHistoryItem.getHash(this.isDel);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SynonymCategoryHistoryItem)) {
            return false;
        }
        SynonymCategoryHistoryItem item = (SynonymCategoryHistoryItem)o;
        return ObjectUtil.equals((Object)this.oldcat, (Object)item.getOldCategory()) && ObjectUtil.equals((Object)this.newcat, (Object)item.getNewCategory()) && this.isAdd == item.isAdd() && this.isDel == item.isDel();
    }

    public void setOldCat(SynonymCategory oldcat) {
        this.oldcat = oldcat;
    }

    public void setNewCat(SynonymCategory newcat) {
        this.newcat = newcat;
    }

    public void setIsAdd(boolean isAdd) {
        this.isAdd = isAdd;
    }

    public void setIsDel(boolean isDel) {
        this.isDel = isDel;
    }

    public SynonymCategory getOldCategory() {
        return this.oldcat;
    }

    public SynonymCategory getNewCategory() {
        return this.newcat;
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public boolean isDel() {
        return this.isDel;
    }

    public String getShortName() {
        return "Synonym Category Edit";
    }

    public String toString() {
        if (this.isAdd) {
            return "Created synonym category " + this.newcat;
        }
        if (this.isDel) {
            return "Removed synonym category " + this.oldcat;
        }
        return "Changed synonym category " + this.oldcat + " to " + this.newcat;
    }

    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

