/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Iterator;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.impl.MaskedLinkDatabase;

public class RootAlgorithmModeratedLinkDatabase
extends MaskedLinkDatabase {
    private static final long serialVersionUID = -3138882841659656930L;
    protected RootAlgorithm rootAlgorithm;
    protected static final Object NONE = new Object();

    public RootAlgorithmModeratedLinkDatabase() {
    }

    public RootAlgorithmModeratedLinkDatabase(LinkDatabase linkDatabase) {
        this(linkDatabase, null);
    }

    public RootAlgorithmModeratedLinkDatabase(LinkDatabase linkDatabase, RootAlgorithm rootAlgorithm) {
        super(linkDatabase);
        this.setRootAlgorithm(rootAlgorithm);
        this.recache();
    }

    public void setRootAlgorithm(RootAlgorithm rootAlgorithm) {
        this.rootAlgorithm = rootAlgorithm;
    }

    public RootAlgorithm getRootAlgorithm() {
        return this.rootAlgorithm;
    }

    public void recache() {
        super.recache();
        Iterator it = this.linkDatabase.getObjects().iterator();
        while (it.hasNext()) {
            LinkedObject lo;
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject) || !this.rootAlgorithm.isRoot(lo = (LinkedObject)io)) continue;
            this.cacheObject(lo);
        }
    }

    protected void cacheObject(LinkedObject lo) {
        this.setVisible(lo, true);
        Iterator it = this.linkDatabase.getChildren(lo).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            this.cacheObject(link.getChild());
        }
    }
}

