/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.Component;
import java.awt.font.FontRenderContext;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.geneontology.expression.JexlContext;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOTextEditComponent;
import org.geneontology.swing.ComponentNameResolver;
import org.geneontology.swing.XMLLayoutPanel;

public abstract class AbstractTextEditComponent
extends XMLLayoutPanel
implements OBOTextEditComponent,
ComponentNameResolver {
    protected FontRenderContext defaultContext = new FontRenderContext(null, false, false);
    protected IdentifiedObject currentObject;

    public Component resolveName(String id, Properties props, String xml) {
        return new JButton(id);
    }

    public JexlContext getContext() {
        return Controller.getController().getExpressionManager().getContext();
    }

    public void startParseNotify() {
    }

    public void endParseNotify() {
    }

    public void init() {
        this.setDefaultFont(Controller.getController().getDefaultFont());
        this.setDefaultBGColor(Controller.getController().getPreferences().getBackgroundColor());
        this.setDefaultTabColor(Controller.getController().getPreferences().getButtonColor());
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        if (this.useSubLayout()) {
            this.getXMLLayout().setComponentNameResolver(this.getResolver());
            this.getXMLLayout().setContext(this.getContext());
            this.setXMLLayout(this.getDefaultLayout());
        }
        this.installListeners();
        this.initializeGUI();
        this.loadGUI();
        Controller.getController().getTextEditManager().registerComponent(this);
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    public void revert() {
        this.loadGUI();
    }

    protected String getDefaultLayout() {
        return "";
    }

    protected boolean useSubLayout() {
        return false;
    }

    public void setXML(String xml) {
        if (this.useSubLayout() && xml != null && xml.trim().length() > 0 && !this.setXMLLayout(xml)) {
            this.setXMLLayout(this.getDefaultLayout());
        }
    }

    public ComponentNameResolver getResolver() {
        return this;
    }

    protected void initializeGUI() {
    }

    public boolean hasContents() {
        return true;
    }

    public boolean reload() {
        if (this.useSubLayout()) {
            return super.reload();
        }
        return true;
    }

    public void cleanup() {
        Controller.getController().getTextEditManager().unregisterComponent(this);
        this.uninstallListeners();
    }

    public boolean isSingleton() {
        return true;
    }

    public ComponentConfiguration getConfiguration() {
        return null;
    }

    public void setConfiguration(ComponentConfiguration c) {
    }

    public void setController(Controller controller) {
    }

    public JComponent getComponent() {
        return this;
    }

    public void setObject(IdentifiedObject currentObject) {
        this.currentObject = currentObject;
        this.loadGUI();
    }

    protected abstract void loadGUI();
}

