/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreePath;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.GraphicalAdapterChooser;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.dataadapter.IDGenerator;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.OBOSessionImpl;
import org.geneontology.oboedit.gui.CheckWarningComponent;
import org.geneontology.oboedit.gui.ComponentConfiguration;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DefaultInputHandler;
import org.geneontology.oboedit.gui.EditMenuListener;
import org.geneontology.oboedit.gui.FileMenuListener;
import org.geneontology.oboedit.gui.PluginMenuListener;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.SplashScreen;
import org.geneontology.oboedit.gui.event.PluginEvent;
import org.geneontology.oboedit.gui.event.ReconfigEvent;
import org.geneontology.oboedit.gui.event.ReconfigListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.swing.BackgroundImagePanel;
import org.geneontology.swing.SwingUtil;
import org.geneontology.swing.XMLLayout;
import org.geneontology.swing.XMLLayoutPanel;
import org.geneontology.swing.XMLLayoutRoot;
import org.geneontology.util.MultiProperties;
import org.geneontology.util.ObjectUtil;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    JMenuBar menubar;
    JMenu pluginMenu;
    JMenu changeMenu;
    JMenu helpMenu;
    JMenu editMenu;
    JMenuItem undoItem;
    JMenuItem redoItem;
    JMenuItem exportClipboardToFileItem;
    JMenuItem exportClipboardToTerminalItem;
    JMenuItem changeDefaultNamespaceItem;
    JMenuItem newItem;
    JMenuItem loadItem;
    JMenuItem saveItem;
    JMenuItem saveAsItem;
    JMenuItem saveHistoryItem;
    JMenuItem applyHistoryItem;
    JMenuItem importItem;
    JMenuItem importAndTrimItem;
    JMenuItem exportItem;
    JMenuItem exitItem;
    XMLLayoutPanel mainPanel;
    XMLLayout xmllayout;
    protected Controller controller;
    private int[][] dimensionInfo = new int[][]{{620, 460, 160}, {760, 560, 300}, {960, 700, 400}};

    public void exit() {
        this.controller.flushComponentConfig();
        this.controller.flushConfig();
        TermUtil.finalMemoryReport();
        System.exit(0);
    }

    public Controller getController() {
        return this.controller;
    }

    protected void changeDefaultNamespace(Namespace ns) {
        this.controller.getSession().setDefaultNamespace(ns);
    }

    protected void exportClipboardToTerminal() {
        Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            String data = (String)trans.getTransferData(DataFlavor.stringFlavor);
            System.out.println("************* Cliboard Contents *************");
            System.out.println(data);
            System.out.println("*********** End Cliboard Contents ***********");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void exportClipboardToFile() {
        Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            String data = (String)trans.getTransferData(DataFlavor.stringFlavor);
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file " + file, "Overwrite file?", 0) != 0) {
                    return;
                }
                PrintWriter writer = new PrintWriter(new FileWriter(file));
                writer.println(data);
                writer.close();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not save file because of exception " + e.getMessage());
        }
    }

    public MainFrame() {
        super("OBO-Edit version " + Controller.getVersion());
        this.controller = Controller.getController();
        this.controller.getDragController().registerWindow((Window)this);
        this.controller.setFrame(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloser());
        this.controller.setHistory(new OBOSessionImpl());
        this.setContentPane((Container)this.controller.getDragPanel());
        this.setBackground(Preferences.defaultBackgroundColor());
        try {
            SplashScreen splash = new SplashScreen();
            splash.setSize(400, 400);
            SwingUtil.center((Window)splash);
            splash.start();
            this.setCursor(this.controller.getDefaultCursor());
            Font font = this.controller.getDefaultFont();
            this.setFont(font);
            this.menubar = new JMenuBar();
            this.menubar.add(this.buildFileMenu());
            this.editMenu = this.buildEditMenu();
            this.menubar.add(this.editMenu);
            this.pluginMenu = this.buildPluginMenu();
            this.menubar.add(this.pluginMenu);
            this.menubar.add(this.buildHelpMenu());
            this.setJMenuBar(this.menubar);
            XMLLayout layout = Controller.getController().getConfiguredXMLLayout();
            this.mainPanel = new XMLLayoutPanel();
            this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 2), "COMMIT");
            this.mainPanel.getActionMap().put("COMMIT", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent e) {
                    Controller.getController().getTextEditManager().commit();
                }
            });
            this.mainPanel.setFont(this.controller.getDefaultFont());
            Controller.getController().getTextEditManager().registerPanel((XMLLayoutRoot)this.mainPanel);
            this.createListeners();
            this.initGUI();
            this.setXMLLayout(layout);
            this.newOntology();
            splash.join();
            splash.dispose();
            if (this.controller.getAutosaveEnabled()) {
                this.controller.startAutosaveThread();
            }
            Controller.getController().setGUIActive(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void newOntology() {
        int proceed;
        if (this.controller.getSession().isModified() && (proceed = JOptionPane.showConfirmDialog(this, "There are unsaved changes to this ontology. If you create a new ontology, your changes will be discarded. Are you sure you want to proceed?", "Unsaved changes", 0)) != 0) {
            return;
        }
        OBOSessionImpl history = new OBOSessionImpl();
        Namespace ns = new Namespace("default_namespace", System.getProperty("user.home"));
        history.addNamespace(ns);
        history.setDefaultNamespace(ns);
        IDGenerator idGen = Controller.getController().getIDAdapter();
        if (idGen instanceof DefaultIDGenerator) {
            history.setIDProfile(((DefaultIDGenerator)idGen).getProfile());
        }
        this.setRoot(history);
    }

    public void load() {
        int proceed;
        if (Controller.getController().getSession().needsSave() && (proceed = JOptionPane.showConfirmDialog(this, "There are unsaved changes to this ontology. If you load this file, your changes will be discarded. Are you sure you want to proceed?", "Unsaved changes", 0)) != 0) {
            return;
        }
        OBOSession session = Controller.getController().showLoadDialog();
        if (session != null) {
            this.setRoot(session);
            byte condition = (byte)(0x10 | (Controller.getController().getUseReasoner() ? 2 : 0));
            Collection c = Controller.getController().getVerificationEngine().runChecks(Controller.getController().getSession(), null, condition);
            if (c.size() > 0) {
                CheckWarningComponent warningComponent = new CheckWarningComponent();
                warningComponent.setWarnings(c, null, null, true, true, true);
                warningComponent.setPreferredSize(new Dimension(640, 640));
                int dialogType = 2;
                warningComponent.showDialog(this, "Warnings found", dialogType);
            }
        }
    }

    public void saveAs() {
        Collection c = Controller.getController().getVerificationEngine().runChecks(Controller.getController().getSession(), null, (byte)4);
        byte warningConditions = Controller.getController().getVerificationEngine().getWarningConditions();
        int fatalCount = VerificationEngine.countFatal(c);
        int warningCount = c.size() - fatalCount;
        boolean showWarnings = VerificationEngine.getConditionAtField(warningConditions, (byte)4);
        if (fatalCount > 0 || warningCount > 0 && showWarnings) {
            CheckWarningComponent warningComponent = new CheckWarningComponent();
            String header = null;
            String footer = null;
            if (fatalCount > 0) {
                header = "<p>Cannot save because of fatal errors. These errors must be addressed before the save can proceed. A copy of this list of errors - with hyperlinks to the associated terms - can be found on the \"Verification Results\" tab of the Verification Plugin.</p>";
            } else {
                header = "<p>Non-fatal warnings were found. These warnings may be ignored and the save will continue normally. A copy of this list of warnings - with hyperlinks  to the associated terms - can be found on the \"Verification Results\" tab of the Verification Plugin.</p>";
                footer = "Proceed with save?";
            }
            warningComponent.setWarnings(c, header, footer, true, showWarnings, true);
            warningComponent.setPreferredSize(new Dimension(640, 640));
            int dialogType = 2;
            if (fatalCount == 0) {
                dialogType = 1;
            }
            int dialogVal = warningComponent.showDialog(this, fatalCount > 0 ? "Fatal errors found" : "Warnings found", dialogType);
            if (fatalCount > 0 || dialogVal != 1) {
                return;
            }
        }
        try {
            DataAdapterRegistry registry = this.controller.getAdapterRegistry();
            GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, IOOperation.WRITE, (Object)this.controller.getSession());
            gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
            gac.setBackground(Preferences.defaultBackgroundColor());
            gac.setHistoryPath(this.controller.getHistoryFilePath());
            gac.setFont(this.controller.getDefaultFont());
            boolean worked = gac.showDialog("Save ontology", (JFrame)this);
            if (worked) {
                this.controller.getSession().setNeedsSave(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static void changeTRNamespace(Controller controller, Namespace ns) {
        Vector trs = controller.getSelectedTerms();
        TermMacroHistoryItem item = new TermMacroHistoryItem("Changed namespace of multiple term relationships");
        for (int i = 0; i < trs.size(); ++i) {
            Link tr = (Link)trs.get(i);
            TRNamespaceHistoryItem item2 = new TRNamespaceHistoryItem(tr, ns);
            item.addHistoryItem(item2);
        }
        TreePath[] paths = TermUtil.convertPathsToIDs(controller.getSelectedPaths());
        item.setPreSelection(paths);
        item.setPostSelection(paths);
        controller.apply(item);
    }

    public static JMenu getNamespaceChangeMenu(String title, final Controller controller, final boolean noNamespaceAllowed, final NamespaceChanger nc) {
        final JMenu changeNamespace = new JMenu(title);
        changeNamespace.setFont(controller.getDefaultFont());
        changeNamespace.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                changeNamespace.setEnabled(nc.isMenuEnabled());
                changeNamespace.removeAll();
                changeNamespace.setFont(controller.getDefaultFont());
                if (noNamespaceAllowed) {
                    final Namespace ns = null;
                    boolean setBold = nc.isChosen(ns);
                    JMenuItem item = new JMenuItem("<no namespace>");
                    if (setBold) {
                        item.setFont(controller.getDefaultFont().deriveFont(1));
                    } else {
                        item.setFont(controller.getDefaultFont());
                    }
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            nc.changeNamespace(ns);
                        }
                    });
                    item.setEnabled(nc.isEnabled(ns));
                    changeNamespace.add(item);
                }
                Iterator it = controller.getSession().getNamespaces().iterator();
                while (it.hasNext()) {
                    final Namespace ns = (Namespace)it.next();
                    boolean setBold = nc.isChosen(ns);
                    JMenuItem item = new JMenuItem(ns.toString());
                    if (setBold) {
                        item.setFont(controller.getDefaultFont().deriveFont(1));
                    } else {
                        item.setFont(controller.getDefaultFont());
                    }
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            nc.changeNamespace(ns);
                        }
                    });
                    item.setEnabled(nc.isEnabled(ns));
                    changeNamespace.add(item);
                }
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return changeNamespace;
    }

    public void setRoot(OBOSession history) {
        int result;
        IDProfile profile;
        DefaultIDGenerator idGen;
        IDProfile currentProfile;
        history.setIsActive(true);
        if (this.controller.getIDAdapter() instanceof DefaultIDGenerator && (currentProfile = (idGen = (DefaultIDGenerator)this.controller.getIDAdapter()).getProfile()) != null && !TermUtil.equals(currentProfile, profile = history.getIDProfile()) && (result = JOptionPane.showConfirmDialog(this, "The id generation profile in this file\ndoes not match the current id generation profile.\n\nUse the profile loaded from the file?", "ID Profile Mismatch", 0)) == 0) {
            idGen.setProfile(profile);
        }
        this.controller.fireChangeRoot(new RootChangeEvent(this, history));
        this.controller.select((Collection)null);
        this.updateFrameTitle();
        this.repaint();
    }

    public void save() {
        System.err.println("Not currently implemented");
    }

    public void saveHistory() {
        if (!Controller.getController().getTextEditManager().checkUncommittedEdits()) {
            return;
        }
        try {
            DataAdapterRegistry registry = this.controller.getAdapterRegistry();
            GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, OBOEditAdapter.WRITE_HISTORY, (Object)this.controller.getSession());
            gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
            gac.setBackground(Preferences.defaultBackgroundColor());
            gac.setHistoryPath(this.controller.getHistoryFilePath());
            gac.setFont(this.controller.getDefaultFont());
            gac.showDialog("Save history", (JFrame)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void applyHistory() {
        try {
            DataAdapterRegistry registry = this.controller.getAdapterRegistry();
            GraphicalAdapterChooser gac = new GraphicalAdapterChooser(registry, OBOEditAdapter.READ_HISTORY, null);
            gac.setButtonColor(Preferences.defaultButtonColor(), Color.black);
            gac.setBackground(Preferences.defaultBackgroundColor());
            gac.setHistoryPath(this.controller.getHistoryFilePath());
            gac.setFont(this.controller.getDefaultFont());
            boolean worked = gac.showDialog("Load history", (JFrame)this);
            if (worked) {
                List histories = (List)gac.getResult();
                Iterator it = histories.iterator();
                while (it.hasNext()) {
                    HistoryList historyList = (HistoryList)it.next();
                    this.controller.apply(historyList);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JMenu buildPluginMenu() {
        JMenu pluginMenu = new JMenu("Plugins");
        pluginMenu.setFont(this.controller.getDefaultFont());
        pluginMenu.addMenuListener(new PluginMenuListener(this));
        return pluginMenu;
    }

    protected void formatPluginMenu() {
        this.pluginMenu.removeAll();
        if (this.controller.getPlugins().size() == 0) {
            JMenuItem item = new JMenuItem("no plugins installed");
            item.setFont(this.controller.getDefaultFont());
            item.setEnabled(false);
            this.pluginMenu.add(item);
            return;
        }
        for (int i = 0; i < this.controller.getPlugins().size(); ++i) {
            final ComponentPlugin plugin = (ComponentPlugin)this.controller.getPlugins().get(i);
            JMenuItem item = new JMenuItem(plugin.getName());
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.launchPlugin(plugin);
                }
            });
            item.setFont(this.controller.getDefaultFont());
            item.setEnabled(true);
            for (int j = 0; j < this.controller.getActivePlugins().size(); ++j) {
                ComponentPlugin liveplugin = (ComponentPlugin)this.controller.getActivePlugins().elementAt(j);
                if (!plugin.getClass().equals(liveplugin.getClass())) continue;
                item.setEnabled(false);
                break;
            }
            this.pluginMenu.add(item);
        }
    }

    protected void launchPlugin(final ComponentPlugin plugin) {
        try {
            this.controller.firePluginActivate(new PluginEvent(this, plugin));
            MultiProperties props = new MultiProperties();
            try {
                props.load((InputStream)new FileInputStream(this.controller.getHistoryFilePath()));
                props = props.getProperties(plugin.getClass().getName());
            }
            catch (IOException ex) {
                // empty catch block
            }
            plugin.setController(this.controller);
            plugin.init();
            final JDialog window = new JDialog((Frame)this, plugin.getName());
            plugin.setBorder(new EmptyBorder(20, 20, 20, 20));
            window.setContentPane((Container)((Object)plugin));
            this.controller.getDragController().registerWindow((Window)window);
            window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    plugin.cleanup();
                    MainFrame.this.controller.firePluginDeactivate(new PluginEvent(this, plugin));
                    window.dispose();
                    MainFrame.this.controller.getDragController().unregisterWindow((Window)window);
                }
            });
            Map configMap = (Map)Controller.getController().getActiveComponentConfigMap().get("Controller.pluginConfigurations");
            ComponentConfiguration cc = (ComponentConfiguration)configMap.get(plugin.getID());
            if (cc != null) {
                plugin.setConfiguration(cc);
            }
            window.pack();
            window.show();
        }
        catch (Throwable e) {
            System.err.println("Could not load plugin!");
            e.printStackTrace();
        }
    }

    public JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu("File");
        this.newItem = new JMenuItem("New Ontology");
        this.loadItem = new JMenuItem("Load Terms...");
        this.saveItem = new JMenuItem("Save");
        this.saveAsItem = new JMenuItem("Save As...");
        this.saveHistoryItem = new JMenuItem("Save History...");
        this.applyHistoryItem = new JMenuItem("Load History...");
        this.importItem = new JMenuItem("Import Terms...");
        this.importAndTrimItem = new JMenuItem("Import Terms and Strip ids...");
        this.exportItem = new JMenuItem("Export Terms...");
        this.exitItem = new JMenuItem("Exit");
        this.loadItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke("control S"));
        this.newItem.setFont(this.controller.getDefaultFont());
        this.loadItem.setFont(this.controller.getDefaultFont());
        this.saveItem.setFont(this.controller.getDefaultFont());
        this.saveAsItem.setFont(this.controller.getDefaultFont());
        this.saveHistoryItem.setFont(this.controller.getDefaultFont());
        this.applyHistoryItem.setFont(this.controller.getDefaultFont());
        this.importItem.setFont(this.controller.getDefaultFont());
        this.importAndTrimItem.setFont(this.controller.getDefaultFont());
        this.exportItem.setFont(this.controller.getDefaultFont());
        this.exitItem.setFont(this.controller.getDefaultFont());
        fileMenu.setFont(this.controller.getDefaultFont());
        fileMenu.add(this.newItem);
        fileMenu.add(this.loadItem);
        fileMenu.add(this.saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(this.applyHistoryItem);
        fileMenu.add(this.saveHistoryItem);
        fileMenu.addSeparator();
        fileMenu.add(this.exitItem);
        this.newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.newOntology();
            }
        });
        this.loadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.load();
            }
        });
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.save();
            }
        });
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.saveAs();
            }
        });
        this.saveHistoryItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.saveHistory();
            }
        });
        this.applyHistoryItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.applyHistory();
            }
        });
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!Preferences.getPreferences().getConfirmOnExit() || JOptionPane.showConfirmDialog(MainFrame.this, "Really quit OBO-Edit?", "Exit?", 0) == 0) {
                    MainFrame.this.exit();
                }
            }
        });
        fileMenu.addMenuListener(new FileMenuListener(this));
        return fileMenu;
    }

    public JMenu buildTypeChangeMenu() {
        JMenu changeMenu = new JMenu("Change relationship type to");
        return changeMenu;
    }

    public JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpItem = new JMenuItem("User Guide");
        JMenuItem aboutItem = new JMenuItem("About");
        helpItem.setFont(this.controller.getDefaultFont());
        aboutItem.setFont(this.controller.getDefaultFont());
        helpMenu.setFont(this.controller.getDefaultFont());
        if (this.controller.getHelpBroker() != null) {
            helpItem.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.controller.getHelpBroker()));
        } else {
            helpItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(MainFrame.this, "No help files found!");
                }
            });
        }
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final JDialog aboutDialog = new JDialog((Frame)MainFrame.this, "About OBO-Edit");
                BackgroundImagePanel bip = SplashScreen.getSplashPanel();
                bip.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        aboutDialog.dispose();
                    }
                });
                bip.setMaximumSize(new Dimension(400, 400));
                bip.setMinimumSize(new Dimension(400, 400));
                bip.setPreferredSize(new Dimension(400, 400));
                aboutDialog.setResizable(false);
                aboutDialog.setDefaultCloseOperation(2);
                aboutDialog.setContentPane((Container)bip);
                aboutDialog.pack();
                SwingUtil.center((Window)aboutDialog);
                aboutDialog.show();
            }
        });
        helpMenu.add(helpItem);
        helpMenu.add(aboutItem);
        return helpMenu;
    }

    protected void showHelpMenu() {
        this.controller.showURL("file:/home/jrichter/cvs/go-dev/java/oboedit/newdocs/index.html");
    }

    public JMenu buildEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        this.buildEditMenu(editMenu);
        editMenu.addMenuListener(new EditMenuListener(this));
        return editMenu;
    }

    public void buildEditMenu(JMenu editMenu) {
        this.undoItem = new JMenuItem("Undo");
        this.redoItem = new JMenuItem("Redo");
        this.changeDefaultNamespaceItem = MainFrame.getNamespaceChangeMenu("Set default namespace ", this.controller, false, new NamespaceChanger(){

            public void changeNamespace(Namespace ns) {
                MainFrame.this.changeDefaultNamespace(ns);
            }

            public boolean isChosen(Namespace ns) {
                return ns.equals(MainFrame.this.controller.getSession().getDefaultNamespace());
            }

            public boolean isEnabled(Namespace ns) {
                return true;
            }

            public boolean isMenuEnabled() {
                return true;
            }
        });
        JMenu exportClipboardItem = new JMenu("Export clipboard contents");
        this.exportClipboardToFileItem = new JMenuItem("to file");
        this.exportClipboardToTerminalItem = new JMenuItem("to terminal");
        this.undoItem.setFont(this.controller.getDefaultFont());
        this.redoItem.setFont(this.controller.getDefaultFont());
        this.changeDefaultNamespaceItem.setFont(this.controller.getDefaultFont());
        exportClipboardItem.setFont(this.controller.getDefaultFont());
        this.exportClipboardToFileItem.setFont(this.controller.getDefaultFont());
        this.exportClipboardToTerminalItem.setFont(this.controller.getDefaultFont());
        editMenu.setFont(this.controller.getDefaultFont());
        exportClipboardItem.add(this.exportClipboardToFileItem);
        exportClipboardItem.add(this.exportClipboardToTerminalItem);
        editMenu.removeAll();
        editMenu.add(this.undoItem);
        editMenu.add(this.redoItem);
        editMenu.addSeparator();
        editMenu.add(exportClipboardItem);
        editMenu.addSeparator();
        DefaultInputHandler.buildMenu(editMenu, this.controller.getEditActions(), this.controller, false);
        editMenu.addSeparator();
        editMenu.add(this.changeDefaultNamespaceItem);
        try {
            this.exportClipboardToFileItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.exportClipboardToFile();
                }
            });
            this.exportClipboardToTerminalItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.exportClipboardToTerminal();
                }
            });
            this.undoItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.undo();
                }
            });
            this.redoItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.redo();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void formatViewMenu() {
    }

    public void formatFileMenu() {
        this.saveItem.setEnabled(false);
        TreePath[] paths = this.controller.getSelectedPaths();
        this.importItem.setEnabled(paths.length == 1);
        this.importAndTrimItem.setEnabled(paths.length == 1);
        this.exportItem.setEnabled(paths.length == 1);
    }

    public void formatEditMenu() {
        this.buildEditMenu(this.editMenu);
        if (this.controller.canUndo()) {
            if (Controller.getController().getPreferences().getAutoCommitTextEdits() && Controller.getController().getTextEditManager().editsArePending()) {
                this.undoItem.setText("Revert uncommitted text edits");
            } else {
                this.undoItem.setText("Undo " + this.controller.getUndoItem().getShortName());
            }
            this.undoItem.setEnabled(true);
        } else {
            this.undoItem.setText("Undo");
            this.undoItem.setEnabled(false);
        }
        if (this.controller.canRedo()) {
            this.redoItem.setText("Redo " + this.controller.getRedoItem().getShortName());
            this.redoItem.setEnabled(true);
        } else {
            this.redoItem.setText("Redo");
            this.redoItem.setEnabled(false);
        }
    }

    public void undo() {
        this.controller.undo();
        this.repaint();
    }

    public void redo() {
        this.controller.redo();
        this.repaint();
    }

    protected void createListeners() {
        this.controller.addListener(new ReconfigListener(){

            public void configReloaded(ReconfigEvent e) {
                MainFrame.this.setXMLLayout(MainFrame.this.controller.getXMLLayout());
            }
        });
    }

    protected void setXMLLayout(String xml) {
        if (!this.mainPanel.setXMLLayout(xml)) {
            this.mainPanel.setXMLLayout("<xmllayout>\n   <divider orientation=\"HORZ\">\n      <first>\n         <component id=\"DAG\" width=\"300\"/>\n      </first>\n      <second>\n         <divider orientation=\"VERT\">\n            <first>\n               <tabs>\n                  <tab name=\"Search &amp; Filter\">\n                     <panel>\n                        <center>\n                           <component id=\"FIND\"/>\n                        </center>\n                        <south>\n                           <box orientation=\"HORZ\">\n                              <component id=\"SEARCH_BUTTON\" label=\"Ignore obsoletes\" method=\"MODIFY\" filter=\"resource:noobsoletes.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search all\" method=\"MODIFY\" buttonGroup=\"SearchScope\" selected=\"true\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search children of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_children.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search ontology of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_root.filter.xml\"/>\n                           </box>\n                        </south>\n                     </panel>\n                  </tab>\n                  <tab name=\"Parent Plugin\">\n                     <component id=\"plugin:org.geneontology.oboedit.plugin.ParentPlugin\"/>\n                  </tab>\n               </tabs>\n            </first>\n            <second>\n               <component id=\"TEXTEDIT\" width=\"320\"/>\n            </second>\n         </divider>\n      </second>\n   </divider>\n</xmllayout>");
        }
    }

    protected void setXMLLayout(XMLLayout xmllayout) {
        try {
            this.xmllayout = xmllayout;
            System.err.println(">>>> SETTING XMLLAYOUT to " + xmllayout);
            if (!this.mainPanel.setXMLLayout(xmllayout)) {
                xmllayout.setLayout("<xmllayout>\n   <divider orientation=\"HORZ\">\n      <first>\n         <component id=\"DAG\" width=\"300\"/>\n      </first>\n      <second>\n         <divider orientation=\"VERT\">\n            <first>\n               <tabs>\n                  <tab name=\"Search &amp; Filter\">\n                     <panel>\n                        <center>\n                           <component id=\"FIND\"/>\n                        </center>\n                        <south>\n                           <box orientation=\"HORZ\">\n                              <component id=\"SEARCH_BUTTON\" label=\"Ignore obsoletes\" method=\"MODIFY\" filter=\"resource:noobsoletes.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search all\" method=\"MODIFY\" buttonGroup=\"SearchScope\" selected=\"true\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search children of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_children.filter.xml\"/>\n                              <component id=\"SEARCH_BUTTON\" label=\"Search ontology of selection\" method=\"MODIFY\" buttonGroup=\"SearchScope\" filter=\"resource:selection_root.filter.xml\"/>\n                           </box>\n                        </south>\n                     </panel>\n                  </tab>\n                  <tab name=\"Parent Plugin\">\n                     <component id=\"plugin:org.geneontology.oboedit.plugin.ParentPlugin\"/>\n                  </tab>\n               </tabs>\n            </first>\n            <second>\n               <component id=\"TEXTEDIT\" width=\"320\"/>\n            </second>\n         </divider>\n      </second>\n   </divider>\n</xmllayout>");
                this.mainPanel.setXMLLayout(xmllayout);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        MainFrame frame = new MainFrame();
        frame.setVisible(true);
    }

    protected void initGUI() throws Exception {
        int i;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        for (i = 1; i < this.dimensionInfo.length && screenSize.width >= this.dimensionInfo[i][0] && screenSize.height >= this.dimensionInfo[i][1]; ++i) {
        }
        this.setSize(this.dimensionInfo[i - 1][0], this.dimensionInfo[i - 1][1]);
    }

    protected void updateFrameTitle() {
        this.setTitle(this.getFrameTitle());
    }

    protected String getFrameTitle() {
        String out = "OBO-Edit version " + Controller.getVersion();
        OBOSession session = Controller.getController().getSession();
        if (session != null && session.getLoadRemark() != null && session.getLoadRemark().length() > 0) {
            return out + ": " + session.getLoadRemark();
        }
        return out;
    }

    protected static class TRNamespaceChanger
    implements NamespaceChanger {
        protected Controller controller;

        public TRNamespaceChanger(Controller controller) {
            this.controller = controller;
        }

        public void changeNamespace(Namespace ns) {
            MainFrame.changeTRNamespace(this.controller, ns);
        }

        public boolean isChosen(Namespace ns) {
            Vector trs = this.controller.getSelectedTerms();
            for (int i = 0; i < trs.size(); ++i) {
                Link tr = (Link)trs.get(i);
                if (!ObjectUtil.equals((Object)tr.getNamespace(), (Object)ns)) continue;
                return true;
            }
            return false;
        }

        public boolean isMenuEnabled() {
            Iterator it = this.controller.getSelectedTerms().iterator();
            while (it.hasNext()) {
                Link tr = (Link)it.next();
                if (tr.getParent() != null) continue;
                return false;
            }
            return this.controller.getSelectedTerms().size() > 0;
        }

        public boolean isEnabled(Namespace ns) {
            return true;
        }
    }

    public static interface NamespaceChanger {
        public void changeNamespace(Namespace var1);

        public boolean isChosen(Namespace var1);

        public boolean isEnabled(Namespace var1);

        public boolean isMenuEnabled();
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent e) {
            if (!Preferences.getPreferences().getConfirmOnExit() || JOptionPane.showConfirmDialog(MainFrame.this, "Really quit OBO-Edit?", "Exit?", 0) == 0) {
                MainFrame.this.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
            MainFrame.this.exit();
        }
    }
}

