/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DbxrefListEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.swing.DragList;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropAdapter;
import org.geneontology.swing.event.DropListener;

public class SynonymListEditor
extends JPanel
implements GenericEditorComponent {
    private static final long serialVersionUID = 1L;
    JTextField textField;
    JComboBox typeList;
    JComboBox categoryList;
    Object obj;
    ListEditor editor;
    DragList referenceList;
    Controller controller;
    JLabel referenceLabel;
    JButton referenceButton;
    Vector references = new Vector();
    Border lineBorder = new LineBorder(Color.black);
    protected static final String[] TYPES = new String[]{"Related Synonym", "Exact Synonym", "Narrow Synonym", "Broad Synonym"};
    DropListener dropListener = new DropAdapter(){

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof Vector) {
                Vector v = (Vector)e.getData();
                for (int i = 0; i < v.size(); ++i) {
                    if (v.elementAt(i) instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            if (e.getData() instanceof Object[]) {
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    if (v[i] instanceof Dbxref) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            SynonymListEditor.this.referenceList.setBorder(SynonymListEditor.this.lineBorder);
        }

        public void dragExit(DragEvent e) {
            SynonymListEditor.this.referenceList.setBorder(null);
        }

        public void drop(DragEvent e) {
            block3: {
                block2: {
                    SynonymListEditor.this.referenceList.setBorder(null);
                    if (!(e.getData() instanceof Vector)) break block2;
                    Vector v = (Vector)e.getData();
                    for (int i = 0; i < v.size(); ++i) {
                        Dbxref s = (Dbxref)((Dbxref)v.elementAt(i)).clone();
                        s.setType(1);
                        if (SynonymListEditor.this.references.contains(s)) continue;
                        SynonymListEditor.this.references.addElement(s);
                        SynonymListEditor.this.referenceList.setListData(SynonymListEditor.this.references);
                    }
                    break block3;
                }
                if (!(e.getData() instanceof Object[])) break block3;
                Object[] v = (Object[])e.getData();
                for (int i = 0; i < v.length; ++i) {
                    Dbxref s = (Dbxref)((Dbxref)v[i]).clone();
                    s.setType(1);
                    if (SynonymListEditor.this.references.contains(s)) continue;
                    SynonymListEditor.this.references.add(s);
                    SynonymListEditor.this.referenceList.setListData(SynonymListEditor.this.references);
                }
            }
        }
    };

    public SynonymListEditor(Controller controller) {
        this.controller = controller;
        this.setFont(controller.getDefaultFont());
        this.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.textField = new JTextField();
        this.referenceList = new DragList(controller.getDragController());
        this.referenceLabel = new JLabel("DbXrefs");
        this.referenceButton = new JButton("Edit");
        this.typeList = new JComboBox<String>(TYPES);
        this.categoryList = new JComboBox();
        this.referenceLabel.setFont(this.getFont());
        this.referenceButton.setFont(this.getFont());
        this.typeList.setFont(this.getFont());
        this.textField.setFont(this.getFont());
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
        this.initGUI();
        this.attachListeners();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.textField.setEnabled(enable);
        this.typeList.setEnabled(enable);
        this.categoryList.setEnabled(enable);
        this.referenceList.setEnabled(enable);
        this.referenceLabel.setEnabled(enable);
        this.referenceButton.setEnabled(enable);
    }

    public void showDbxrefEditor() {
        JTextArea noDbxLabel = new JTextArea("Select a dbxref from the list to edit it, or press add to create a new dbxref");
        noDbxLabel.setOpaque(false);
        noDbxLabel.setFont(this.controller.getDefaultFont());
        noDbxLabel.setLineWrap(true);
        noDbxLabel.setWrapStyleWord(true);
        noDbxLabel.setEditable(false);
        noDbxLabel.setEnabled(false);
        final JDialog dialog = new JDialog((Frame)null, "Edit synonym dbxrefs", true);
        dialog.setFont(this.controller.getDefaultFont());
        final ListEditor editor = new ListEditor((GenericEditorComponent)new DbxrefListEditor(this.controller, 1), (Component)noDbxLabel, this.references, true, true, true, true, false);
        editor.setOpaque(false);
        editor.setFont(this.controller.getDefaultFont());
        editor.setDragController(this.controller.getDragController());
        editor.setButtonColor(Preferences.defaultButtonColor());
        JButton okButton = new JButton("Ok");
        okButton.setFont(this.controller.getDefaultFont());
        okButton.setBackground(Preferences.defaultButtonColor());
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                editor.commit();
                dialog.setVisible(false);
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)editor, "Center");
        panel.add((Component)buttonPanel, "South");
        panel.setBackground(Preferences.defaultBackgroundColor());
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.show();
        this.referenceList.setListData(this.references);
        this.commit();
    }

    public void setMasterComponent(Component c) {
        if (c instanceof ListEditor) {
            this.editor = (ListEditor)c;
        }
    }

    public void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setOpaque(false);
        this.referenceButton.setPreferredSize(new Dimension((int)this.referenceButton.getPreferredSize().getWidth(), this.referenceButton.getFont().getSize()));
        this.referenceButton.setBackground(Preferences.defaultButtonColor());
        JPanel referenceBox = new JPanel();
        referenceBox.setOpaque(false);
        referenceBox.setLayout(new BoxLayout(referenceBox, 0));
        referenceBox.add(this.referenceLabel);
        referenceBox.add(Box.createHorizontalGlue());
        referenceBox.add(this.referenceButton);
        JLabel textLabel = new JLabel("Synonym text");
        JLabel typeLabel = new JLabel("Synonym scope");
        JLabel categoryLabel = new JLabel("Synonym type");
        textLabel.setFont(this.getFont());
        typeLabel.setFont(this.getFont());
        categoryLabel.setFont(this.getFont());
        this.categoryList.setFont(this.getFont());
        textPanel.add(textLabel);
        textPanel.add(this.textField);
        textPanel.add(Box.createVerticalStrut(5));
        textPanel.add(typeLabel);
        textPanel.add(this.typeList);
        textPanel.add(Box.createVerticalStrut(5));
        textPanel.add(categoryLabel);
        textPanel.add(this.categoryList);
        textPanel.add(Box.createVerticalStrut(5));
        textPanel.add(referenceBox);
        this.typeList.setBackground(Preferences.defaultButtonColor());
        this.categoryList.setBackground(Preferences.defaultButtonColor());
        this.typeList.setAlignmentX(0.0f);
        this.categoryList.setAlignmentX(0.0f);
        categoryLabel.setAlignmentX(0.0f);
        referenceBox.setAlignmentX(0.0f);
        this.textField.setAlignmentX(0.0f);
        textLabel.setAlignmentX(0.0f);
        textPanel.setAlignmentX(0.0f);
        this.referenceButton.setAlignmentX(0.0f);
        this.referenceList.setAlignmentX(0.0f);
        this.referenceLabel.setAlignmentX(0.0f);
        this.referenceList.setFont(this.getFont());
        JScrollPane referencePane = new JScrollPane((Component)this.referenceList, 20, 30);
        this.add((Component)textPanel, "North");
        this.add((Component)referencePane, "Center");
    }

    protected void deleteSelectedReferences() {
        Object[] selected = this.referenceList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            this.references.removeElement(selected[i]);
        }
        this.referenceList.setListData(this.references);
    }

    public void attachListeners() {
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynonymListEditor.this.commit();
            }
        });
        this.categoryList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Synonym syn = (Synonym)SynonymListEditor.this.obj;
                if (SynonymListEditor.this.categoryList.getSelectedIndex() < 1) {
                    SynonymListEditor.this.typeList.setEnabled(SynonymListEditor.this.isEnabled());
                } else {
                    SynonymCategory cat = (SynonymCategory)SynonymListEditor.this.categoryList.getSelectedItem();
                    if (cat.getScope() != -1) {
                        SynonymListEditor.this.typeList.setSelectedIndex(cat.getScope());
                        SynonymListEditor.this.typeList.setEnabled(false);
                    } else {
                        SynonymListEditor.this.typeList.setEnabled(SynonymListEditor.this.isEnabled());
                    }
                }
            }
        });
        this.controller.getDragController().registerDropTarget(new DropTarget((Component)this.referenceList, this.dropListener));
        this.referenceList.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynonymListEditor.this.deleteSelectedReferences();
            }
        }, KeyStroke.getKeyStroke(127, 0), 0);
        this.referenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SynonymListEditor.this.showDbxrefEditor();
            }
        });
    }

    public void commit() {
        this.editor.doStore(this.obj);
        this.editor.refresh();
    }

    public void store(Object in) {
        Synonym syn = (Synonym)in;
        syn.setText(this.textField.getText());
        syn.getDbxrefs().clear();
        Iterator it = this.references.iterator();
        while (it.hasNext()) {
            syn.getDbxrefs().add(it.next());
        }
        syn.setScope(this.typeList.getSelectedIndex());
        if (this.categoryList.getSelectedIndex() < 1) {
            syn.setSynonymCategory(null);
        } else {
            syn.setSynonymCategory((SynonymCategory)this.categoryList.getSelectedItem());
        }
    }

    public Object createNewValue() {
        return this.controller.getSession().getObjectFactory().createSynonym("<new synonym>", 0);
    }

    public void load(Object in) {
        this.obj = in;
        Synonym syn = (Synonym)this.obj;
        this.categoryList.removeAllItems();
        this.categoryList.addItem("<no synonym category>");
        Iterator it = this.controller.getSession().getSynonymCategories().iterator();
        while (it.hasNext()) {
            SynonymCategory cat = (SynonymCategory)it.next();
            this.categoryList.addItem(cat);
        }
        this.textField.setText(syn.getText());
        this.typeList.setSelectedIndex(syn.getScope());
        this.references = new Vector();
        this.references.addAll(syn.getDbxrefs());
        this.referenceList.setListData(this.references);
        if (syn.getSynonymCategory() == null) {
            this.categoryList.setSelectedIndex(0);
        } else {
            this.categoryList.setSelectedItem(syn.getSynonymCategory());
        }
        this.revalidate();
        this.repaint();
    }
}

