/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui.actions;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.TermMergeHistoryItem;
import org.geneontology.oboedit.gui.ClickMenuAction;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.DropMenuAction;
import org.geneontology.oboedit.gui.InputHandlerI;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.swing.KeyRecorder;

public class MergeAction
implements ClickMenuAction,
DropMenuAction,
InputHandlerI {
    protected TreePath[] preSelection;
    protected TreePath[] postSelection = new TreePath[1];
    protected OBOClass master;
    protected OBOClass slave;
    protected boolean isLegal = false;
    protected Controller controller;
    protected volatile TreePath[] scratch;
    protected KeyStroke keyStroke = KeyStroke.getKeyStroke(77, 3);

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isDropAllowed() {
        return true;
    }

    public boolean isClickAllowed() {
        return true;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getName() {
        return "Merge";
    }

    public String getDesc() {
        return "Merging";
    }

    public List getSubActions() {
        return null;
    }

    public int allowDrop(OBOTermPanel sourcePanel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (o instanceof TreePath[] && keyChecker.isDown(77)) {
            this.init((TreePath[])o, dest);
            sourcePanel.setDragTitle("Merge");
            if (this.isLegal()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public boolean drop(OBOTermPanel panel, OBOTermPanel dropPanel, Controller controller, Object o, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        if (o instanceof TreePath[] && keyChecker.isDown(77)) {
            this.init((TreePath[])o, dest);
            if (!this.isLegal()) {
                return false;
            }
            controller.apply(this.execute());
            return true;
        }
        return false;
    }

    public boolean click(OBOTermPanel panel, Controller controller, TreePath dest, MouseEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public boolean press(OBOTermPanel panel, Controller controller, KeyEvent e, KeyRecorder.KeyChecker keyChecker) {
        return false;
    }

    public void clickInit(TreePath[] sourceItems, TreePath destItem) {
        this.init(sourceItems, destItem);
    }

    public void dropInit(TreePath[] sourceItems, TreePath destItem) {
        this.init(sourceItems, destItem);
    }

    public void init(TreePath[] paths, TreePath destPath) {
        TreePath masterPath;
        this.preSelection = paths;
        if (paths == null) {
            this.isLegal = false;
            return;
        }
        if (paths.length != 1 || !(paths[0] instanceof TreePath)) {
            this.isLegal = false;
            return;
        }
        TreePath slavePath = paths[0];
        this.postSelection[0] = masterPath = destPath;
        if (masterPath == null || slavePath == null) {
            this.isLegal = false;
            return;
        }
        if (!(masterPath.getLastPathComponent() instanceof Link) || !(slavePath.getLastPathComponent() instanceof Link)) {
            this.isLegal = false;
            return;
        }
        Link masterLink = (Link)masterPath.getLastPathComponent();
        Link slaveLink = (Link)slavePath.getLastPathComponent();
        if (!(masterLink.getChild() instanceof OBOClass)) {
            this.isLegal = false;
            return;
        }
        if (!(slaveLink.getChild() instanceof OBOClass)) {
            this.isLegal = false;
            return;
        }
        this.init((OBOClass)masterLink.getChild(), (OBOClass)slaveLink.getChild());
    }

    public void init(OBOClass master, OBOClass slave) {
        if (master == null || slave == null) {
            this.isLegal = false;
        } else if (TermUtil.isProperty(master) || TermUtil.isProperty(slave)) {
            this.isLegal = false;
        } else if (TermUtil.isObsolete(master) || TermUtil.isObsolete(slave)) {
            this.isLegal = false;
        } else if (master.equals(slave)) {
            this.isLegal = false;
        } else {
            this.master = master;
            this.slave = slave;
            this.isLegal = true;
        }
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public HistoryItem execute() {
        TermMergeHistoryItem item = new TermMergeHistoryItem(this.master, this.slave);
        item.setPreSelection(TermUtil.convertPathsToIDs(this.preSelection));
        item.setPostSelection(TermUtil.convertPathsToIDs(this.postSelection));
        return item;
    }
}

