/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.dataadapter.FileAdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.io.IOUtil;
import org.geneontology.oboedit.dataadapter.DefaultHistoryDumper;
import org.geneontology.oboedit.dataadapter.OBOEditAdapter;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.dataadapter.XMLHistoryAdapter;
import org.geneontology.oboedit.datamodel.HistoryGenerator;
import org.geneontology.oboedit.datamodel.HistoryList;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.gui.Controller;

public class OBODiff {
    public static void main(String[] args) throws IOException, DataAdapterException {
        Controller.setSuppressInstallations(true);
        Vector<String> filelist = new Vector<String>();
        OBOEditAdapter historyAdapter = null;
        String outPath = null;
        File outFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                if (++i >= args.length) {
                    OBODiff.printUsage();
                    System.exit(1);
                    continue;
                }
                if (args[i].equals("text") || !args[i].equals("xml")) continue;
                historyAdapter = new XMLHistoryAdapter();
                continue;
            }
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    OBODiff.printUsage();
                    System.exit(1);
                }
                outPath = args[i];
                continue;
            }
            filelist.add(args[i]);
        }
        if (filelist.size() != 2) {
            OBODiff.printUsage();
        } else {
            OBOSession a = OBODiff.getHistory((String)filelist.get(0));
            OBOSession b = OBODiff.getHistory((String)filelist.get(1));
            HistoryList changes = HistoryGenerator.getHistory(a, b, null);
            if (historyAdapter == null) {
                historyAdapter = new DefaultHistoryDumper();
            }
            boolean printResults = false;
            if (outPath == null) {
                outFile = File.createTempFile("history", ".dump");
                outPath = outFile.getAbsolutePath();
                outFile.deleteOnExit();
                printResults = true;
            }
            FileAdapterConfiguration adapterConfig = new FileAdapterConfiguration();
            adapterConfig.setWritePath(outPath);
            historyAdapter.doOperation(OBOEditAdapter.WRITE_HISTORY, (AdapterConfiguration)adapterConfig, changes);
            if (printResults) {
                FileInputStream fis = new FileInputStream(outFile);
                IOUtil.dumpAndClose((InputStream)fis, (OutputStream)System.out);
                outFile.delete();
            }
        }
    }

    public static OBOSession getHistory(String path) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(path);
        Object out = adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        return (OBOSession)out;
    }

    public static void printUsage() {
        System.err.println("Usage: obodiff file1 file2");
        System.err.println();
    }
}

