/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IDRule;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DefaultIDRule;
import org.geneontology.oboedit.datamodel.impl.NamedIDProfile;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilterBuilder;
import org.geneontology.oboedit.gui.FilterPairEditor;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterFactory;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.ObjectFilterFactory;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.swing.GenericEditorComponent;
import org.geneontology.swing.ListEditor;

public class IDManagerPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected static Icon customizeIcon = Preferences.loadLibraryIcon("customize.gif");
    protected static Icon minusIcon = Preferences.loadLibraryIcon("minus.gif");
    protected static Icon plusIcon = Preferences.loadLibraryIcon("plus.gif");
    protected JComboBox profileSelector = new JComboBox();
    protected JButton configureButton = new JButton(customizeIcon);
    protected JButton addButton = new JButton(plusIcon);
    protected JButton removeButton = new JButton(minusIcon);
    protected IDProfile currentProfile;
    protected List profiles = null;
    protected ListEditor idList;
    protected JTextField nameField = new JTextField();
    protected JTextField defaultRuleField = new JTextField();
    protected JButton commitButton = new JButton("Commit");
    protected JDialog dialog = new JDialog((Frame)null);
    protected ActionListener selectorListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            IDProfile profile = (IDProfile)IDManagerPlugin.this.profileSelector.getSelectedItem();
            IDManagerPlugin.this.selectProfile(profile);
            IDManagerPlugin.this.saveProfileConfig();
        }
    };

    public IDManagerPlugin() {
        this.profileSelector.addActionListener(this.selectorListener);
        this.configureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IDManagerPlugin.this.configure();
            }
        });
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    IDManagerPlugin.this.saveConfiguration();
                    IDManagerPlugin.this.saveProfileConfig();
                    IDManagerPlugin.this.dialog.setVisible(false);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Controller.getController().getFrame(), ex.getMessage());
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Exception("Add button pressed").printStackTrace();
                NamedIDProfile profile = new NamedIDProfile("<new id profile>");
                if (IDManagerPlugin.this.profiles.contains(profile)) {
                    int counter = 0;
                    do {
                        profile.setName("<new id profile " + ++counter + ">");
                    } while (IDManagerPlugin.this.profiles.contains(profile));
                }
                IDManagerPlugin.this.profiles.add(profile);
                IDManagerPlugin.this.loadProfiles();
                IDManagerPlugin.this.profileSelector.setSelectedItem(profile);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = IDManagerPlugin.this.profiles.indexOf(IDManagerPlugin.this.profileSelector.getSelectedItem());
                IDProfile profileToDelete = (IDProfile)IDManagerPlugin.this.profiles.get(index);
                IDProfile nextProfile = null;
                nextProfile = index == 0 ? (IDProfile)IDManagerPlugin.this.profiles.get(index + 1) : (IDProfile)IDManagerPlugin.this.profiles.get(index - 1);
                IDManagerPlugin.this.selectProfile(nextProfile);
                IDManagerPlugin.this.profiles.remove(profileToDelete);
                IDManagerPlugin.this.saveProfileConfig();
                IDManagerPlugin.this.loadProfiles();
            }
        });
    }

    public void init() {
        Box buttonBox = new Box(0);
        this.setLayout(new BorderLayout());
        this.add(buttonBox, "North");
        this.setBackground(Preferences.defaultBackgroundColor());
        JLabel noRuleLabel = new JLabel("Press 'Add' to create a new rule");
        this.idList = new ListEditor((GenericEditorComponent)new IDRuleEditor(), (Component)noRuleLabel, new Vector(), true, true, true, true, false);
        JLabel nameLabel = new JLabel("Profile name");
        nameLabel.setFont(this.controller.getDefaultFont());
        JLabel defaultRuleLabel = new JLabel("Default rule");
        defaultRuleLabel.setFont(this.controller.getDefaultFont());
        Box namePanel = new Box(0);
        namePanel.add(nameLabel);
        namePanel.add(Box.createHorizontalStrut(10));
        namePanel.add(this.nameField);
        Box defaultRulePanel = new Box(0);
        defaultRulePanel.add(defaultRuleLabel);
        defaultRulePanel.add(Box.createHorizontalStrut(10));
        defaultRulePanel.add(this.defaultRuleField);
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new BoxLayout(configPanel, 1));
        configPanel.add(namePanel);
        configPanel.add(defaultRulePanel);
        configPanel.add((Component)this.idList);
        configPanel.add(this.commitButton);
        configPanel.setBackground(Preferences.defaultBackgroundColor());
        this.dialog.setContentPane(configPanel);
        this.loadProfileConfig();
        this.loadProfiles();
        this.profileSelector.setBackground(Preferences.defaultButtonColor());
        this.configureButton.setBackground(Preferences.defaultButtonColor());
        this.addButton.setBackground(Preferences.defaultButtonColor());
        this.removeButton.setBackground(Preferences.defaultButtonColor());
        this.commitButton.setBackground(Preferences.defaultButtonColor());
        this.configureButton.setPreferredSize(new Dimension(20, 20));
        this.addButton.setPreferredSize(new Dimension(20, 20));
        this.removeButton.setPreferredSize(new Dimension(20, 20));
        this.profileSelector.setMinimumSize(new Dimension(200, 5));
        this.profileSelector.setPreferredSize(new Dimension(200, 20));
        this.profileSelector.setFont(this.controller.getDefaultFont());
        this.nameField.setFont(this.controller.getDefaultFont());
        this.idList.setFont(this.controller.getDefaultFont());
        this.defaultRuleField.setFont(this.controller.getDefaultFont());
        this.commitButton.setFont(this.controller.getDefaultFont());
        this.idList.setButtonColor(Preferences.defaultButtonColor());
        this.idList.setBackground(Preferences.defaultBackgroundColor());
        this.profileSelector.setSelectedItem(this.currentProfile);
        this.selectProfile(this.currentProfile);
        buttonBox.add(this.profileSelector);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.configureButton);
        buttonBox.add(Box.createHorizontalStrut(2));
        buttonBox.add(this.addButton);
        buttonBox.add(Box.createHorizontalStrut(2));
        buttonBox.add(this.removeButton);
    }

    protected void saveProfileConfig() {
        try {
            IDManagerPlugin iDManagerPlugin = this;
            File profileFile = new File(iDManagerPlugin.controller.getPrefsDir(), "idprofiles.xml");
            XMLEncoder encoder = new XMLEncoder(new FileOutputStream(profileFile));
            encoder.writeObject(this.profiles);
            encoder.writeObject(this.currentProfile);
            encoder.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected boolean testRule(String rule) {
        return TermUtil.parseVarString(rule) != null;
    }

    protected void saveConfiguration() throws Exception {
        this.idList.commit();
        if (!this.testRule(this.defaultRuleField.getText())) {
            throw new Exception("Syntax error in default rule \"" + this.defaultRuleField.getText() + "\"");
        }
        Iterator it = this.idList.getData().iterator();
        while (it.hasNext()) {
            IDRule rule = (IDRule)it.next();
            if (this.testRule(rule.getRule())) continue;
            throw new Exception("Syntax error in filtered rule \"" + rule.getRule() + "\"");
        }
        this.currentProfile.setName(this.nameField.getText());
        this.currentProfile.setDefaultRule(this.defaultRuleField.getText());
        this.currentProfile.getRules().clear();
        this.currentProfile.getRules().addAll(this.idList.getData());
        this.profileSelector.repaint();
    }

    protected void configure() {
        Vector v = new Vector();
        v.addAll(this.currentProfile.getRules());
        this.idList.setData(v);
        this.nameField.setText(this.currentProfile.getName());
        this.defaultRuleField.setText(this.currentProfile.getDefaultRule());
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    protected void selectProfile(IDProfile profile) {
        System.err.println("selecting profile " + profile);
        if (profile == null) {
            new Exception("Selected null profile").printStackTrace();
        }
        this.currentProfile = profile;
        if (this.controller.getIDAdapter() instanceof DefaultIDGenerator) {
            DefaultIDGenerator idGen = (DefaultIDGenerator)this.controller.getIDAdapter();
            idGen.setProfile(profile);
        }
    }

    public String getName() {
        return "ID Manager Plugin";
    }

    protected void loadProfileConfig() {
        IDManagerPlugin iDManagerPlugin = this;
        this.profiles = iDManagerPlugin.controller.loadIDProfiles();
        if (this.controller.getIDAdapter() instanceof DefaultIDGenerator) {
            DefaultIDGenerator idGen = (DefaultIDGenerator)this.controller.getIDAdapter();
            this.currentProfile = idGen.getProfile();
        }
    }

    protected void loadProfiles() {
        this.profileSelector.removeActionListener(this.selectorListener);
        this.profileSelector.removeAllItems();
        boolean matched = false;
        IDProfile currentProfile = null;
        if (this.controller.getIDAdapter() instanceof DefaultIDGenerator) {
            DefaultIDGenerator idGen = (DefaultIDGenerator)this.controller.getIDAdapter();
            currentProfile = idGen.getProfile();
        }
        Iterator it = this.profiles.iterator();
        while (it.hasNext()) {
            IDProfile profile = (IDProfile)it.next();
            if (TermUtil.equals(currentProfile, profile)) {
                matched = true;
            }
            this.profileSelector.addItem(profile);
        }
        if (!matched) {
            this.profileSelector.addItem(currentProfile);
            this.profiles.add(currentProfile);
        }
        this.profileSelector.addActionListener(this.selectorListener);
        this.removeButton.setEnabled(this.profiles.size() > 1);
    }

    private class IDRuleEditor
    extends JPanel
    implements GenericEditorComponent {
        private static final long serialVersionUID = 1L;
        protected JTextField ruleField = new JTextField();
        protected FilterBuilder objectFilterEditor = new FilterBuilder();
        protected ListEditor editor;

        public void setMasterComponent(Component c) {
            if (c instanceof ListEditor) {
                this.editor = (ListEditor)c;
            }
        }

        public IDRuleEditor() {
            this.setBackground(Preferences.defaultBackgroundColor());
            JButton newButton = new JButton(Preferences.loadLibraryIcon("file.gif"));
            JButton loadButton = new JButton(Preferences.loadLibraryIcon("folder.gif"));
            JButton saveButton = new JButton(Preferences.loadLibraryIcon("floppy.gif"));
            newButton.setPreferredSize(new Dimension(20, 20));
            loadButton.setPreferredSize(new Dimension(20, 20));
            saveButton.setPreferredSize(new Dimension(20, 20));
            newButton.setBackground(Preferences.defaultButtonColor());
            loadButton.setBackground(Preferences.defaultButtonColor());
            saveButton.setBackground(Preferences.defaultButtonColor());
            newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IDRuleEditor.this.objectFilterEditor.setFilter(new CompoundFilterImpl());
                }
            });
            loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPair pair = FilterPairEditor.loadFilterPair();
                    if (pair != null) {
                        IDRuleEditor.this.objectFilterEditor.setFilter(pair.getObjectFilter() == null ? new ObjectFilterImpl() : pair.getObjectFilter());
                    }
                }
            });
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FilterPairImpl pair = new FilterPairImpl();
                    pair.setObjectFilter(IDRuleEditor.this.objectFilterEditor.getFilter());
                    FilterPairEditor.save(pair);
                }
            });
            Box buttonBox = new Box(1);
            buttonBox.add(newButton);
            buttonBox.add(loadButton);
            buttonBox.add(saveButton);
            buttonBox.add(Box.createVerticalGlue());
            this.objectFilterEditor.setFilterFactory(new ObjectFilterFactory());
            this.objectFilterEditor.setButtonColor(Preferences.defaultButtonColor());
            this.objectFilterEditor.setShowCompoundFilter(true);
            JLabel filterLabel = new JLabel("Parent match filter:");
            filterLabel.setFont(IDManagerPlugin.this.controller.getDefaultFont());
            JPanel filterPanel = new JPanel();
            filterPanel.setBackground(Preferences.defaultBackgroundColor());
            filterPanel.setLayout(new BorderLayout());
            filterPanel.add((Component)filterLabel, "North");
            filterPanel.add((Component)this.objectFilterEditor, "Center");
            filterPanel.add((Component)buttonBox, "East");
            JLabel ruleLabel = new JLabel("ID Rule");
            ruleLabel.setFont(IDManagerPlugin.this.controller.getDefaultFont());
            Box ruleBox = new Box(0);
            ruleBox.add(ruleLabel);
            ruleBox.add(Box.createHorizontalStrut(10));
            ruleBox.add(this.ruleField);
            this.setLayout(new BorderLayout());
            this.add((Component)ruleBox, "South");
            this.add((Component)filterPanel, "Center");
        }

        public void load(Object o) {
            IDRule rule = (IDRule)o;
            this.objectFilterEditor.setFilter(rule.getFilter());
            this.ruleField.setText(rule.getRule());
        }

        public void store(Object o) {
            IDRule rule = (IDRule)o;
            rule.setFilter(this.objectFilterEditor.getFilter());
            rule.setRule(this.ruleField.getText());
        }

        public Object createNewValue() {
            DefaultIDRule rule = new DefaultIDRule();
            CompoundFilter filter = (CompoundFilter)new CompoundFilterFactory().createNewFilter();
            filter.addFilter(new ObjectFilterFactory().createNewFilter());
            rule.setFilter(filter);
            return rule;
        }
    }
}

