/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.event.VerificationEvent;
import org.geneontology.oboedit.gui.event.VerificationListener;
import org.geneontology.oboedit.verify.Check;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.ObjectCheck;
import org.geneontology.oboedit.verify.OntologyCheck;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;

public class VerificationEngine {
    public static final byte TEXT_EDIT_COMMIT = 1;
    public static final byte REASONER_ACTIVATED = 2;
    public static final byte SAVE = 4;
    public static final byte MANUAL = 8;
    public static final byte LOAD = 16;
    public static final byte ALL = 31;
    protected VerificationConfiguration configuration = new VerificationConfiguration();
    protected LinkedList verificationListeners = new LinkedList();
    protected LinkedList progressListeners = new LinkedList();
    protected int percentage;
    protected int chunkSize;
    protected int checkIndex;
    protected int checkCount;
    protected ProgressListener checkProgressListener = new ProgressListener(){

        public void progressMade(ProgressEvent e) {
            int newVal = VerificationEngine.this.percentage + VerificationEngine.this.chunkSize * e.getValue().intValue() / 100;
            String message = "";
            if (e.getDescription() != null) {
                message = "; " + e.getDescription();
            }
            VerificationEngine.this.fireProgressEvent(new ProgressEvent((Object)this, newVal, "Running check " + (VerificationEngine.this.checkIndex + 1) + " of " + VerificationEngine.this.checkCount + message));
        }
    };

    public VerificationConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VerificationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    protected void fireProgressEvent(final ProgressEvent e) {
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            final ProgressListener listener = (ProgressListener)it.next();
            Runnable r = new Runnable(){

                public void run() {
                    listener.progressMade(e);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public void addVerificationListener(VerificationListener listener) {
        this.verificationListeners.add(listener);
    }

    public void removeVerificationListener(VerificationListener listener) {
        this.verificationListeners.remove(listener);
    }

    protected void fireVerificationStartingEvent(final VerificationEvent ve) {
        Iterator it = this.verificationListeners.iterator();
        while (it.hasNext()) {
            final VerificationListener listener = (VerificationListener)it.next();
            Runnable r = new Runnable(){

                public void run() {
                    listener.verificationStarting(ve);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void fireVerificationCompleteEvent(final VerificationEvent ve) {
        Iterator it = this.verificationListeners.iterator();
        while (it.hasNext()) {
            final VerificationListener listener = (VerificationListener)it.next();
            Runnable r = new Runnable(){

                public void run() {
                    listener.verificationComplete(ve);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public void installCheck(Check check) {
        this.configuration.addCheck(check);
    }

    public void removeCheck(Check check) {
        this.configuration.removeCheck(check);
    }

    public byte getWarningConditions() {
        return this.configuration.getWarningConditions();
    }

    public void setWarningConditions(byte warningConditions) {
        this.configuration.setWarningConditions(warningConditions);
    }

    public void setCheckObsoletes(boolean checkObsoletes) {
        this.configuration.setCheckObsoletes(checkObsoletes);
    }

    public boolean getCheckObsoletes() {
        return this.configuration.getCheckObsoletes();
    }

    public Collection getChecks() {
        return this.configuration.getChecks();
    }

    public static void setConditionAtField(Check check, byte field, boolean b) {
        boolean b1 = VerificationEngine.getConditionAtField(check, field);
        if (b1 != b) {
            byte condition = check.getConfiguration().getCondition();
            condition = (byte)(condition ^ field);
            check.getConfiguration().setCondition(condition);
        }
    }

    public static boolean getConditionAtField(Check check, byte field) {
        return VerificationEngine.getConditionAtField(check.getConfiguration().getCondition(), field);
    }

    public static boolean getConditionAtField(byte condition, byte field) {
        return (condition & field) > 0;
    }

    public static boolean isReasonerActivatedCondition(Check check) {
        return VerificationEngine.getConditionAtField(check, (byte)2);
    }

    public static boolean isSaveCondition(Check check) {
        return VerificationEngine.getConditionAtField(check, (byte)4);
    }

    public static boolean isLoadCondition(Check check) {
        return VerificationEngine.getConditionAtField(check, (byte)16);
    }

    public static boolean isManualCondition(Check check) {
        return VerificationEngine.getConditionAtField(check, (byte)8);
    }

    public static boolean isTextCommitCondition(Check check) {
        return VerificationEngine.getConditionAtField(check, (byte)1);
    }

    public static boolean isTextCommitCondition(byte condition) {
        return VerificationEngine.getConditionAtField(condition, (byte)1);
    }

    public static boolean isReasonerActivatedCondition(byte condition) {
        return VerificationEngine.getConditionAtField(condition, (byte)2);
    }

    public static boolean isSaveCondition(byte condition) {
        return VerificationEngine.getConditionAtField(condition, (byte)4);
    }

    public static boolean isManualCondition(byte condition) {
        return VerificationEngine.getConditionAtField(condition, (byte)8);
    }

    protected boolean shouldRun(Check check, byte condition) {
        return (!check.needsReasoner() || check.needsReasoner() && Controller.getController().getUseReasoner()) && (check.getConfiguration().getCondition() & condition) > 0;
    }

    public static String getMessage(Collection warnings, String prefixText, String suffixText, boolean useHTML) {
        boolean isFatal = VerificationEngine.isFatal(warnings);
        StringBuffer out = new StringBuffer();
        if (useHTML) {
            out.append("<html><body>");
        }
        if (prefixText != null) {
            if (useHTML) {
                out.append("<center>");
            }
            out.append(prefixText + "\n");
            if (useHTML) {
                out.append("</center>");
            }
        }
        Iterator it = warnings.iterator();
        int i = 1;
        while (it.hasNext()) {
            CheckWarning warning = (CheckWarning)it.next();
            if (warning.isFatal() == isFatal) {
                if (useHTML) {
                    out.append("<ul>");
                }
                if (useHTML) {
                    out.append("<li> ");
                } else {
                    out.append(i + ") ");
                }
                out.append(warning.getMessage());
                if (useHTML) {
                    out.append("</ul>");
                }
            }
            ++i;
        }
        if (suffixText != null) {
            if (useHTML) {
                out.append("<center>");
            }
            out.append(suffixText + "\n");
            if (useHTML) {
                out.append("</center>");
            }
        }
        if (useHTML) {
            out.append("</body></html>");
        }
        return out.toString();
    }

    public static boolean isFatal(Collection warnings) {
        Iterator it = warnings.iterator();
        while (it.hasNext()) {
            CheckWarning warning = (CheckWarning)it.next();
            if (!warning.isFatal()) continue;
            return true;
        }
        return false;
    }

    public static int countFatal(Collection warnings) {
        int count = 0;
        Iterator it = warnings.iterator();
        while (it.hasNext()) {
            CheckWarning warning = (CheckWarning)it.next();
            if (!warning.isFatal()) continue;
            ++count;
        }
        return count;
    }

    public Collection doRunCheck(Check check, OBOSession session, IdentifiedObject currentObject, byte condition) {
        LinkedList out = new LinkedList();
        if (check.needsReasoner()) {
            check.setReasoner(Controller.getController().getFullReasoner());
        }
        if (check instanceof ObjectCheck) {
            if (currentObject != null) {
                ObjectCheck ocheck = (ObjectCheck)check;
                out.addAll(ocheck.check(session, currentObject, condition, this.getCheckObsoletes()));
            } else {
                Iterator it2 = session.getObjects().iterator();
                int oindex = 0;
                while (it2.hasNext()) {
                    IdentifiedObject io = (IdentifiedObject)it2.next();
                    if (!(io.isBuiltIn() || !this.getCheckObsoletes() && TermUtil.isObsolete(io))) {
                        int newVal = this.percentage + this.chunkSize * oindex / session.getObjects().size();
                        this.fireProgressEvent(new ProgressEvent((Object)this, newVal, "Running check " + (this.checkIndex + 1) + " of " + this.checkCount + ", " + "; checking object " + oindex + " of " + session.getObjects().size()));
                        out.addAll(((ObjectCheck)check).check(session, io, condition, this.getCheckObsoletes()));
                    }
                    ++oindex;
                }
            }
        } else if (check instanceof OntologyCheck) {
            check.addProgressListener(this.checkProgressListener);
            out.addAll(((OntologyCheck)check).check(session, currentObject, condition, this.getCheckObsoletes()));
            check.removeProgressListener(this.checkProgressListener);
        }
        return out;
    }

    public Collection runCheck(Check check, OBOSession session, IdentifiedObject currentObject, byte condition) {
        return this.runChecks(Collections.singleton(check), session, currentObject, condition);
    }

    public Collection runChecks(OBOSession session, IdentifiedObject currentObject, byte condition) {
        LinkedList<Check> liveChecks = new LinkedList<Check>();
        Iterator it = this.configuration.getChecks().iterator();
        while (it.hasNext()) {
            Check check = (Check)it.next();
            if (!this.shouldRun(check, condition)) continue;
            liveChecks.add(check);
        }
        return this.runChecks(liveChecks, session, currentObject, condition);
    }

    public Collection runChecks(Collection liveChecks, OBOSession session, IdentifiedObject currentObject, byte condition) {
        this.fireVerificationStartingEvent(new VerificationEvent(this, null, session, currentObject, condition));
        LinkedList out = new LinkedList();
        this.checkCount = liveChecks.size();
        if (this.checkCount == 0) {
            this.fireVerificationCompleteEvent(new VerificationEvent(this, out, session, currentObject, condition));
            return out;
        }
        this.chunkSize = 100 / this.checkCount;
        Iterator it = liveChecks.iterator();
        this.checkIndex = 0;
        while (it.hasNext()) {
            this.percentage = 100 * this.checkIndex / this.checkCount;
            Check check = (Check)it.next();
            this.fireProgressEvent(new ProgressEvent((Object)this, this.percentage, "Running check " + (this.checkIndex + 1) + " of " + liveChecks.size()));
            out.addAll(this.doRunCheck(check, session, currentObject, condition));
            ++this.checkIndex;
        }
        this.fireVerificationCompleteEvent(new VerificationEvent(this, out, session, currentObject, condition));
        return out;
    }

    public static class VerificationConfiguration {
        protected byte warningConditions = (byte)31;
        protected boolean checkObsoletes = false;
        protected Collection checks = new LinkedList();

        public void setCheckObsoletes(boolean checkObsoletes) {
            this.checkObsoletes = checkObsoletes;
        }

        public boolean getCheckObsoletes() {
            return this.checkObsoletes;
        }

        public byte getWarningConditions() {
            return this.warningConditions;
        }

        public void setWarningConditions(byte warningConditions) {
            this.warningConditions = warningConditions;
        }

        public Collection getChecks() {
            return this.checks;
        }

        public void setChecks(Collection checks) {
            this.checks.clear();
            Iterator it = checks.iterator();
            while (it.hasNext()) {
                Check check = (Check)it.next();
                this.addCheck(check);
            }
        }

        public void addCheck(Check check) {
            if (check != null) {
                this.checks.add(check);
            }
        }

        public void removeCheck(Check check) {
            this.checks.remove(check);
        }
    }
}

