/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.AbstractCheck;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.OntologyCheck;
import org.geneontology.util.ProgressEvent;

public class CycleCheck
extends AbstractCheck
implements OntologyCheck {
    protected void initConfiguration() {
        this.configuration.setCondition((byte)14);
    }

    public Collection check(OBOSession history, IdentifiedObject currentObject, byte condition, boolean checkObsoletes) {
        HashSet<OBOProperty> properties = new HashSet<OBOProperty>();
        Iterator it = history.getRelationshipTypes().iterator();
        while (it.hasNext()) {
            OBOProperty property = (OBOProperty)it.next();
            if (!property.isTransitive() || property.isCyclic()) continue;
            properties.add(property);
        }
        System.err.println("properties = " + properties);
        LinkedList out = new LinkedList();
        if (currentObject != null) {
            if (currentObject instanceof LinkedObject) {
                this.check((LinkedObject)currentObject, properties, out);
            }
        } else {
            it = history.getObjects().iterator();
            int i = 0;
            while (it.hasNext()) {
                Object o = it.next();
                int percentage = 100 * i / history.getObjects().size();
                this.fireProgressEvent(new ProgressEvent((Object)this, percentage, "checking object " + (i + 1) + " of " + history.getObjects().size()));
                if (o instanceof LinkedObject) {
                    LinkedObject lo = (LinkedObject)o;
                    this.check(lo, properties, out);
                }
                ++i;
            }
        }
        return out;
    }

    protected void check(LinkedObject object, Collection properties, List warnings) {
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            OBOProperty property = (OBOProperty)it.next();
            if (!TermUtil.isCycle(Controller.getController().getCurrentLinkDatabase(), property, object)) continue;
            CheckWarning warning = new CheckWarning(object.getName() + " (" + object.getID() + ") " + "is part of a cycle over the property " + property + ". ", true, this, object);
            warnings.add(warning);
        }
    }

    public String getDescription() {
        return "Cycle Check";
    }

    public String getID() {
        return "CYCLE_CHECK";
    }
}

