/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.oboedit.verify.impl.AbstractTextCheck;

public class SynonymCheck
extends AbstractTextCheck {
    public SynonymCheck() {
        this.setAllowNewlines(false);
        this.setAllowBlank(false);
        this.setSentenceStructureChecks(false);
        this.setAllowExtended(Controller.getController().getPreferences().getAllowExtendedCharacters());
    }

    public String getID() {
        return "SYNONYM_CHECK";
    }

    public String getDescription() {
        return "Synonym checks";
    }

    public String getWarningLabel(IdentifiedObject io, byte condition, int index) {
        if (VerificationEngine.isTextCommitCondition(condition)) {
            return "Synonym " + (index > 0 ? index + " " : "");
        }
        return "Synonym " + (index > 0 ? index + " " : "") + "of " + "<a href='file:" + io.getID() + "'>" + io.getID() + "</a>";
    }

    public Collection getStrings(IdentifiedObject io) {
        if (io instanceof SynonymedObject) {
            LinkedList<String> out = new LinkedList<String>();
            Iterator it = ((SynonymedObject)io).getSynonyms().iterator();
            while (it.hasNext()) {
                Synonym s = (Synonym)it.next();
                out.add(s.getText());
            }
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

