/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.objectRuleReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.objectRuleReader.ObjectRuleReaderException;
import psidev.psi.tools.objectRuleReader.mapping.jaxb.ObjectRuleList;

public class ObjectRuleReader {
    public static final Log log = LogFactory.getLog(ObjectRuleReader.class);

    private Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"psidev.psi.tools.objectRuleReader.mapping.jaxb");
        return jc.createUnmarshaller();
    }

    private ObjectRuleList unmarshall(URL url) throws JAXBException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null URL.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (ObjectRuleList)u.unmarshal(url);
    }

    private ObjectRuleList unmarshall(File file) throws JAXBException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing file.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable file.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (ObjectRuleList)u.unmarshal((InputStream)new FileInputStream(file));
    }

    private ObjectRuleList unmarshall(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (ObjectRuleList)u.unmarshal(is);
    }

    private ObjectRuleList unmarshall(String s) throws JAXBException {
        if (s == null) {
            throw new IllegalArgumentException("You must give a non null String.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (ObjectRuleList)u.unmarshal((Reader)new StringReader(s));
    }

    public ObjectRuleList read(String s) throws ObjectRuleReaderException {
        try {
            return this.unmarshall(s);
        }
        catch (JAXBException e) {
            throw new ObjectRuleReaderException(e);
        }
    }

    public ObjectRuleList read(File file) throws ObjectRuleReaderException {
        try {
            return this.unmarshall(file);
        }
        catch (JAXBException e) {
            throw new ObjectRuleReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new ObjectRuleReaderException(e);
        }
    }

    public ObjectRuleList read(InputStream is) throws ObjectRuleReaderException {
        try {
            return this.unmarshall(is);
        }
        catch (JAXBException e) {
            throw new ObjectRuleReaderException(e);
        }
    }

    public ObjectRuleList read(URL url) throws ObjectRuleReaderException {
        try {
            return this.unmarshall(url);
        }
        catch (JAXBException e) {
            throw new ObjectRuleReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new ObjectRuleReaderException(e);
        }
    }
}

