/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Stack;
import psidev.psi.mi.tab.client.batch.FileProcessor;

public class ConvertAllFiles {
    private FileProcessor processor;

    public ConvertAllFiles(FileProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        this.processor = processor;
    }

    public void visit(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("File does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Must be a directory:" + dir.getAbsolutePath());
        }
        Stack<File> stack = new Stack<File>();
        stack.push(dir);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            File[] files = file.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (dir.isDirectory()) {
                        return true;
                    }
                    return name.endsWith(".xml");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                File file1 = files[i];
                if (file1.isDirectory()) {
                    stack.push(file1);
                    continue;
                }
                this.processor.process(file1);
            }
        }
    }
}

