/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrefUtils {
    public static final Log log = LogFactory.getLog(XrefUtils.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public static Collection<DbReference> searchByDatabase(Xref xref, String name, String miRef) {
        if (name == null && miRef == null) {
            throw new IllegalArgumentException("You must give either a name of an MI reference (or both).");
        }
        ArrayList<DbReference> collected = new ArrayList<DbReference>(2);
        List<DbReference> xrefs = XrefUtils.getAllDbReferences(xref);
        for (DbReference reference : xrefs) {
            if (name != null) {
                if (!name.equalsIgnoreCase(reference.getDb())) continue;
                collected.add(reference);
                continue;
            }
            if (miRef == null || !miRef.equalsIgnoreCase(reference.getDbAc())) continue;
            collected.add(reference);
        }
        return collected;
    }

    public static Collection<DbReference> searchByType(Xref xref, String name, String miRef) {
        if (name == null && miRef == null) {
            throw new IllegalArgumentException("You must give either a name of an MI reference (or both).");
        }
        ArrayList<DbReference> collected = new ArrayList<DbReference>(2);
        List<DbReference> xrefs = XrefUtils.getAllDbReferences(xref);
        for (DbReference reference : xrefs) {
            if (name != null) {
                if (!name.equalsIgnoreCase(reference.getRefType())) continue;
                collected.add(reference);
                continue;
            }
            if (miRef == null || !miRef.equalsIgnoreCase(reference.getRefTypeAc())) continue;
            collected.add(reference);
        }
        return collected;
    }

    public static List<DbReference> getAllDbReferences(Xref xref) {
        ArrayList<DbReference> xrefs = new ArrayList<DbReference>();
        xrefs.add(xref.getPrimaryRef());
        if (xref.hasSecondaryRef()) {
            for (DbReference sec : xref.getSecondaryRef()) {
                xrefs.add(sec);
            }
        }
        return xrefs;
    }

    public static boolean hasPsiId(Xref xref, String psiRef) {
        if (psiRef == null || "".equals(psiRef.trim())) {
            throw new IllegalArgumentException("You must give a non null/empty PSI-MI id.");
        }
        if (xref == null) {
            return false;
        }
        List<DbReference> list = XrefUtils.getAllDbReferences(xref);
        for (DbReference ref : list) {
            if (!PSI_MI.equalsIgnoreCase(ref.getDb()) && !PSI_MI_REF.equalsIgnoreCase(ref.getDbAc()) || !psiRef.equalsIgnoreCase(ref.getId())) continue;
            log.debug((Object)("Found Xref( psi-mi, " + psiRef + " )"));
            return true;
        }
        return false;
    }
}

