/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.proteomics.common.cache;

import org.apache.log4j.Logger;
import uk.ac.ebi.proteomics.common.cache.AbstractTimedLRUCache;
import uk.ac.ebi.proteomics.common.cache.Cacheable;
import uk.ac.ebi.proteomics.common.cache.CachedEntry;
import uk.ac.ebi.proteomics.common.cache.NeedsRefreshException;

public class TimedLRUMapCache
extends AbstractTimedLRUCache {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$proteomics$common$cache$TimedLRUMapCache == null ? (class$uk$ac$ebi$proteomics$common$cache$TimedLRUMapCache = TimedLRUMapCache.class$("uk.ac.ebi.proteomics.common.cache.TimedLRUMapCache")) : class$uk$ac$ebi$proteomics$common$cache$TimedLRUMapCache));
    private static TimedLRUMapCache ourInstance;
    static /* synthetic */ Class class$uk$ac$ebi$proteomics$common$cache$TimedLRUMapCache;

    public static TimedLRUMapCache getInstance() {
        if (ourInstance == null) {
            ourInstance = new TimedLRUMapCache();
        }
        return ourInstance;
    }

    private TimedLRUMapCache() {
    }

    public synchronized boolean putInCache(Object object, Object object2) {
        if (object2 instanceof Cacheable) {
            long l = ((Cacheable)object2).getTimestamp();
            if (this.validateTimetamp(l)) {
                this.cacheMap.put(object, object2);
                return true;
            }
            logger.warn((Object)("Tried to cache an expired object:" + object2.toString()));
            return false;
        }
        this.cacheMap.put(object, (Object)new CachedEntry(object2));
        return true;
    }

    public synchronized Cacheable getFromCache(Object object) throws NeedsRefreshException {
        Cacheable cacheable = (Cacheable)this.cacheMap.get(object);
        if (cacheable != null) {
            if (!this.validateTimestamp(cacheable.getTimestamp())) {
                this.cacheMap.remove(object);
                throw new NeedsRefreshException(cacheable);
            }
        } else {
            throw new NeedsRefreshException();
        }
        return cacheable;
    }

    private boolean validateTimetamp(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - l < this.ttl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

