/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.proteomics.common.log;

import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import uk.ac.ebi.proteomics.common.CommonUtilities;

public class LoggerFactory {
    private static boolean isConfigured = false;
    private static boolean configuring = false;
    private static final String LOG4JFILE = "log4j.properties";
    private static final String LOG4JOVERRIDE = "log4j.file";
    private static final String LOG4JPACKAGE = "log4j.package";
    private static final String PROTEOMICS_COMMON_PACKAGE = "proteomics";

    private LoggerFactory() {
    }

    private static void initLog4J(Class clazz) {
        String string = System.getProperty(LOG4JOVERRIDE, LOG4JFILE);
        String string2 = System.getProperty(LOG4JPACKAGE, PROTEOMICS_COMMON_PACKAGE);
        URL uRL = CommonUtilities.getResource(string, string2);
        LoggerFactory.initLog4J(clazz, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLog4J(Class clazz, URL uRL) {
        String string = System.getProperty(LOG4JOVERRIDE, LOG4JFILE);
        configuring = true;
        try {
            System.err.println(clazz.getName() + " called to initiate log4J subsystem");
            if (uRL != null) {
                System.err.println("Configuring logger with " + uRL.toString());
                PropertyConfigurator.configure((URL)uRL);
            } else {
                System.err.println("Configuring logger with " + string);
                PropertyConfigurator.configure((String)string);
            }
        }
        catch (Exception exception) {
            System.err.println("log4j not properly initialized!");
            exception.printStackTrace();
            isConfigured = false;
        }
        finally {
            configuring = false;
        }
        isConfigured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLog4J(Class clazz, Properties properties) {
        block6: {
            configuring = true;
            try {
                System.err.println(clazz.getName() + " called to initiate log4J subsystem");
                if (properties != null) {
                    System.err.println("Configuring logger with properties");
                    PropertyConfigurator.configure((Properties)properties);
                    break block6;
                }
                System.err.println("No properties given, log4j not initialized");
                isConfigured = false;
                configuring = false;
                return;
            }
            catch (Exception exception) {
                System.err.println("log4j not properly initialized!");
                exception.printStackTrace();
                isConfigured = false;
            }
            finally {
                configuring = false;
            }
        }
        isConfigured = true;
    }

    public static synchronized Logger getLogger(Class clazz) {
        if (!isConfigured && !configuring) {
            LoggerFactory.initLog4J(clazz);
        }
        return Logger.getLogger((Class)clazz);
    }

    public static synchronized Logger getLogger(Class clazz, URL uRL) {
        if (!isConfigured && !configuring) {
            LoggerFactory.initLog4J(clazz, uRL);
        }
        return Logger.getLogger((Class)clazz);
    }

    public static synchronized Logger getLogger(Class clazz, Properties properties) {
        if (!isConfigured && !configuring) {
            LoggerFactory.initLog4J(clazz, properties);
        }
        return Logger.getLogger((Class)clazz);
    }
}

